/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.DialogComponentProvider;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.plugin.core.memory.AddBlockModel;
import ghidra.app.plugin.core.misc.RegisterField;
import ghidra.app.util.AddressInput;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.HelpLocation;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class AddBlockDialog
extends DialogComponentProvider
implements ChangeListener {
    private JTextField nameField;
    private AddressInput addrField;
    private RegisterField lengthField;
    private JTextField commentField;
    private JPanel viewPanel;
    private CardLayout typeCardLayout;
    private JRadioButton initializedRB;
    private GRadioButton initializedFromFileBytesRB;
    private JRadioButton uninitializedRB;
    private JCheckBox readCB;
    private JCheckBox writeCB;
    private JCheckBox executeCB;
    private JCheckBox volatileCB;
    private JCheckBox overlayCB;
    private RegisterField initialValueField;
    private JLabel initialValueLabel;
    private AddressFactory addrFactory;
    private AddressInput baseAddrField;
    private IntegerTextField schemeDestByteCountField;
    private IntegerTextField schemeSrcByteCountField;
    private AddBlockModel model;
    private GhidraComboBox<MemoryBlockType> comboBox;
    private boolean updatingInitializedRB;
    private CardLayout initializedTypeCardLayout;
    private static final String MAPPED = "Mapped";
    private static final String UNMAPPED = "Unmapped";
    private static final String UNINITIALIZED = "UNINITIALIZED";
    private static final String INITIALIZED = "INITIALIZED";
    private static final String FILE_BYTES = "FILE_BYTES";
    private JPanel inializedTypePanel;
    private RegisterField fileOffsetField;
    private GhidraComboBox<FileBytes> fileBytesComboBox;

    AddBlockDialog(AddBlockModel model) {
        super("Add Memory Block", true, true, true, false);
        this.model = model;
        model.setChangeListener(this);
        this.setHelpLocation(new HelpLocation("MemoryMapPlugin", "Add Block"));
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setStatusText(this.model.getMessage());
        this.setOkEnabled(this.model.isValidInfo());
        this.readCB.setSelected(this.model.isRead());
        this.writeCB.setSelected(this.model.isWrite());
        this.executeCB.setSelected(this.model.isExecute());
        this.volatileCB.setSelected(this.model.isVolatile());
        this.overlayCB.setSelected(this.model.isOverlay());
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        panel.add(this.buildMainPanel(), "North");
        panel.add(this.buildVariablePanel(), "Center");
        return panel;
    }

    private Component buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildBasicInfoPanel(), "North");
        panel.add(this.buildPermissionsPanel(), "Center");
        panel.add(this.buildTypesPanel(), "South");
        return panel;
    }

    private Component buildBasicInfoPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(4, 10, 150));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 7, 4, 5));
        panel.add((Component)new GLabel("Block Name:", 4));
        panel.add(this.buildNameField());
        panel.add((Component)new GLabel("Start Addr:", 4));
        panel.add(this.buildAddressField());
        panel.add((Component)new GLabel("Length:", 4));
        panel.add(this.buildLengthField());
        panel.add((Component)new GLabel("Comment:", 4));
        panel.add(this.buildCommentField());
        return panel;
    }

    private Component buildPermissionsPanel() {
        this.readCB = new GCheckBox("Read");
        this.readCB.setName("Read");
        this.readCB.setSelected(this.model.isRead());
        this.readCB.addActionListener(e -> this.model.setRead(this.readCB.isSelected()));
        this.writeCB = new GCheckBox("Write");
        this.writeCB.setName("Write");
        this.writeCB.setSelected(this.model.isWrite());
        this.writeCB.addActionListener(e -> this.model.setWrite(this.writeCB.isSelected()));
        this.executeCB = new GCheckBox("Execute");
        this.executeCB.setName("Execute");
        this.executeCB.setSelected(this.model.isExecute());
        this.executeCB.addActionListener(e -> this.model.setExecute(this.executeCB.isSelected()));
        this.volatileCB = new GCheckBox("Volatile");
        this.volatileCB.setName("Volatile");
        this.volatileCB.setSelected(this.model.isVolatile());
        this.volatileCB.addActionListener(e -> this.model.setVolatile(this.volatileCB.isSelected()));
        this.overlayCB = new GCheckBox("Overlay");
        this.overlayCB.setName("Overlay");
        this.overlayCB.setSelected(this.model.isOverlay());
        this.overlayCB.addActionListener(e -> this.model.setOverlay(this.overlayCB.isSelected()));
        JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 30, 20, 30));
        panel.add(this.readCB);
        panel.add(this.writeCB);
        panel.add(this.executeCB);
        panel.add(this.volatileCB);
        panel.add(this.overlayCB);
        return panel;
    }

    private Component buildTypesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Block Types"));
        Object[] items = new MemoryBlockType[]{MemoryBlockType.DEFAULT, MemoryBlockType.BIT_MAPPED, MemoryBlockType.BYTE_MAPPED};
        this.comboBox = new GhidraComboBox(items);
        this.comboBox.addItemListener(e -> this.blockTypeSelected());
        panel.add((Component)this.comboBox);
        return panel;
    }

    private Component buildVariablePanel() {
        this.typeCardLayout = new CardLayout();
        this.viewPanel = new JPanel(this.typeCardLayout);
        this.viewPanel.setBorder(BorderFactory.createEtchedBorder());
        this.viewPanel.add((Component)this.buildMappedPanel(), MAPPED);
        this.viewPanel.add(this.buildUnmappedPanel(), UNMAPPED);
        this.typeCardLayout.show(this.viewPanel, UNMAPPED);
        return this.viewPanel;
    }

    private Component buildUnmappedPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.buildInitializedRadioButtonPanel(), "North");
        panel.add(this.buildVariableInitializedPanel());
        return panel;
    }

    private Component buildInitializedRadioButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(10));
        ButtonGroup radioGroup = new ButtonGroup();
        this.initializedRB = new GRadioButton("Initialized", false);
        this.initializedRB.setName(this.initializedRB.getText());
        this.initializedRB.addActionListener(ev -> this.initializeRBChanged());
        this.initializedFromFileBytesRB = new GRadioButton("File Bytes", false);
        this.initializedFromFileBytesRB.setName(this.initializedRB.getText());
        this.initializedFromFileBytesRB.addActionListener(ev -> this.initializeRBChanged());
        this.uninitializedRB = new GRadioButton("Uninitialized", true);
        this.uninitializedRB.setName(this.uninitializedRB.getText());
        this.uninitializedRB.addActionListener(ev -> this.initializeRBChanged());
        radioGroup.add(this.initializedRB);
        radioGroup.add((AbstractButton)this.initializedFromFileBytesRB);
        radioGroup.add(this.uninitializedRB);
        panel.add(this.initializedRB);
        panel.add((Component)this.initializedFromFileBytesRB);
        panel.add(this.uninitializedRB);
        return panel;
    }

    private Component buildVariableInitializedPanel() {
        this.initializedTypeCardLayout = new CardLayout();
        this.inializedTypePanel = new JPanel(this.initializedTypeCardLayout);
        this.inializedTypePanel.add((Component)new JPanel(), UNINITIALIZED);
        this.inializedTypePanel.add(this.buildInitalValuePanel(), INITIALIZED);
        this.inializedTypePanel.add(this.buildFileBytesPanel(), FILE_BYTES);
        return this.inializedTypePanel;
    }

    private Component buildInitalValuePanel() {
        this.initialValueLabel = new GDLabel("Initial Value");
        this.initialValueField = new RegisterField(8, null, false);
        this.initialValueField.setName("Initial Value");
        this.initialValueField.setChangeListener(e -> this.initialValueChanged());
        JPanel panel = new JPanel((LayoutManager)new PairLayout(4, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 7, 4, 5));
        panel.add(this.initialValueLabel);
        panel.add(this.initialValueField);
        return panel;
    }

    private Component buildFileBytesPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 7, 4, 5));
        panel.add((Component)new GLabel("File Bytes:"));
        panel.add(this.buildFileBytesCombo());
        panel.add((Component)new GLabel("File Offset:"));
        panel.add(this.buildFileOffsetField());
        return panel;
    }

    private Component buildFileBytesCombo() {
        Memory memory = this.model.getProgram().getMemory();
        List allFileBytes = memory.getAllFileBytes();
        FileBytes[] fileBytes = allFileBytes.toArray(new FileBytes[allFileBytes.size()]);
        this.fileBytesComboBox = new GhidraComboBox<FileBytes>(fileBytes){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = 100;
                return preferredSize;
            }
        };
        this.fileBytesComboBox.addItemListener(e -> this.fileBytesChanged());
        if (!allFileBytes.isEmpty()) {
            this.model.setFileBytes((FileBytes)allFileBytes.get(0));
        }
        return this.fileBytesComboBox;
    }

    void showDialog(PluginTool tool) {
        this.nameField.setText("");
        this.addrField.setAddress(this.model.getStartAddress());
        this.lengthField.setValue(0L);
        this.model.setLength(0L);
        this.commentField.setText("");
        this.initialValueField.setValue(0L);
        this.model.setBlockType(MemoryBlockType.DEFAULT);
        this.model.setInitializedType(AddBlockModel.InitializedType.UNINITIALIZED);
        this.model.setInitialValue(0);
        this.readCB.setSelected(this.model.isRead());
        this.writeCB.setSelected(this.model.isWrite());
        this.executeCB.setSelected(this.model.isExecute());
        this.volatileCB.setSelected(this.model.isVolatile());
        this.overlayCB.setSelected(this.model.isOverlay());
        this.setOkEnabled(false);
        tool.showDialog((DialogComponentProvider)this, tool.getComponentProvider("Memory Map"));
    }

    public void dispose() {
        super.dispose();
        this.model.dispose();
    }

    protected void okCallback() {
        if (this.model.execute()) {
            this.close();
        } else {
            this.setStatusText(this.model.getMessage());
            this.setOkEnabled(false);
        }
    }

    private void initializeRBChanged() {
        if (this.updatingInitializedRB) {
            return;
        }
        if (this.initializedRB.isSelected()) {
            this.model.setInitializedType(AddBlockModel.InitializedType.INITIALIZED_FROM_VALUE);
            this.initializedTypeCardLayout.show(this.inializedTypePanel, INITIALIZED);
        } else if (this.uninitializedRB.isSelected()) {
            this.model.setInitializedType(AddBlockModel.InitializedType.UNINITIALIZED);
            this.initializedTypeCardLayout.show(this.inializedTypePanel, UNINITIALIZED);
        } else if (this.initializedFromFileBytesRB.isSelected()) {
            this.model.setInitializedType(AddBlockModel.InitializedType.INITIALIZED_FROM_FILE_BYTES);
            this.initializedTypeCardLayout.show(this.inializedTypePanel, FILE_BYTES);
        }
    }

    private void initialValueChanged() {
        int initialValue = -1;
        Long val = this.initialValueField.getValue();
        if (val != null) {
            initialValue = val.intValue();
        }
        this.model.setInitialValue(initialValue);
    }

    private void nameChanged() {
        String name = this.nameField.getText().trim();
        this.model.setBlockName(name);
    }

    private void commentChanged() {
        String comment = this.commentField.getText().trim();
        this.model.setComment(comment);
    }

    private void lengthChanged() {
        long length = 0L;
        Long val = this.lengthField.getValue();
        if (val != null) {
            length = val;
        }
        this.model.setLength(length);
    }

    private void fileOffsetChanged() {
        long fileOffset = -1L;
        Long val = this.fileOffsetField.getValue();
        if (val != null) {
            fileOffset = val;
        }
        this.model.setFileOffset(fileOffset);
    }

    private void fileBytesChanged() {
        this.model.setFileBytes((FileBytes)this.fileBytesComboBox.getSelectedItem());
    }

    private void addrChanged() {
        Address addr = null;
        try {
            addr = this.addrField.getAddress();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.model.setStartAddress(addr);
    }

    private void baseAddressChanged() {
        Address addr = null;
        try {
            addr = this.baseAddrField.getAddress();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.model.setBaseAddress(addr);
    }

    private void schemeSrcByteCountChanged() {
        int value = this.schemeSrcByteCountField.getIntValue();
        this.model.setSchemeSrcByteCount(value);
    }

    private void schemeDestByteCountChanged() {
        int value = this.schemeDestByteCountField.getIntValue();
        this.model.setSchemeDestByteCount(value);
    }

    private void blockTypeSelected() {
        MemoryBlockType blockType = (MemoryBlockType)this.comboBox.getSelectedItem();
        this.model.setBlockType(blockType);
        if (blockType == MemoryBlockType.DEFAULT) {
            this.typeCardLayout.show(this.viewPanel, UNMAPPED);
        } else {
            this.enableByteMappingSchemeControls(blockType == MemoryBlockType.BYTE_MAPPED);
            this.schemeDestByteCountField.setValue(this.model.getSchemeDestByteCount());
            this.schemeSrcByteCountField.setValue(this.model.getSchemeSrcByteCount());
            this.typeCardLayout.show(this.viewPanel, MAPPED);
        }
    }

    private void enableByteMappingSchemeControls(boolean b) {
        this.schemeDestByteCountField.setValue(1);
        this.schemeDestByteCountField.setEnabled(b);
        this.schemeSrcByteCountField.setValue(1);
        this.schemeSrcByteCountField.setEnabled(b);
    }

    private JPanel buildMappedPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        this.baseAddrField = new AddressInput();
        this.baseAddrField.setAddressFactory(this.addrFactory);
        this.baseAddrField.setName("Source Addr");
        this.baseAddrField.addChangeListener(ev -> this.baseAddressChanged());
        JPanel schemePanel = new JPanel(new FlowLayout(0));
        this.schemeDestByteCountField = new IntegerTextField(4, 1L);
        this.schemeDestByteCountField.setAllowNegativeValues(false);
        this.schemeDestByteCountField.setAllowsHexPrefix(false);
        this.schemeDestByteCountField.setDecimalMode();
        this.schemeDestByteCountField.addChangeListener(ev -> this.schemeDestByteCountChanged());
        this.schemeSrcByteCountField = new IntegerTextField(4, 1L);
        this.schemeSrcByteCountField.setAllowNegativeValues(false);
        this.schemeSrcByteCountField.setAllowsHexPrefix(false);
        this.schemeSrcByteCountField.setDecimalMode();
        this.schemeSrcByteCountField.addChangeListener(ev -> this.schemeSrcByteCountChanged());
        schemePanel.add(this.schemeDestByteCountField.getComponent());
        schemePanel.add((Component)new GLabel(" : "));
        schemePanel.add(this.schemeSrcByteCountField.getComponent());
        Program program = this.model.getProgram();
        Address minAddr = program.getMinAddress();
        if (minAddr == null) {
            minAddr = program.getAddressFactory().getDefaultAddressSpace().getAddress(0L);
        }
        this.baseAddrField.setAddress(minAddr);
        this.model.setBaseAddress(minAddr);
        panel.add((Component)new GLabel("Source Address:"));
        panel.add(this.baseAddrField);
        panel.add((Component)new GLabel("Mapping Ratio:"));
        panel.add(schemePanel);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private Component buildCommentField() {
        this.commentField = new JTextField();
        this.commentField.setName("Comment");
        this.commentField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddBlockDialog.this.commentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddBlockDialog.this.commentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddBlockDialog.this.commentChanged();
            }
        });
        return this.commentField;
    }

    private Component buildLengthField() {
        this.lengthField = new RegisterField(36, null, false);
        this.lengthField.setName("Length");
        this.lengthField.setChangeListener(e -> this.lengthChanged());
        return this.lengthField;
    }

    private Component buildFileOffsetField() {
        this.fileOffsetField = new RegisterField(60, null, false);
        this.fileOffsetField.setName("File Offset");
        this.fileOffsetField.setChangeListener(e -> this.fileOffsetChanged());
        return this.fileOffsetField;
    }

    private Component buildAddressField() {
        this.addrField = new AddressInput();
        this.addrField.setName("Start Addr");
        this.addrFactory = this.model.getProgram().getAddressFactory();
        this.addrField.setAddressFactory(this.addrFactory, true, true);
        this.addrField.addChangeListener(ev -> this.addrChanged());
        return this.addrField;
    }

    private Component buildNameField() {
        this.nameField = new JTextField();
        this.nameField.setName("Block Name");
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddBlockDialog.this.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddBlockDialog.this.nameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddBlockDialog.this.nameChanged();
            }
        });
        return this.nameField;
    }
}

