/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.RowData;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

class DataTypeSyncTableModel
extends AbstractSortedTableModel<RowData> {
    static final int CHECKED_COL = 0;
    static final int STATUS_COL = 1;
    static final int NAME_COL = 2;
    static final int REF_PATH_COL = 3;
    static final int CHANGE_TIME_COL = 4;
    private String[] columnNames = new String[]{"Apply", "Status", "Datatype", "Category Path", "Change Time"};
    private final List<RowData> rowDataList;
    private final boolean showSourceChangeTime;

    DataTypeSyncTableModel(List<DataTypeSyncInfo> list, Set<DataTypeSyncInfo> preselectedInfos, boolean showSourceChangeTime) {
        this.showSourceChangeTime = showSourceChangeTime;
        this.rowDataList = new ArrayList<RowData>(list.size());
        for (DataTypeSyncInfo dataTypeSyncInfo : list) {
            this.rowDataList.add(new RowData(dataTypeSyncInfo, preselectedInfos.contains(dataTypeSyncInfo)));
        }
    }

    public String getName() {
        return "Datatype Sync";
    }

    public int getRowCount() {
        return this.rowDataList.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Object getColumnValueForRow(RowData rowData, int columnIndex) {
        DataTypeSyncInfo syncInfo = rowData.syncInfo;
        switch (columnIndex) {
            case 0: {
                return rowData.isSelected();
            }
            case 1: {
                return syncInfo.getSyncState();
            }
            case 2: {
                return syncInfo.getName();
            }
            case 4: {
                return syncInfo.getLastChangeTimeString(this.showSourceChangeTime);
            }
            case 3: {
                return syncInfo.getRefDtPath();
            }
        }
        return null;
    }

    public List<RowData> getModelData() {
        return this.rowDataList;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.rowDataList.get(rowIndex).setSelected((Boolean)value);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        if (columnIndex == 1) {
            return DataTypeSyncState.class;
        }
        return String.class;
    }

    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public DataTypeSyncInfo getSyncInfo(int selectedIndex) {
        return this.rowDataList.get((int)selectedIndex).syncInfo;
    }

    public void selectAll() {
        for (RowData rowData : this.rowDataList) {
            rowData.setSelected(true);
        }
        this.fireTableDataChanged();
    }

    public void deselectAll() {
        for (RowData rowData : this.rowDataList) {
            rowData.setSelected(false);
        }
        this.fireTableDataChanged();
    }

    public boolean hasUnresolvedDataTypes() {
        for (RowData rowData : this.rowDataList) {
            if (rowData.isSelected()) continue;
            return true;
        }
        return false;
    }

    public List<DataTypeSyncInfo> getSelectedItems() {
        ArrayList<DataTypeSyncInfo> selectedItems = new ArrayList<DataTypeSyncInfo>();
        for (RowData rowData : this.rowDataList) {
            if (!rowData.isSelected()) continue;
            selectedItems.add(rowData.syncInfo);
        }
        return selectedItems;
    }

    protected Comparator<RowData> createSortComparator(int columnIndex) {
        return new RowDataSorter(columnIndex);
    }

    class RowDataSorter
    implements Comparator<RowData> {
        private final int sortColumn;

        public RowDataSorter(int sortColumn) {
            this.sortColumn = sortColumn;
        }

        @Override
        public int compare(RowData rowData1, RowData rowData2) {
            int compareVal = 0;
            DataTypeSyncInfo syncInfo1 = rowData1.syncInfo;
            DataTypeSyncInfo syncInfo2 = rowData2.syncInfo;
            switch (this.sortColumn) {
                case 0: {
                    compareVal = this.compareState(rowData1.isSelected(), rowData2.isSelected());
                    break;
                }
                case 1: {
                    compareVal = SystemUtilities.compareTo((Comparable)((Object)syncInfo1.getSyncState()), (Comparable)((Object)syncInfo2.getSyncState()));
                    break;
                }
                case 2: {
                    compareVal = syncInfo1.getName().compareTo(syncInfo2.getName());
                    break;
                }
                case 3: {
                    compareVal = syncInfo1.getRefDtPath().compareTo(syncInfo2.getRefDtPath());
                    break;
                }
                case 4: {
                    compareVal = this.compareDates(syncInfo1.getLastChangeTime(DataTypeSyncTableModel.this.showSourceChangeTime), syncInfo2.getLastChangeTime(DataTypeSyncTableModel.this.showSourceChangeTime));
                }
            }
            return compareVal;
        }

        private int compareState(boolean can1, boolean can2) {
            if (can1 == can2) {
                return 0;
            }
            return can1 ? -1 : 1;
        }

        private int compareDates(long date1, long date2) {
            if (date1 < date2) {
                return -1;
            }
            if (date1 > date2) {
                return 1;
            }
            return 0;
        }
    }
}

