/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.util.datatype.EmptyCompositeException;
import ghidra.program.model.data.InvalidDataTypeException;
import javax.swing.Icon;

public class ApplyAction
extends CompositeEditorTableAction {
    public static final String ACTION_NAME = "Apply Editor Changes";
    private static final String GROUP_NAME = "1_BASIC_EDITOR_ACTION";
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.apply");
    private static final String[] POPUP_PATH = new String[]{"Apply Edits"};

    public ApplyAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Apply Editor Changes", GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription("Apply editor changes");
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        if (!this.model.isValidName()) {
            this.model.setStatus("Name is not valid.", true);
            return;
        }
        try {
            this.model.apply();
        }
        catch (EmptyCompositeException | InvalidDataTypeException e) {
            this.model.setStatus(e.getMessage(), true);
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        boolean hasChanges = this.model.hasChanges();
        boolean validName = this.model.isValidName();
        this.setEnabled(hasChanges && validName);
    }
}

