/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.label.GLabel;
import generic.theme.GThemeDefaults;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.ResolveConflictChangeEvent;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.MaximizeSpecificColumnGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;

public class VariousChoicesPanel
extends ConflictPanel {
    private static final long serialVersionUID = 1L;
    private static final Border UNDERLINE_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)GThemeDefaults.Colors.BORDER);
    private JPanel rowPanel;
    private GDHtmlLabel headerLabel;
    private ArrayList<ChoiceRow> rows;
    private Border radioButtonBorder;
    private Border checkBoxBorder;
    private int columnCount = 1;
    private MaximizeSpecificColumnGridLayout layout;
    private int indent;

    public VariousChoicesPanel() {
        this.init();
    }

    public VariousChoicesPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder("Resolve Conflict"));
        this.rows = new ArrayList();
        this.layout = new MaximizeSpecificColumnGridLayout(5, 5, this.columnCount);
        this.rowPanel = new JPanel((LayoutManager)this.layout);
        this.rowPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.headerLabel = new GDHtmlLabel(" ");
        this.headerLabel.setHorizontalAlignment(0);
        this.add((Component)this.headerLabel, "North");
        this.setHeader(null);
        MyRadioButton rb = new MyRadioButton("W");
        MyCheckBox cb = new MyCheckBox("W");
        MyLabel lbl = new MyLabel("W");
        this.indent = Math.max(rb.getPreferredSize().width, cb.getPreferredSize().width);
        int radioButtonOffset = (rb.getPreferredSize().height - lbl.getPreferredSize().height) / 2;
        int checkBoxOffset = (cb.getPreferredSize().height - lbl.getPreferredSize().height) / 2;
        this.radioButtonBorder = BorderFactory.createEmptyBorder(radioButtonOffset > 0 ? radioButtonOffset : 0, 0, 0, 0);
        this.checkBoxBorder = BorderFactory.createEmptyBorder(checkBoxOffset > 0 ? checkBoxOffset : 0, 0, 0, 0);
        this.add((Component)this.createUseForAllCheckBox(), "South");
        this.adjustUseForAllEnablement();
    }

    void setTitle(String conflictType) {
        ((TitledBorder)this.getBorder()).setTitle("Resolve " + conflictType + " Conflict");
    }

    void setHeader(String text) {
        if (text != null && text.length() != 0) {
            this.headerLabel.setText(ConflictUtility.wrapAsHTML(text));
            this.add((Component)this.headerLabel, "North");
        } else {
            this.headerLabel.setText("");
            this.remove((Component)this.headerLabel);
        }
        this.validate();
        this.invalidate();
    }

    private void adjustColumnCount(int numberOfColumns) {
        if (numberOfColumns <= 0) {
            numberOfColumns = 1;
        }
        if (this.columnCount != numberOfColumns) {
            this.columnCount = numberOfColumns;
            this.layout = new MaximizeSpecificColumnGridLayout(5, 5, this.columnCount);
            this.rowPanel.setLayout((LayoutManager)this.layout);
        }
    }

    void addInfoRow(String title, String[] info, boolean underline) {
        this.adjustColumnCount(info.length);
        MyLabel titleComp = new MyLabel(title);
        if (underline) {
            titleComp.setBorder(UNDERLINE_BORDER);
        }
        MyLabel[] labels = new MyLabel[info.length];
        for (int i = 0; i < info.length; ++i) {
            labels[i] = new MyLabel(info[i]);
            if (!underline) continue;
            labels[i].setBorder(UNDERLINE_BORDER);
        }
        ChoiceRow noChoiceRow = new ChoiceRow(titleComp, (JComponent[])labels);
        this.addRow(noChoiceRow);
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
        this.adjustUseForAllEnablement();
    }

    void addSingleChoice(String title, String[] choices, ChangeListener listener) {
        this.adjustColumnCount(choices.length + 1);
        for (int i = 0; i < choices.length; ++i) {
            if (choices[i] == null) {
                choices[i] = "-- none --";
                continue;
            }
            if (choices[i].length() != 0) continue;
            choices[i] = "-- empty --";
        }
        MyLabel titleComp = new MyLabel(title);
        MyRadioButton[] rb = new MyRadioButton[choices.length];
        int row = this.rows.size();
        ChoiceRow choiceRow = new ChoiceRow(titleComp, (JComponent[])rb);
        ItemListener itemListener = e -> {
            Object source;
            this.adjustUseForAllEnablement();
            if (listener != null && ((MyRadioButton)((Object)((Object)(source = e.getSource())))).isSelected()) {
                ResolveConflictChangeEvent re = new ResolveConflictChangeEvent(source, row, choiceRow.getChoice());
                listener.stateChanged(re);
            }
        };
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < choices.length; ++i) {
            rb[i] = new MyRadioButton(choices[i]);
            rb[i].setName("ChoiceComponentRow" + row + "Col" + (i + 1));
            group.add((AbstractButton)((Object)rb[i]));
            rb[i].addItemListener(itemListener);
        }
        if (choices.length > 0) {
            titleComp.setBorder(this.radioButtonBorder);
        }
        this.addRow(choiceRow);
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
        this.adjustUseForAllEnablement();
    }

    void addMultipleChoice(String title, String[] choices, ChangeListener listener) {
        this.adjustColumnCount(choices.length + 1);
        MyLabel titleComp = new MyLabel(title);
        MyCheckBox[] cb = new MyCheckBox[choices.length];
        int row = this.rows.size();
        ChoiceRow choiceRow = new ChoiceRow(titleComp, (JComponent[])cb);
        ItemListener itemListener = e -> {
            this.adjustUseForAllEnablement();
            if (listener != null) {
                ResolveConflictChangeEvent re = new ResolveConflictChangeEvent(e.getSource(), row, choiceRow.getChoice());
                listener.stateChanged(re);
            }
        };
        for (int i = 0; i < choices.length; ++i) {
            cb[i] = new MyCheckBox(choices[i]);
            cb[i].setName(this.getComponentName(row, i + 1));
            cb[i].addItemListener(itemListener);
        }
        if (choices.length > 0) {
            titleComp.setBorder(this.checkBoxBorder);
        }
        this.addRow(choiceRow);
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
        this.adjustUseForAllEnablement();
    }

    String getComponentName(int row, int column) {
        return "ChoiceComponentRow" + row + "Col" + column;
    }

    private void addRow(ChoiceRow choiceRow) {
        int row = this.rows.size();
        this.rows.add(choiceRow);
        this.rowPanel.add((Component)((Object)choiceRow.titleLabel));
        for (JComponent element : choiceRow.rb) {
            this.rowPanel.add(element);
        }
        if (row == 0) {
            this.add((Component)this.rowPanel, "Center");
        }
    }

    private void removeRow(int rowNum) {
        JComponent[] comps;
        ChoiceRow cr = this.rows.get(rowNum);
        this.rowPanel.remove((Component)((Object)cr.titleLabel));
        for (JComponent comp : comps = cr.rb) {
            this.rowPanel.remove(comp);
        }
        this.rows.remove(rowNum);
    }

    @Override
    public int getUseForAllChoice() {
        if (this.rows == null || this.rows.isEmpty()) {
            return 0;
        }
        int firstChoice = -1;
        for (ChoiceRow cr : this.rows) {
            int currentChoice = cr.getChoice();
            if (!cr.hasChoices()) continue;
            if (currentChoice == 0) {
                return 0;
            }
            if (firstChoice == -1) {
                firstChoice = currentChoice;
                continue;
            }
            if (currentChoice == firstChoice) continue;
            return 0;
        }
        return firstChoice != -1 ? firstChoice : 0;
    }

    @Override
    public boolean allChoicesAreResolved() {
        for (ChoiceRow cr : this.rows) {
            if (!cr.hasChoices() || cr.getChoice() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allChoicesAreSame() {
        if (this.rows == null || this.rows.isEmpty()) {
            return false;
        }
        int firstChoice = -1;
        for (ChoiceRow cr : this.rows) {
            int currentChoice = cr.getChoice();
            if (!cr.hasChoices()) continue;
            if (currentChoice == 0) {
                return false;
            }
            if (firstChoice == -1) {
                firstChoice = currentChoice;
                continue;
            }
            if (currentChoice == firstChoice) continue;
            return false;
        }
        return firstChoice != -1;
    }

    @Override
    public int getNumConflictsResolved() {
        int count = 0;
        for (ChoiceRow cr : this.rows) {
            if (cr.getChoice() == 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void removeAllListeners() {
        for (ChoiceRow cr : this.rows) {
            this.removeListeners(cr);
        }
    }

    private void removeListeners(ChoiceRow cr) {
        for (JComponent comp : cr.rb) {
            int j;
            ItemListener[] listeners;
            if (comp instanceof MyRadioButton) {
                MyRadioButton rb = (MyRadioButton)((Object)comp);
                listeners = rb.getItemListeners();
                for (j = listeners.length - 1; j >= 0; --j) {
                    rb.removeItemListener(listeners[j]);
                }
            }
            if (!(comp instanceof MyCheckBox)) continue;
            MyCheckBox cb = (MyCheckBox)((Object)comp);
            listeners = cb.getItemListeners();
            for (j = listeners.length - 1; j >= 0; --j) {
                cb.removeItemListener(listeners[j]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeAllListeners();
        int numRows = this.rows.size();
        for (int i = numRows - 1; i >= 0; --i) {
            this.removeRow(i);
        }
        this.setHeader(null);
        this.columnCount = 1;
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
        this.adjustUseForAllEnablement();
    }

    public void adjustUseForAllEnablement() {
        boolean enable = this.allChoicesAreSame();
        if (!enable) {
            this.setUseForAll(false);
        }
        this.useForAllCB.setEnabled(enable);
    }

    @Override
    public boolean hasChoice() {
        return this.rows.size() > 0;
    }

    private class MyRadioButton
    extends GRadioButton {
        private static final long serialVersionUID = 1L;

        public MyRadioButton(String text) {
            super(text);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    String displayedText = MyRadioButton.this.getText();
                    if (displayedText == null) {
                        MyRadioButton.this.setToolTipText(null);
                        return;
                    }
                    int displayedWidth = MyRadioButton.this.getWidth() - VariousChoicesPanel.this.indent;
                    Font displayedFont = MyRadioButton.this.getFont();
                    FontMetrics fontMetrics = displayedFont != null ? MyRadioButton.this.getFontMetrics(displayedFont) : null;
                    int stringWidth = fontMetrics != null ? fontMetrics.stringWidth(displayedText) : 0;
                    MyRadioButton.this.setToolTipText(stringWidth > displayedWidth ? displayedText : null);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }
    }

    private class MyCheckBox
    extends GCheckBox {
        private static final long serialVersionUID = 1L;

        public MyCheckBox(String text) {
            super(text);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    String displayedText = MyCheckBox.this.getText();
                    if (displayedText == null) {
                        MyCheckBox.this.setToolTipText(null);
                        return;
                    }
                    int displayedWidth = MyCheckBox.this.getWidth() - VariousChoicesPanel.this.indent;
                    Font displayedFont = MyCheckBox.this.getFont();
                    FontMetrics fontMetrics = displayedFont != null ? MyCheckBox.this.getFontMetrics(displayedFont) : null;
                    int stringWidth = fontMetrics != null ? fontMetrics.stringWidth(displayedText) : 0;
                    MyCheckBox.this.setToolTipText(stringWidth > displayedWidth ? displayedText : null);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }
    }

    private class MyLabel
    extends GLabel {
        public MyLabel(final String text) {
            super(text);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    String displayedText = MyLabel.this.getText();
                    if (displayedText == null) {
                        MyLabel.this.setToolTipText(null);
                        return;
                    }
                    int displayedWidth = MyLabel.this.getWidth();
                    Font displayedFont = MyLabel.this.getFont();
                    FontMetrics fontMetrics = displayedFont != null ? MyLabel.this.getFontMetrics(displayedFont) : null;
                    int stringWidth = fontMetrics != null ? fontMetrics.stringWidth(displayedText) : 0;
                    MyLabel.this.setToolTipText(stringWidth > displayedWidth ? "<html>" + HTMLUtilities.escapeHTML((String)text) : null);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }
    }

    class ChoiceRow {
        MyLabel titleLabel;
        JComponent[] rb;

        ChoiceRow(MyLabel titleLabel, JComponent[] rb) {
            this.titleLabel = titleLabel;
            this.rb = rb;
        }

        int[] getWidths() {
            int[] widths = new int[this.rb.length + 1];
            widths[0] = this.titleLabel.getWidth();
            for (int i = 0; i < this.rb.length; ++i) {
                widths[i + 1] = this.rb[i].getWidth();
            }
            return widths;
        }

        int getHeight() {
            int height = this.titleLabel.getHeight();
            return height;
        }

        int getChoice() {
            int choice = 0;
            for (int i = 0; i < this.rb.length; ++i) {
                if (this.rb[i] instanceof MyRadioButton && ((MyRadioButton)((Object)this.rb[i])).isSelected()) {
                    choice |= 1 << i;
                }
                if (!(this.rb[i] instanceof MyCheckBox) || !((MyCheckBox)((Object)this.rb[i])).isSelected()) continue;
                choice |= 1 << i;
            }
            return choice;
        }

        boolean hasChoices() {
            for (JComponent element : this.rb) {
                if (!(element instanceof MyRadioButton) && !(element instanceof MyCheckBox)) continue;
                return true;
            }
            return false;
        }
    }
}

