/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;

public class PinSymbolCmd
implements Command {
    private Address addr;
    private String name;
    private boolean pin;
    private String message;

    public PinSymbolCmd(Address addr, String name, boolean pin) {
        this.addr = addr;
        this.name = name;
        this.pin = pin;
    }

    public boolean applyTo(DomainObject obj) {
        SymbolTable symbolTable = ((Program)obj).getSymbolTable();
        Symbol symbol = symbolTable.getGlobalSymbol(this.name, this.addr);
        if (symbol == null) {
            this.message = "Could not find symbol named " + this.name + " at address " + this.addr;
            return false;
        }
        symbol.setPinned(this.pin);
        return true;
    }

    public String getStatusMsg() {
        return this.message;
    }

    public String getName() {
        return "Set Pinned on " + this.name;
    }
}

