/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.FunctionRenameOption;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class ApplyFunctionSignatureCmd
extends BackgroundCommand {
    private Address entryPt;
    private SourceType source;
    private FunctionRenameOption functionRenameOption;
    private boolean preserveCallingConvention;
    private FunctionSignature signature;
    private Program program;

    public ApplyFunctionSignatureCmd(Address entry, FunctionSignature signature, SourceType source) {
        this(entry, signature, source, false, FunctionRenameOption.RENAME_IF_DEFAULT);
    }

    @Deprecated(since="10.3", forRemoval=true)
    public ApplyFunctionSignatureCmd(Address entry, FunctionSignature signature, SourceType source, boolean preserveCallingConvention, boolean forceSetName) {
        this(entry, signature, source, preserveCallingConvention, forceSetName ? FunctionRenameOption.RENAME : FunctionRenameOption.RENAME_IF_DEFAULT);
    }

    public ApplyFunctionSignatureCmd(Address entry, FunctionSignature signature, SourceType source, boolean preserveCallingConvention, FunctionRenameOption functionRenameOption) {
        super("Create Function", true, false, false);
        this.entryPt = entry;
        this.signature = signature;
        this.source = source;
        this.preserveCallingConvention = preserveCallingConvention;
        this.functionRenameOption = functionRenameOption;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        Function func = this.program.getListing().getFunctionContaining(this.entryPt);
        if (func == null) {
            return false;
        }
        monitor.setMessage("Rename " + func.getName());
        try {
            this.setSignature(func);
        }
        catch (InvalidInputException e) {
            Msg.warn((Object)((Object)this), (Object)e.getMessage());
            this.setStatusMsg(e.getMessage());
            return false;
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            this.setStatusMsg("Invalid signature");
            return false;
        }
        return true;
    }

    private boolean setSignature(Function func) throws InvalidInputException {
        String name = this.signature.getName();
        this.setName(func, name);
        CompilerSpec compilerSpec = this.program.getCompilerSpec();
        String conventionName = this.getCallingConvention(func, compilerSpec);
        ParameterDefinition[] args = this.signature.getArguments();
        List<Parameter> params = this.createParameters(compilerSpec, conventionName, args);
        SymbolTable symbolTable = this.program.getSymbolTable();
        try {
            this.adjustParameterNamesToAvoidConflicts(symbolTable, func, params);
            ReturnParameterImpl returnParam = new ReturnParameterImpl(this.signature.getReturnType(), this.program);
            func.updateFunction(conventionName, (Variable)returnParam, params, Function.FunctionUpdateType.DYNAMIC_STORAGE_FORMAL_PARAMS, false, this.source);
            func.setVarArgs(this.signature.hasVarArgs());
            if (this.signature.hasNoReturn()) {
                func.setNoReturn(this.signature.hasNoReturn());
            }
        }
        catch (DuplicateNameException e) {
            throw new InvalidInputException("Parameter name conflict, likely due to concurrent operation");
        }
        ApplyFunctionSignatureCmd.updateStackPurgeSize(func, this.program);
        return true;
    }

    private List<Parameter> createParameters(CompilerSpec compilerSpec, String conventionName, ParameterDefinition[] args) throws InvalidInputException {
        int firstParamIndex = this.getIndexOfFirstParameter(conventionName, args);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        boolean settleCTypes = compilerSpec.doesCDataTypeConversions();
        ProgramBasedDataTypeManager dtm = this.program.getDataTypeManager();
        for (int i = firstParamIndex; i < args.length; ++i) {
            String name = args[i].getName();
            if (Function.RETURN_PTR_PARAM_NAME.equals(name)) continue;
            DataType type = args[i].getDataType().clone((DataTypeManager)dtm);
            if (settleCTypes) {
                type = ApplyFunctionSignatureCmd.settleCDataType(type, (DataTypeManager)dtm);
            }
            ParameterImpl param = new ParameterImpl(name, type, VariableStorage.UNASSIGNED_STORAGE, this.program);
            param.setComment(args[i].getComment());
            params.add((Parameter)param);
        }
        return params;
    }

    private void adjustParameterNamesToAvoidConflicts(SymbolTable symbolTable, Function function, List<Parameter> params) throws DuplicateNameException, InvalidInputException {
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.get(i);
            String name = param.getName();
            if (name == null || SymbolUtilities.isDefaultParameterName((String)name)) continue;
            String uniqueName = ApplyFunctionSignatureCmd.getUniqueParameterName(symbolTable, function, name);
            param.setName(uniqueName, param.getSource());
        }
    }

    private int getIndexOfFirstParameter(String conventionName, ParameterDefinition[] args) {
        if (args.length == 0) {
            return 0;
        }
        if (!"__thiscall".equals(conventionName)) {
            return 0;
        }
        if (!Function.THIS_PARAM_NAME.equals(args[0].getName())) {
            return 0;
        }
        return 1;
    }

    private String getCallingConvention(Function function, CompilerSpec compilerSpec) {
        PrototypeModel currentConvention;
        String callingConvention = this.signature.getCallingConventionName();
        if (compilerSpec.getCallingConvention(callingConvention) == null) {
            callingConvention = null;
        }
        if ((currentConvention = function.getCallingConvention()) != null && (callingConvention == null || this.preserveCallingConvention)) {
            callingConvention = function.getCallingConventionName();
        }
        return callingConvention;
    }

    private static void updateStackPurgeSize(Function function, Program program) {
        int extraPop;
        if (function.isStackPurgeSizeValid()) {
            return;
        }
        PrototypeModel convention = function.getCallingConvention();
        if (convention == null) {
            convention = program.getCompilerSpec().getDefaultCallingConvention();
        }
        if ((extraPop = convention.getExtrapop()) != 32768) {
            function.setStackPurgeSize(0);
            return;
        }
        int purgeSize = 0;
        Parameter[] parameters = function.getParameters();
        if (parameters.length > 0) {
            int align = convention.getStackParameterAlignment();
            long min = 0xFFFFFFF0L;
            long max = 0L;
            for (Parameter parameter : parameters) {
                Varnode vn = parameter.getFirstStorageVarnode();
                if (vn == null) {
                    purgeSize = Integer.MAX_VALUE;
                    break;
                }
                if (!vn.getAddress().isStackAddress()) continue;
                long val = vn.getOffset();
                if (val < min) {
                    min = val;
                }
                if ((val += (long)vn.getSize()) <= max) continue;
                max = val;
            }
            if (max > min) {
                int diff = (int)(max - min);
                int rem = diff % align;
                if (rem != 0) {
                    diff += align - rem;
                }
                purgeSize += diff;
            }
        }
        if (purgeSize >= 0 && purgeSize != Integer.MAX_VALUE) {
            function.setStackPurgeSize(purgeSize);
        }
    }

    private void setName(Function function, String name) throws InvalidInputException {
        if (this.functionRenameOption == FunctionRenameOption.NO_CHANGE || name == null) {
            return;
        }
        SymbolUtilities.validateName((String)name);
        if (function.getName().equals(name)) {
            return;
        }
        if (this.functionRenameOption == FunctionRenameOption.RENAME_IF_DEFAULT && function.getSymbol().getSource() != SourceType.DEFAULT) {
            return;
        }
        try {
            this.removeCodeSymbol(function.getEntryPoint(), name, function.getParentNamespace());
            function.setName(name, this.source);
        }
        catch (DuplicateNameException e) {
            throw new InvalidInputException("Function name conflict occurred when applying function signature.");
        }
    }

    private static DataType settleCDataType(DataType dt, DataTypeManager dtm) {
        if (dt == null) {
            return null;
        }
        DataType baseType = dt;
        if (baseType instanceof TypedefDataType) {
            baseType = ((TypedefDataType)baseType).getBaseDataType();
        }
        if (!(baseType instanceof ArrayDataType)) {
            return dt;
        }
        baseType = ((ArrayDataType)baseType).getDataType();
        return dtm.getPointer(baseType);
    }

    private static String getUniqueParameterName(SymbolTable symbolTable, Function function, String name) {
        if (name == null || !SymbolUtilities.isDefaultParameterName((String)name)) {
            return name;
        }
        Symbol s = symbolTable.getParameterSymbol(name, (Namespace)function);
        if (s == null || s.getSymbolType() == SymbolType.PARAMETER) {
            return name;
        }
        return ApplyFunctionSignatureCmd.getUniqueName(symbolTable, (Namespace)function, name);
    }

    private void removeCodeSymbol(Address address, String name, Namespace namespace) {
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol otherSym = symbolTable.getSymbol(name, address, namespace);
        if (otherSym != null && otherSym.getSymbolType() == SymbolType.LABEL) {
            otherSym.delete();
        }
    }

    private static String getUniqueName(SymbolTable symbolTable, Namespace namespace, String baseName) {
        Object name = baseName;
        if (name != null) {
            int cnt = 0;
            while (!symbolTable.getSymbols((String)name, namespace).isEmpty()) {
                name = baseName + ++cnt;
            }
        }
        return name;
    }
}

