/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbInferior;
import agent.gdb.manager.impl.GdbMemoryMapping;
import agent.gdb.manager.impl.cmd.GdbCommandError;
import agent.gdb.manager.impl.cmd.GdbStateChangeRecord;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetInferior;
import agent.gdb.model.impl.GdbModelTargetMemoryRegion;
import generic.ULongSpan;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

@TargetObjectSchemaInfo(name="Memory", attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetProcessMemory
extends DefaultTargetObject<GdbModelTargetMemoryRegion, GdbModelTargetInferior>
implements TargetMemory {
    public static final String NAME = "Memory";
    protected final GdbModelImpl impl;
    protected final GdbInferior inferior;
    protected final Map<BigInteger, GdbModelTargetMemoryRegion> regionsByStart = new WeakValueHashMap();

    public GdbModelTargetProcessMemory(GdbModelTargetInferior inferior) {
        super((AbstractDebuggerObjectModel)inferior.impl, (TargetObject)inferior, NAME, "ProcessMemory");
        this.impl = inferior.impl;
        this.inferior = inferior.inferior;
    }

    protected CompletableFuture<Map<BigInteger, GdbMemoryMapping>> defaultUsingAddressSize() {
        return this.inferior.evaluate("sizeof(int*)").thenApply(sizeStr -> {
            int size;
            try {
                size = Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException e) {
                throw new GdbCommandError("Couldn't determine address size: " + e);
            }
            BigInteger start = BigInteger.ZERO;
            BigInteger end = BigInteger.ONE.shiftLeft(size * 8);
            if (size >= 0 && size < 8) {
                GdbMemoryMapping mapping = new GdbMemoryMapping(start, end, end.subtract(start), BigInteger.ZERO, "rwx", "default");
                return Map.of(start, mapping);
            }
            if (size == 8) {
                BigInteger lowEnd = BigInteger.valueOf(Long.MAX_VALUE);
                BigInteger highStart = lowEnd.add(BigInteger.ONE);
                GdbMemoryMapping lowMapping = new GdbMemoryMapping(start, lowEnd, lowEnd.subtract(start), BigInteger.ZERO, "rwx", "defaultLow");
                GdbMemoryMapping highMapping = new GdbMemoryMapping(highStart, end, end.subtract(highStart), BigInteger.ZERO, "rwx", "defaultHigh");
                return Map.of(start, lowMapping, highStart, highMapping);
            }
            throw new GdbCommandError("Unexpected address size: " + size);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUsingMappings(Map<BigInteger, GdbMemoryMapping> byStart) {
        GdbModelTargetProcessMemory gdbModelTargetProcessMemory = this;
        synchronized (gdbModelTargetProcessMemory) {
            if (!this.valid) {
                this.setElements(List.of(), "Refreshed");
            }
        }
        CompletableFuture<Map<BigInteger, GdbMemoryMapping>> maybeDefault = byStart.isEmpty() ? this.defaultUsingAddressSize() : CompletableFuture.completedFuture(byStart);
        ((CompletableFuture)maybeDefault.thenAccept(mappings -> {
            List regions;
            GdbModelTargetProcessMemory gdbModelTargetProcessMemory = this;
            synchronized (gdbModelTargetProcessMemory) {
                regions = mappings.values().stream().map(this::getTargetRegion).collect(Collectors.toList());
            }
            this.setElements(regions, "Refreshed");
        })).exceptionally(ex -> {
            Msg.info((Object)((Object)this), (Object)("Failed to update regions: " + ex));
            return null;
        });
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.doRefresh();
    }

    protected CompletableFuture<Void> doRefresh() {
        if (this.inferior.getPid() == null) {
            this.setElements(List.of(), "Refreshed (while no process)");
            return AsyncUtils.NIL;
        }
        return ((CompletableFuture)this.inferior.listMappings().exceptionally(ex -> {
            Msg.error((Object)((Object)this), (Object)"Could not list regions. Using default.");
            return Map.of();
        })).thenAccept(this::updateUsingMappings);
    }

    protected synchronized GdbModelTargetMemoryRegion getTargetRegion(GdbMemoryMapping mapping) {
        GdbModelTargetMemoryRegion region = this.regionsByStart.get(mapping.getStart());
        if (region != null && region.isSame(mapping)) {
            return region;
        }
        region = new GdbModelTargetMemoryRegion(this, mapping);
        this.regionsByStart.put(mapping.getStart(), region);
        return region;
    }

    protected CompletableFuture<byte[]> doReadMemory(Address address, long offset, int length) {
        AddressRangeImpl range;
        ByteBuffer buf = ByteBuffer.allocate(length);
        try {
            range = new AddressRangeImpl(address, (long)length);
        }
        catch (AddressOverflowException e) {
            throw new IllegalArgumentException("address,length", e);
        }
        return ((CompletableFuture)this.inferior.readMemory(offset, buf).thenApply(set -> {
            ULongSpan s = (ULongSpan)set.spanContaining((Object)offset);
            if (s == null) {
                throw new DebuggerMemoryAccessException("Cannot read at " + address);
            }
            byte[] content = Arrays.copyOf(buf.array(), (int)s.length());
            this.broadcast().memoryUpdated((TargetObject)this, address, content);
            return content;
        })).exceptionally(arg_0 -> this.lambda$doReadMemory$5(address, (AddressRange)range, arg_0));
    }

    public CompletableFuture<byte[]> readMemory(Address address, int length) {
        return this.impl.gateFuture(this.doReadMemory(address, address.getOffset(), length));
    }

    public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        CompletableFuture<Void> future = this.inferior.writeMemory(address.getOffset(), ByteBuffer.wrap(data));
        return this.impl.gateFuture((CompletableFuture)future.thenAccept(__ -> this.broadcast().memoryUpdated((TargetObject)this, address, data)));
    }

    protected void invalidateMemoryCaches() {
        this.broadcast().invalidateCacheRequested((TargetObject)this);
    }

    public void memoryChanged(long offset, int len) {
        Address address = this.impl.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
        this.doReadMemory(address, offset, len).exceptionally(ex -> {
            Msg.error((Object)((Object)this), (Object)"Failed to update memory contents on memory-changed event", (Throwable)ex);
            return null;
        });
    }

    public CompletableFuture<Void> stateChanged(GdbStateChangeRecord sco) {
        return this.doRefresh().thenCompose(__ -> {
            AsyncFence fence = new AsyncFence();
            for (GdbModelTargetMemoryRegion modelRegion : this.regionsByStart.values()) {
                fence.include(modelRegion.stateChanged(sco));
            }
            return fence.ready();
        });
    }

    protected CompletableFuture<?> refreshInternal() {
        return this.doRefresh().exceptionally(ex -> {
            this.impl.reportError((Object)this, "Problem refreshing inferior's memory regions", (Throwable)ex);
            return null;
        });
    }

    private /* synthetic */ byte[] lambda$doReadMemory$5(Address address, AddressRange range, Throwable e) {
        if ((e = AsyncUtils.unwrapThrowable((Throwable)e)) instanceof GdbCommandError) {
            GdbCommandError gce = (GdbCommandError)e;
            e = new DebuggerMemoryAccessException("Cannot read at " + address + ": " + gce.getInfo().getString("msg"));
            this.broadcast().memoryReadError((TargetObject)this, range, (DebuggerMemoryAccessException)e);
        }
        if (e instanceof DebuggerMemoryAccessException) {
            this.broadcast().memoryReadError((TargetObject)this, range, (DebuggerMemoryAccessException)e);
        }
        return (byte[])ExceptionUtils.rethrow((Throwable)e);
    }
}

