/*
 * Decompiled with CFR 0.152.
 */
package log;

import java.io.Serializable;
import log.LogListener;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="LogPanelAppender", category="Core", elementType="appender", printObject=true)
public class LogPanelAppender
extends AbstractAppender {
    private LogListener logListener;

    protected LogPanelAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        if (this.logListener == null) {
            return;
        }
        boolean isError = event.getLevel().isMoreSpecificThan(Level.ERROR);
        String message = event.getMessage().getFormattedMessage();
        this.logListener.messageLogged(message, isError);
    }

    @PluginFactory
    public static LogPanelAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="otherAttribute") String otherAttribute) {
        if (name == null) {
            LOGGER.error("No name provided for LogPanelAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new LogPanelAppender(name, filter, (Layout<? extends Serializable>)layout);
    }

    public void setLogListener(LogListener listener) {
        this.logListener = listener;
    }
}

