/*
 * Decompiled with CFR 0.152.
 */
package ghidra.python;

import docking.ActionContext;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import generic.jar.ResourceFile;
import generic.theme.GIcon;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.app.plugin.core.interpreter.InterpreterConnection;
import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.app.plugin.core.interpreter.InterpreterPanelService;
import ghidra.app.script.GhidraState;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.python.GhidraPythonInterpreter;
import ghidra.python.PythonCodeCompletionFactory;
import ghidra.python.PythonPluginInputThread;
import ghidra.python.PythonScript;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.Icon;
import org.python.core.PySystemState;
import resources.Icons;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Interpreters", shortDescription="Python Interpreter", description="Provides an interactive Python Interpreter that is tightly integrated with a loaded Ghidra program.", servicesRequired={InterpreterPanelService.class}, isSlowInstallation=true)
public class PythonPlugin
extends ProgramPlugin
implements InterpreterConnection,
OptionsChangeListener {
    private InterpreterConsole console;
    private GhidraPythonInterpreter interpreter;
    private PythonScript interactiveScript;
    private TaskMonitor interactiveTaskMonitor;
    private PythonPluginInputThread inputThread;
    private static final String INCLUDE_BUILTINS_LABEL = "Include \"builtins\" in code completion?";
    private static final String INCLUDE_BUILTINS_DESCRIPTION = "Whether or not to include Python's built-in functions and properties in the pop-up code completion window.";
    private static final boolean INCLUDE_BUILTINS_DEFAULT = true;
    private static final Icon ICON = new GIcon("icon.plugin.python");
    private boolean includeBuiltins = true;

    public PythonPlugin(PluginTool tool) {
        super(tool);
    }

    InterpreterConsole getConsole() {
        return this.console;
    }

    GhidraPythonInterpreter getInterpreter() {
        return this.interpreter;
    }

    PythonScript getInteractiveScript() {
        return this.interactiveScript;
    }

    TaskMonitor getInteractiveTaskMonitor() {
        return this.interactiveTaskMonitor;
    }

    protected void init() {
        super.init();
        this.console = ((InterpreterPanelService)this.getTool().getService(InterpreterPanelService.class)).createInterpreterPanel((InterpreterConnection)this, false);
        this.welcome();
        this.console.addFirstActivationCallback(() -> this.resetInterpreter());
        this.createActions();
    }

    private void createActions() {
        DockingAction interruptAction = new DockingAction("Interrupt Interpreter", this.getName()){

            public void actionPerformed(ActionContext context) {
                PythonPlugin.this.interrupt();
            }
        };
        interruptAction.setDescription("Interrupt Interpreter");
        interruptAction.setToolBarData(new ToolBarData(Icons.NOT_ALLOWED_ICON, null));
        interruptAction.setEnabled(true);
        interruptAction.setKeyBindingData(new KeyBindingData(73, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        interruptAction.setHelpLocation(new HelpLocation(this.getTitle(), "Interrupt_Interpreter"));
        this.console.addAction(interruptAction);
        DockingAction resetAction = new DockingAction("Reset Interpreter", this.getName()){

            public void actionPerformed(ActionContext context) {
                PythonPlugin.this.reset();
            }
        };
        resetAction.setDescription("Reset Interpreter");
        resetAction.setToolBarData(new ToolBarData(Icons.REFRESH_ICON, null));
        resetAction.setEnabled(true);
        resetAction.setKeyBindingData(new KeyBindingData(68, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        resetAction.setHelpLocation(new HelpLocation(this.getTitle(), "Reset_Interpreter"));
        this.console.addAction(resetAction);
    }

    private void resetInterpreter() {
        TaskLauncher.launchModal((String)"Resetting Python...", () -> this.resetInterpreterInBackground());
    }

    private void resetInterpreterInBackground() {
        if (this.interpreter == null) {
            ToolOptions options = this.tool.getOptions("Python");
            this.includeBuiltins = options.getBoolean(INCLUDE_BUILTINS_LABEL, true);
            options.registerOption(INCLUDE_BUILTINS_LABEL, (Object)true, null, INCLUDE_BUILTINS_DESCRIPTION);
            options.addOptionsChangeListener((OptionsChangeListener)this);
            this.interpreter = GhidraPythonInterpreter.get();
            PythonCodeCompletionFactory.setupOptions(this, (Options)options);
        } else {
            this.inputThread.shutdown();
            this.inputThread = null;
            this.interpreter.cleanup();
            this.interpreter = GhidraPythonInterpreter.get();
        }
        this.console.clear();
        this.console.setPrompt(this.interpreter.getPrimaryPrompt());
        this.interpreter.setIn(this.console.getStdin());
        this.interpreter.setOut(this.console.getStdOut());
        this.interpreter.setErr(this.console.getStdErr());
        this.welcome();
        this.interactiveScript = new PythonScript();
        this.interactiveScript.set(new GhidraState(this.tool, this.tool.getProject(), this.getCurrentProgram(), this.getProgramLocation(), this.getProgramSelection(), this.getProgramHighlight()), this.interactiveTaskMonitor, new PrintWriter(this.getConsole().getStdOut()));
        this.interpreter.injectScriptHierarchy(this.interactiveScript);
        this.interactiveTaskMonitor = new PythonInteractiveTaskMonitor(this.console.getStdOut());
        this.inputThread = new PythonPluginInputThread(this);
        this.inputThread.start();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.startsWith("Code Completion Colors")) {
            PythonCodeCompletionFactory.changeOptions((Options)options, optionName, oldValue, newValue);
        } else if (optionName.equals("Include type names in code completion popup?")) {
            PythonCodeCompletionFactory.changeOptions((Options)options, optionName, oldValue, newValue);
        } else if (optionName.equals(INCLUDE_BUILTINS_LABEL)) {
            this.includeBuiltins = (Boolean)newValue;
        }
    }

    public List<CodeCompletion> getCompletions(String cmd) {
        return this.getCompletions(cmd, cmd.length());
    }

    public List<CodeCompletion> getCompletions(String cmd, int caretPos) {
        this.interactiveScript.setSourceFile(new ResourceFile(new File("python")));
        this.interactiveScript.set(new GhidraState(this.tool, this.tool.getProject(), this.currentProgram, this.currentLocation, this.currentSelection, this.currentHighlight), this.interactiveTaskMonitor, this.console.getOutWriter());
        return this.interpreter.getCommandCompletions(cmd, this.includeBuiltins, caretPos);
    }

    protected void dispose() {
        this.interrupt();
        if (this.inputThread != null) {
            this.inputThread.shutdown();
            this.inputThread = null;
        }
        if (this.console != null) {
            this.console.dispose();
            this.console = null;
        }
        if (this.interpreter != null) {
            this.interpreter.cleanup();
            this.interpreter = null;
        }
        super.dispose();
    }

    public void interrupt() {
        if (this.interpreter == null) {
            return;
        }
        this.interpreter.interrupt(this.inputThread.getPythonPluginExecutionThread());
        this.console.setPrompt(this.interpreter.getPrimaryPrompt());
    }

    public void reset() {
        this.interrupt();
        this.resetInterpreter();
    }

    public String getTitle() {
        return "Python";
    }

    public String toString() {
        return this.getPluginDescription().getName();
    }

    public Icon getIcon() {
        return ICON;
    }

    private void welcome() {
        this.console.getOutWriter().println("Python Interpreter for Ghidra");
        this.console.getOutWriter().println("Based on Jython version " + PySystemState.version);
        this.console.getOutWriter().println("Press 'F1' for usage instructions");
    }

    class PythonInteractiveTaskMonitor
    extends TaskMonitorAdapter {
        private PrintWriter output = null;

        public PythonInteractiveTaskMonitor(PrintWriter stdOut) {
            this.output = stdOut;
        }

        public PythonInteractiveTaskMonitor(OutputStream stdout) {
            this(new PrintWriter(stdout));
        }

        public void setMessage(String message) {
            this.output.println("<python-interactive>: " + message);
        }
    }
}

