/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.manager.DbgEventsListenerAdapter;
import agent.dbgeng.manager.DbgStackFrame;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import ghidra.async.AsyncUtils;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetStackFrame
extends TargetStackFrame,
DbgEventsListenerAdapter,
DbgModelSelectableObject {
    public static final String FUNC_ATTRIBUTE_NAME = "function";
    public static final String FUNC_TABLE_ENTRY_ATTRIBUTE_NAME = "Table Entry";
    public static final String FRAME_OFFSET_ATTRIBUTE_NAME = "Frame Offset";
    public static final String INST_OFFSET_ATTRIBUTE_NAME = "Inst. Offset";
    public static final String RETURN_OFFSET_ATTRIBUTE_NAME = "Return Offset";
    public static final String STACK_OFFSET_ATTRIBUTE_NAME = "Stack Offset";
    public static final String VIRTUAL_ATTRIBUTE_NAME = "Virtual";
    public static final String PARAM0_ATTRIBUTE_NAME = "Param[0]";
    public static final String PARAM1_ATTRIBUTE_NAME = "Param[1]";
    public static final String PARAM2_ATTRIBUTE_NAME = "Param[2]";
    public static final String PARAM3_ATTRIBUTE_NAME = "Param[3]";
    public static final String FROM_ATTRIBUTE_NAME = "_from";

    @Override
    default public CompletableFuture<Void> setActive() {
        DbgManagerImpl manager = this.getManager();
        DbgModelTargetThread targetThread = this.getParentThread();
        DbgThread thread = targetThread.getThread();
        String name = this.getName();
        String stripped = name.substring(1, name.length() - 1);
        int index = Integer.decode(stripped);
        return manager.setActiveFrame(thread, index);
    }

    @Override
    default public CompletableFuture<Void> init(Map<String, Object> map) {
        AddressSpace space = this.getModel().getAddressSpace("ram");
        return this.requestNativeAttributes().thenCompose(attrs -> {
            if (attrs == null) {
                return AsyncUtils.NIL;
            }
            map.putAll((Map<String, Object>)attrs);
            DbgModelTargetObject attributes = (DbgModelTargetObject)attrs.get("Attributes");
            if (attributes == null) {
                return AsyncUtils.NIL;
            }
            return attributes.requestAugmentedAttributes().thenCompose(ax -> {
                if (!this.isValid()) {
                    return AsyncUtils.NIL;
                }
                Map subattrs = attributes.getCachedAttributes();
                DbgModelTargetObject frameNumber = (DbgModelTargetObject)subattrs.get("FrameNumber");
                if (frameNumber == null) {
                    return AsyncUtils.NIL;
                }
                return frameNumber.requestAugmentedAttributes().thenCompose(bx -> {
                    if (!this.isValid()) {
                        return AsyncUtils.NIL;
                    }
                    Object noval = frameNumber.getCachedAttribute("_value");
                    String nostr = noval.toString();
                    DbgModelTargetObject instructionOffset = (DbgModelTargetObject)subattrs.get("InstructionOffset");
                    if (instructionOffset == null) {
                        return AsyncUtils.NIL;
                    }
                    return instructionOffset.requestAugmentedAttributes().thenAccept(cx -> {
                        if (!this.isValid()) {
                            return;
                        }
                        String oldval = (String)this.getCachedAttribute("_display");
                        Object pcval = instructionOffset.getCachedAttribute("_value");
                        String pcstr = pcval.toString();
                        long pc = Long.parseUnsignedLong(pcstr, 16);
                        map.put("_pc", space.getAddress(pc));
                        String display = String.format("#%s 0x%s", nostr, pcstr);
                        map.put("_display", display);
                        this.setModified(map, !display.equals(oldval));
                    });
                });
            });
        });
    }

    public void setFrame(DbgStackFrame var1);

    public Address getPC();
}

