/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.eval;

import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.eval.VarnodeEvaluator;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.OpBehavior;
import ghidra.pcode.opbehavior.OpBehaviorFactory;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractVarnodeEvaluator<T>
implements VarnodeEvaluator<T> {
    protected abstract T catenate(int var1, T var2, T var3, int var4);

    protected abstract boolean isLeaf(Varnode var1);

    protected abstract Address applyBase(long var1);

    protected Address translateMemory(Program program, Address address) {
        return address;
    }

    protected T evaluateLeaf(Program program, Varnode vn) {
        Address address = vn.getAddress();
        if (address.isConstantAddress()) {
            return this.evaluateConstant(vn.getOffset(), vn.getSize());
        }
        if (address.isRegisterAddress()) {
            return this.evaluateRegister(address, vn.getSize());
        }
        if (address.isStackAddress()) {
            return this.evaluateStack(address.getOffset(), vn.getSize());
        }
        if (address.isMemoryAddress()) {
            return this.evaluateMemory(this.translateMemory(program, address), vn.getSize());
        }
        if (address.isUniqueAddress()) {
            return this.evaluateUnique(vn.getOffset(), vn.getSize());
        }
        throw new PcodeExecutionException("Unrecognized address space in " + vn);
    }

    protected T doEvaluateVarnode(Program program, Varnode vn, Map<Varnode, T> already) {
        if (this.isLeaf(vn)) {
            return this.evaluateLeaf(program, vn);
        }
        return this.evaluateBranch(program, vn, already);
    }

    protected T evaluateVarnode(Program program, Varnode vn, Map<Varnode, T> already) {
        if (already.containsKey(vn)) {
            return already.get(vn);
        }
        T result = this.doEvaluateVarnode(program, vn, already);
        already.put(vn, result);
        return result;
    }

    @Override
    public T evaluateVarnode(Program program, Varnode vn) {
        return (T)this.evaluateVarnode(program, vn, new HashMap());
    }

    protected T evaluateStorage(Program program, VariableStorage storage, T identity) {
        int total = storage.size();
        T value = identity;
        for (Varnode vn : storage.getVarnodes()) {
            T piece = this.evaluateVarnode(program, vn);
            value = this.catenate(total, value, piece, vn.getSize());
        }
        return value;
    }

    protected T evaluateBranch(Program program, Varnode vn, Map<Varnode, T> already) {
        PcodeOp def = vn.getDef();
        if (def == null || def.getOutput() != vn) {
            throw new PcodeExecutionException("No defining p-code op for " + vn);
        }
        return this.evaluateOp(program, def, already);
    }

    protected abstract T evaluateConstant(long var1, int var3);

    protected T evaluateRegister(Address address, int size) {
        return this.evaluateMemory(address, size);
    }

    protected T evaluateStack(long offset, int size) {
        return this.evaluateMemory(this.applyBase(offset), size);
    }

    protected abstract T evaluateMemory(Address var1, int var2);

    protected T evaluateUnique(long offset, int size) {
        throw new PcodeExecutionException(String.format("Cannot evaluate unique $U%x:%d", offset, size));
    }

    protected abstract T evaluateAbstract(Program var1, AddressSpace var2, T var3, int var4, Map<Varnode, T> var5);

    protected abstract T evaluateUnaryOp(Program var1, PcodeOp var2, UnaryOpBehavior var3, Map<Varnode, T> var4);

    protected abstract T evaluateBinaryOp(Program var1, PcodeOp var2, BinaryOpBehavior var3, Map<Varnode, T> var4);

    protected abstract T evaluatePtrAdd(Program var1, PcodeOp var2, Map<Varnode, T> var3);

    protected abstract T evaluatePtrSub(Program var1, PcodeOp var2, Map<Varnode, T> var3);

    protected int getIntConst(Varnode vn) {
        if (!vn.isConstant()) {
            throw new IllegalArgumentException(vn + " is not a constant");
        }
        return (int)vn.getAddress().getOffset();
    }

    protected abstract T evaluateLoad(Program var1, PcodeOp var2, Map<Varnode, T> var3);

    @Override
    public T evaluateOp(Program program, PcodeOp op) {
        return (T)this.evaluateOp(program, op, new HashMap());
    }

    protected T evaluateOp(Program program, PcodeOp op, Map<Varnode, T> already) {
        OpBehavior b = OpBehaviorFactory.getOpBehavior((int)op.getOpcode());
        if (b == null) {
            return this.badOp(op);
        }
        if (b instanceof UnaryOpBehavior) {
            UnaryOpBehavior unOp = (UnaryOpBehavior)b;
            return this.evaluateUnaryOp(program, op, unOp, already);
        }
        if (b instanceof BinaryOpBehavior) {
            BinaryOpBehavior binOp = (BinaryOpBehavior)b;
            return this.evaluateBinaryOp(program, op, binOp, already);
        }
        switch (op.getOpcode()) {
            case 2: {
                return this.evaluateLoad(program, op, already);
            }
            case 65: {
                return this.evaluatePtrAdd(program, op, already);
            }
            case 66: {
                return this.evaluatePtrSub(program, op, already);
            }
        }
        return this.badOp(op);
    }

    protected T badOp(PcodeOp op) {
        switch (op.getOpcode()) {
            case 0: {
                throw new LowlevelError("Encountered an unimplemented instruction at " + op.getSeqnum().getTarget());
            }
        }
        throw new LowlevelError("Unsupported p-code op at " + op.getSeqnum().getTarget() + ": " + op);
    }
}

