/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.util;

import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.util.Msg;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AutoServiceListener<R>
implements ServiceListener {
    protected static final Map<Class<?>, Set<ServiceSetter<?, ?>>> SETTERS_BY_RECEIVER_CLASS = new HashMap();
    protected static final Map<Class<?>, ReceiverProfile<?>> PROFILES_BY_RECEIVER_CLASS = new HashMap();
    protected final R receiver;
    protected final ReceiverProfile<R> profile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <R> Set<ServiceSetter<R, ?>> collectSettersByReceiver(Class<R> cls) {
        Map<Class<?>, Set<ServiceSetter<?, ?>>> map = SETTERS_BY_RECEIVER_CLASS;
        synchronized (map) {
            AutoServiceConsumed annotation;
            if (SETTERS_BY_RECEIVER_CLASS.containsKey(cls)) {
                return SETTERS_BY_RECEIVER_CLASS.get(cls);
            }
            HashSet result = new HashSet();
            SETTERS_BY_RECEIVER_CLASS.put(cls, result);
            Class<R> superclass = cls.getSuperclass();
            if (superclass != null) {
                Set<ServiceSetter<R, ?>> superResult = AutoServiceListener.collectSettersByReceiver(superclass);
                result.addAll(superResult);
            }
            for (Class<?> clazz : cls.getInterfaces()) {
                Set<ServiceSetter<?, ?>> superResult = AutoServiceListener.collectSettersByReceiver(clazz);
                result.addAll(superResult);
            }
            for (AnnotatedElement annotatedElement : cls.getDeclaredFields()) {
                annotation = ((Field)annotatedElement).getAnnotation(AutoServiceConsumed.class);
                if (annotation == null) continue;
                try {
                    result.add(new FieldServiceSetter((Field)annotatedElement));
                }
                catch (IllegalArgumentException e) {
                    Msg.error(AutoServiceListener.class, (Object)e.getMessage());
                }
            }
            for (AnnotatedElement annotatedElement : cls.getDeclaredMethods()) {
                annotation = ((Method)annotatedElement).getAnnotation(AutoServiceConsumed.class);
                if (annotation == null) continue;
                try {
                    result.add(new MethodServiceSetter((Method)annotatedElement));
                }
                catch (IllegalArgumentException e) {
                    Msg.error(AutoServiceListener.class, (Object)e.getMessage());
                }
            }
            return result;
        }
    }

    public AutoServiceListener(R receiver) {
        this.receiver = receiver;
        this.profile = PROFILES_BY_RECEIVER_CLASS.computeIfAbsent(receiver.getClass(), ReceiverProfile::new);
    }

    public void serviceAdded(Class<?> iface, Object service) {
        this.profile.serviceAdded(iface, service, this.receiver);
    }

    public void serviceRemoved(Class<?> iface, Object service) {
        this.profile.serviceRemoved(iface, this.receiver);
    }

    public void notifyCurrentServices(PluginTool tool) {
        this.profile.notifyCurrentServices(tool, this.receiver);
    }

    protected static class FieldServiceSetter<R, S>
    implements ServiceSetter<R, S> {
        protected final Field field;
        protected final Class<S> iface;

        public FieldServiceSetter(Field field) {
            this.field = field;
            this.iface = field.getType();
            field.setAccessible(true);
        }

        @Override
        public void set(R receiver, S service) {
            try {
                this.field.set(receiver, service);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Class<S> getServiceIface() {
            return this.iface;
        }
    }

    protected static class MethodServiceSetter<R, S>
    implements ServiceSetter<R, S> {
        protected final Method method;
        protected final Class<S> iface;

        public MethodServiceSetter(Method method) {
            this.method = method;
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1) {
                throw new IllegalArgumentException("Service receiver method may take only one parameter");
            }
            this.iface = types[0];
            method.setAccessible(true);
        }

        @Override
        public void set(R receiver, S service) {
            try {
                this.method.invoke(receiver, service);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Class<S> getServiceIface() {
            return this.iface;
        }
    }

    protected static class ReceiverProfile<R> {
        protected final Map<Class<?>, Set<ServiceSetter<R, ?>>> settersByService = new HashMap();

        public ReceiverProfile(Class<R> receiverCls) {
            for (ServiceSetter<R, ?> setter : AutoServiceListener.collectSettersByReceiver(receiverCls)) {
                Class<?> iface = setter.getServiceIface();
                Set settersForReceiver = this.settersByService.computeIfAbsent(iface, i -> new HashSet());
                settersForReceiver.add(setter);
            }
        }

        public <S> void serviceAdded(Class<S> iface, S service, R receiver) {
            Set<ServiceSetter<R, ?>> settersForService = this.settersByService.get(iface);
            if (settersForService == null) {
                return;
            }
            for (ServiceSetter<R, ?> setter : settersForService) {
                setter.set(receiver, service);
            }
        }

        public void serviceRemoved(Class<?> iface, R receiver) {
            Set<ServiceSetter<R, ?>> settersForService = this.settersByService.get(iface);
            if (settersForService == null) {
                return;
            }
            for (ServiceSetter<R, ?> setter : settersForService) {
                setter.set(receiver, null);
            }
        }

        public void notifyCurrentServices(PluginTool tool, R receiver) {
            for (Class<?> iface : this.settersByService.keySet()) {
                Object service = tool.getService(iface);
                if (service == null) continue;
                this.serviceAdded(iface, service, receiver);
            }
        }
    }

    protected static interface ServiceSetter<R, S> {
        public void set(R var1, S var2);

        public Class<S> getServiceIface();
    }
}

