/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class LinkerUnwindInfo {
    private int version;
    private int flags;
    private long dataLength;

    public int getVersion() {
        return this.version;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public void deserialize(PdbByteReader reader) throws PdbException {
        this.version = reader.parseUnsignedShortVal();
        this.flags = reader.parseUnsignedShortVal();
        this.dataLength = reader.parseUnsignedIntVal();
    }

    public String toString() {
        return this.dump();
    }

    String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("LinkerUnwindInfo--------------------------------------------\n");
        this.dumpInternal(builder);
        builder.append("End LinkerUnwindInfo----------------------------------------\n");
        return builder.toString();
    }

    protected void dumpInternal(StringBuilder builder) {
        builder.append(String.format("version: 0X%04X\n", this.version));
        builder.append(String.format("flags: 0X%04X\n", this.flags));
        builder.append(String.format("dataLength: 0X%08X\n", this.dataLength));
    }
}

