/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class ApplySourceFiles {
    private ApplySourceFiles() {
    }

    static void applyTo(PdbParser pdbParser, XmlPullParser xmlParser, TaskMonitor monitor, MessageLog log) {
        Program program = pdbParser.getProgram();
        Options proplist = program.getOptions("Program Information");
        monitor.setMessage("Applying source files...");
        while (xmlParser.hasNext()) {
            if (monitor.isCancelled()) {
                return;
            }
            XmlElement elem = xmlParser.next();
            if (elem.isEnd() && elem.getName().equals("table")) break;
            String name = elem.getAttribute("name");
            int id = XmlUtilities.parseInt((String)elem.getAttribute("id"));
            proplist.setString("SourceFile" + id, name);
            xmlParser.next();
        }
    }
}

