/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import docking.widgets.table.GTable;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.util.AbstractTextFilter;

class MarkupItemValueTextFilter
extends AbstractTextFilter<VTMarkupItem> {
    public MarkupItemValueTextFilter(VTController controller, GTable table) {
        super(controller, table, "Value Filter");
    }

    @Override
    protected Filter<VTMarkupItem> createEmptyCopy() {
        return new MarkupItemValueTextFilter(this.controller, this.table);
    }

    @Override
    public boolean passesFilter(VTMarkupItem t) {
        return this.passesValueTextFilterImpl(t);
    }

    private boolean passesValueTextFilterImpl(VTMarkupItem adapter) {
        String destinationValueText;
        String sourceValueText;
        String filterText = this.getTextFieldText();
        if (filterText == null || filterText.trim().length() == 0) {
            return true;
        }
        Stringable sourceValue = adapter.getSourceValue();
        if (sourceValue != null && (sourceValueText = sourceValue.getDisplayString()).toLowerCase().indexOf(filterText.toLowerCase()) != -1) {
            return true;
        }
        Stringable destinationValue = adapter.getOriginalDestinationValue();
        return destinationValue != null && (destinationValueText = sourceValue.getDisplayString()).toLowerCase().indexOf(filterText.toLowerCase()) != -1;
    }
}

