/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.plugin;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.actions.AcceptMatchAction;
import ghidra.feature.vt.gui.actions.ApplyAndAddAsPrimaryMarkupItemAction;
import ghidra.feature.vt.gui.actions.ApplyAndAddMarkupItemAction;
import ghidra.feature.vt.gui.actions.ApplyAndReplaceMarkupItemAction;
import ghidra.feature.vt.gui.actions.ApplyMatchAction;
import ghidra.feature.vt.gui.actions.ApplyUsingOptionsAndForcingMarkupItemAction;
import ghidra.feature.vt.gui.actions.ChooseMatchTagAction;
import ghidra.feature.vt.gui.actions.CreateAndAcceptManualMatchFromToolsAction;
import ghidra.feature.vt.gui.actions.CreateAndApplyManualMatchFromToolsAction;
import ghidra.feature.vt.gui.actions.CreateManualMatchFromToolsAction;
import ghidra.feature.vt.gui.actions.DontCareMarkupItemAction;
import ghidra.feature.vt.gui.actions.DontKnowMarkupItemAction;
import ghidra.feature.vt.gui.actions.EditMarkupAddressAction;
import ghidra.feature.vt.gui.actions.MatchActionWrapper;
import ghidra.feature.vt.gui.actions.RejectMarkupItemAction;
import ghidra.feature.vt.gui.actions.RejectMatchAction;
import ghidra.feature.vt.gui.actions.ResetMarkupItemAction;
import ghidra.feature.vt.gui.actions.SelectExistingMatchAction;
import ghidra.feature.vt.gui.duallisting.VTDualListingHighlightProvider;
import ghidra.feature.vt.gui.plugin.SubToolContext;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.plugin.VTSubToolManagerListener;
import ghidra.feature.vt.gui.provider.functionassociation.VTFunctionAssociationContext;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchDestinationTableProvider;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchOneToManyTableProvider;
import ghidra.feature.vt.gui.provider.onetomany.VTMatchSourceTableProvider;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.ToolUtils;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.project.tool.GhidraTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.GenericXMLOutputter;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Document;

public class VTSubToolManager
implements VTControllerListener,
OptionsChangeListener {
    private static final String SOURCE_TOOL_NAME = "Version Tracking (SOURCE TOOL)";
    private static final String DESTINATION_TOOL_NAME = "Version Tracking (DESTINATION TOOL)";
    private final VTPlugin plugin;
    private final VTController controller;
    private List<VTSubToolManagerListener> listeners = new ArrayList<VTSubToolManagerListener>();
    private PluginTool sourceTool;
    private PluginTool destinationTool;
    private List<VersionTrackingSubordinatePluginX> pluginList = new ArrayList<VersionTrackingSubordinatePluginX>();
    private boolean processingOptions;

    VTSubToolManager(VTPlugin plugin) {
        this.plugin = plugin;
        this.controller = plugin.getController();
        this.controller.addListener(this);
    }

    Program openDestinationProgram(DomainFile domainFile, Component parent) {
        if (this.destinationTool == null) {
            this.destinationTool = this.createTool(DESTINATION_TOOL_NAME, false);
        }
        ProgramManager service = (ProgramManager)this.destinationTool.getService(ProgramManager.class);
        return service.openProgram(domainFile, parent);
    }

    Program openSourceProgram(DomainFile domainFile, Component parent) {
        if (this.sourceTool == null) {
            this.sourceTool = this.createTool(SOURCE_TOOL_NAME, true);
        }
        ProgramManager service = (ProgramManager)this.sourceTool.getService(ProgramManager.class);
        return service.openProgram(domainFile, parent);
    }

    void closeSourceProgram(Program source) {
        if (this.sourceTool != null) {
            ProgramManager service = (ProgramManager)this.sourceTool.getService(ProgramManager.class);
            service.closeProgram(source, true);
        }
    }

    void closeDestinationProgram(Program destination) {
        if (this.destinationTool != null) {
            ProgramManager service = (ProgramManager)this.destinationTool.getService(ProgramManager.class);
            service.closeProgram(destination, true);
        }
    }

    public void addListener(VTSubToolManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(VTSubToolManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void resetTools() {
        this.resetTool(DESTINATION_TOOL_NAME);
        this.resetTool(SOURCE_TOOL_NAME);
    }

    private void resetTool(String toolName) {
        String toolFileName = toolName + ".tool";
        File toolFile = new File(ToolUtils.getApplicationToolDirPath(), toolFileName);
        if (toolFile.exists()) {
            toolFile.delete();
        }
    }

    private PluginTool createTool(String toolName, boolean isSourceTool) {
        ToolTemplate toolTemplate = null;
        String toolFileName = toolName + ".tool";
        File toolFile = new File(ToolUtils.getApplicationToolDirPath(), toolFileName);
        if (toolFile.exists()) {
            toolTemplate = ToolUtils.readToolTemplate((File)toolFile);
        }
        if (toolTemplate == null) {
            toolTemplate = ToolUtils.readToolTemplate((String)toolFileName);
        }
        GhidraTool newTool = (GhidraTool)toolTemplate.createTool(this.controller.getTool().getProject());
        try {
            VersionTrackingSubordinatePluginX pluginX = new VersionTrackingSubordinatePluginX((PluginTool)newTool, isSourceTool);
            this.pluginList.add(pluginX);
            newTool.addPlugin((Plugin)pluginX);
        }
        catch (PluginException e) {
            Msg.error((Object)this, (Object)("Failed to create subordinate tool: " + toolName));
        }
        newTool.setToolName(toolName);
        DockingActionIf save = this.getToolAction((PluginTool)newTool, "Save Tool");
        newTool.removeAction(save);
        this.createMarkupActions((PluginTool)newTool);
        newTool.setConfigChanged(false);
        ToolOptions options = newTool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        this.createMatchActions((PluginTool)newTool);
        return newTool;
    }

    private DockingActionIf getToolAction(PluginTool tool, String actionName) {
        Set actions = tool.getDockingActionsByOwnerName("Tool");
        for (DockingActionIf action : actions) {
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        throw new IllegalArgumentException("Unable to find Tool action '" + actionName + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (this.processingOptions) {
            return;
        }
        this.processingOptions = true;
        try {
            ToolOptions destinationOptions;
            ToolOptions sourceOptions;
            if (!(newValue instanceof KeyStroke)) {
                return;
            }
            KeyStroke keyStroke = (KeyStroke)newValue;
            if (this.sourceTool != null && (sourceOptions = this.sourceTool.getOptions("Key Bindings")) != options) {
                sourceOptions.setKeyStroke(optionName, keyStroke);
                this.sourceTool.refreshKeybindings();
                return;
            }
            if (this.destinationTool != null && (destinationOptions = this.destinationTool.getOptions("Key Bindings")) != options) {
                destinationOptions.setKeyStroke(optionName, keyStroke);
                this.destinationTool.refreshKeybindings();
            }
        }
        finally {
            this.processingOptions = false;
        }
    }

    private void createMatchActions(final PluginTool newTool) {
        newTool.setMenuGroup(new String[]{"Version Tracking Match"}, "1", "1");
        newTool.setMenuGroup(new String[]{"Version Tracking Markup"}, "1", "2");
        newTool.addAction((DockingActionIf)new MatchActionWrapper(this.plugin, new AcceptMatchAction(this.controller)));
        newTool.addAction((DockingActionIf)new MatchActionWrapper(this.plugin, new ApplyMatchAction(this.controller)));
        newTool.addAction((DockingActionIf)new MatchActionWrapper(this.plugin, new RejectMatchAction(this.controller)));
        newTool.addAction((DockingActionIf)new MatchActionWrapper(this.plugin, new ChooseMatchTagAction(this.controller)));
        CreateManualMatchFromToolsAction createMatchAction = new CreateManualMatchFromToolsAction(this.plugin);
        CreateAndAcceptManualMatchFromToolsAction createAndAcceptMatchAction = new CreateAndAcceptManualMatchFromToolsAction(this.plugin);
        CreateAndApplyManualMatchFromToolsAction createAndApplyMatchAction = new CreateAndApplyManualMatchFromToolsAction(this.plugin);
        MatchActionWrapper selectMatchAction = new MatchActionWrapper(this.plugin, new SelectExistingMatchAction(this.controller)){

            @Override
            public ActionContext createActionContext(ActionContext originalContext) {
                SubToolContext subToolContext = this.getSubToolContext();
                ArrayList<VTMatch> list = new ArrayList<VTMatch>();
                VTMatch match = subToolContext.getMatch();
                if (match == null) {
                    return null;
                }
                list.add(match);
                return new VTFunctionAssociationContext(newTool, VTSubToolManager.this.getSourceFunction(), VTSubToolManager.this.getDestinationFunction(), match);
            }
        };
        MenuData createActionMenuData = createMatchAction.getPopupMenuData();
        MenuData selectMenuData = selectMatchAction.getPopupMenuData();
        selectMenuData.setMenuGroup(createActionMenuData.getMenuGroup());
        newTool.addAction((DockingActionIf)createMatchAction);
        newTool.addAction((DockingActionIf)createAndAcceptMatchAction);
        newTool.addAction((DockingActionIf)createAndApplyMatchAction);
        newTool.addAction((DockingActionIf)selectMatchAction);
    }

    private void createMarkupActions(PluginTool tool) {
        tool.addAction(this.fixupMarkupActionMenuPath(new ApplyUsingOptionsAndForcingMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new ApplyAndAddMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new ApplyAndAddAsPrimaryMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new ApplyAndReplaceMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new DontKnowMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new DontCareMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new RejectMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new ResetMarkupItemAction(this.controller, false)));
        tool.addAction(this.fixupMarkupActionMenuPath(new EditMarkupAddressAction(this.controller, true)));
    }

    private DockingActionIf fixupMarkupActionMenuPath(DockingAction action) {
        MenuData menuData = action.getPopupMenuData();
        String[] menuPath = menuData.getMenuPath();
        String[] newPath = new String[menuPath.length + 1];
        newPath[0] = "Version Tracking Markup";
        for (int i = 0; i < menuPath.length; ++i) {
            newPath[i + 1] = menuPath[i];
        }
        menuData.setMenuPath(newPath);
        return action;
    }

    private void closeSessionLater() {
        SystemUtilities.runSwingLater(() -> this.controller.closeVersionTrackingSession());
    }

    private List<DomainFile> getChangedPrograms(PluginTool subTool) {
        ArrayList<DomainFile> domainFiles = new ArrayList<DomainFile>();
        if (subTool != null) {
            Program[] allOpenPrograms;
            ProgramManager service = (ProgramManager)subTool.getService(ProgramManager.class);
            for (Program program : allOpenPrograms = service.getAllOpenPrograms()) {
                if (!program.isChanged()) continue;
                domainFiles.add(program.getDomainFile());
            }
        }
        return domainFiles;
    }

    @Override
    public void sessionChanged(VTSession session) {
        if (session != null) {
            if (this.sourceTool == null) {
                this.sourceTool = this.createTool(SOURCE_TOOL_NAME, true);
            }
            if (this.destinationTool == null) {
                this.destinationTool = this.createTool(DESTINATION_TOOL_NAME, false);
            }
            this.closeAllButSessionProgram(this.sourceTool, this.controller.getSourceProgram());
            this.closeAllButSessionProgram(this.destinationTool, this.controller.getDestinationProgram());
            this.sourceTool.setVisible(true);
            this.destinationTool.setVisible(true);
            for (VersionTrackingSubordinatePluginX pluginX : this.pluginList) {
                pluginX.update();
            }
            return;
        }
        this.saveSubordinateToolConfig(this.sourceTool);
        this.saveSubordinateToolConfig(this.destinationTool);
        this.pluginList.clear();
        this.sourceTool.exit();
        this.destinationTool.exit();
        this.sourceTool = null;
        this.destinationTool = null;
    }

    private void closeAllButSessionProgram(PluginTool tool, Program program) {
        ProgramManager service = (ProgramManager)tool.getService(ProgramManager.class);
        program.addConsumer((Object)this);
        service.closeAllPrograms(true);
        service.openProgram(program);
        program.release((Object)this);
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(1030)) {
            CodeViewerService service = (CodeViewerService)this.sourceTool.getService(CodeViewerService.class);
            if (service == null) {
                return;
            }
            for (VersionTrackingSubordinatePluginX pluginX : this.pluginList) {
                pluginX.update();
            }
            ListingPanel listingPanel = service.getListingPanel();
            listingPanel.repaint();
        }
        if (ev.containsEvent(4)) {
            for (VersionTrackingSubordinatePluginX pluginX : this.pluginList) {
                pluginX.update();
            }
        }
    }

    @Override
    public void disposed() {
    }

    private void saveSubordinateToolConfig(PluginTool t) {
        String toolName = t.getName();
        String toolFileName = toolName + ".tool";
        File toolFile = new File(ToolUtils.getApplicationToolDirPath(), toolFileName);
        try {
            FileOutputStream os = new FileOutputStream(toolFile);
            Document doc = new Document(t.getToolTemplate(true).saveToXml());
            GenericXMLOutputter xmlOut = new GenericXMLOutputter();
            xmlOut.output(doc, (OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            Msg.showError((Object)this, (Component)t.getToolFrame(), (String)"Version Tracking", (Object)("Failed to save source tool configuration\nFile: " + toolName + "\n" + e.getMessage()));
        }
        t.setConfigChanged(false);
    }

    public List<DomainFile> getChangedProgramsInSourceTool() {
        return this.getChangedPrograms(this.sourceTool);
    }

    public List<DomainFile> getChangedProgramsInDestinationTool() {
        return this.getChangedPrograms(this.destinationTool);
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
        if (matchInfo != null) {
            VTMatch match = matchInfo.getMatch();
            VTAssociation association = match.getAssociation();
            Address sourceAddress = association.getSourceAddress();
            Address destinationAddress = association.getDestinationAddress();
            Program sourceProgram = this.controller.getSourceProgram();
            Program destinationProgram = this.controller.getDestinationProgram();
            this.gotoInTool(this.sourceTool, sourceProgram, sourceAddress);
            this.gotoInTool(this.destinationTool, destinationProgram, destinationAddress);
        }
        for (VersionTrackingSubordinatePluginX pluginX : this.pluginList) {
            pluginX.update();
        }
    }

    public void setMatch(VTMatch match) {
        VTAssociation association = match.getAssociation();
        Address sourceAddress = association.getSourceAddress();
        Address destinationAddress = association.getDestinationAddress();
        Program sourceProgram = this.controller.getSourceProgram();
        Program destinationProgram = this.controller.getDestinationProgram();
        this.gotoInTool(this.sourceTool, sourceProgram, sourceAddress);
        this.gotoInTool(this.destinationTool, destinationProgram, destinationAddress);
        for (VTSubToolManagerListener listener : this.listeners) {
            listener.setSelectedMatch(match);
        }
    }

    private void gotoInTool(PluginTool tool, Program program, Address address) {
        GoToService service = (GoToService)tool.getService(GoToService.class);
        service.goTo(address, program);
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
        for (VersionTrackingSubordinatePluginX pluginX : this.pluginList) {
            pluginX.updateMarkup(markupItem);
        }
    }

    @Override
    public void optionsChanged(Options options) {
    }

    PluginTool getSourceTool() {
        return this.sourceTool;
    }

    PluginTool getDestinationTool() {
        return this.destinationTool;
    }

    boolean isToolExecutingCommand(PluginTool tool) {
        return tool != null && tool.isExecutingCommand();
    }

    void gotoSourceLocation(ProgramLocation location) {
        GoToService service = (GoToService)this.sourceTool.getService(GoToService.class);
        service.goTo(location);
    }

    void gotoDestinationLocation(ProgramLocation location) {
        GoToService service = (GoToService)this.destinationTool.getService(GoToService.class);
        service.goTo(location);
    }

    ProgramLocation getSourceLocation() {
        GoToService service = (GoToService)this.sourceTool.getService(GoToService.class);
        Navigatable navigatable = service.getDefaultNavigatable();
        return navigatable.getLocation();
    }

    ProgramLocation getDestinationLocation() {
        GoToService service = (GoToService)this.destinationTool.getService(GoToService.class);
        Navigatable navigatable = service.getDefaultNavigatable();
        return navigatable.getLocation();
    }

    Function getSourceFunction() {
        ProgramManager service;
        Program program;
        VTSession session = this.controller.getSession();
        if (session == null) {
            return null;
        }
        Program sourceProgram = session.getSourceProgram();
        if (sourceProgram != (program = (service = (ProgramManager)this.sourceTool.getService(ProgramManager.class)).getCurrentProgram())) {
            return null;
        }
        ProgramLocation location = this.getSourceLocation();
        if (location == null) {
            return null;
        }
        FunctionManager functionManager = program.getFunctionManager();
        return functionManager.getFunctionContaining(location.getAddress());
    }

    Function getDestinationFunction() {
        ProgramManager service;
        Program program;
        VTSession session = this.controller.getSession();
        if (session == null) {
            return null;
        }
        Program sourceProgram = session.getDestinationProgram();
        if (sourceProgram != (program = (service = (ProgramManager)this.destinationTool.getService(ProgramManager.class)).getCurrentProgram())) {
            return null;
        }
        ProgramLocation location = this.getDestinationLocation();
        if (location == null) {
            return null;
        }
        FunctionManager functionManager = program.getFunctionManager();
        return functionManager.getFunctionContaining(location.getAddress());
    }

    boolean isDestinationCursorOnScreen() {
        CodeViewerService service = (CodeViewerService)this.destinationTool.getService(CodeViewerService.class);
        return this.isCursorOnScreen(service);
    }

    boolean isSourceCursorOnScreen() {
        CodeViewerService service = (CodeViewerService)this.sourceTool.getService(CodeViewerService.class);
        return this.isCursorOnScreen(service);
    }

    private boolean isCursorOnScreen(CodeViewerService service) {
        FieldPanel fieldPanel = service.getFieldPanel();
        int cursorOffset = fieldPanel.getCursorOffset();
        return cursorOffset >= 0;
    }

    private AddressSetView getSelectionInTool(PluginTool tool) {
        CodeViewerService service = (CodeViewerService)tool.getService(CodeViewerService.class);
        if (service == null) {
            return null;
        }
        FieldSelection selection = service.getFieldPanel().getSelection();
        AddressIndexMap addressIndexMap = service.getListingPanel().getAddressIndexMap();
        AddressSet addressSet = addressIndexMap.getAddressSet(selection);
        return addressSet;
    }

    private void setSelectionInTool(PluginTool tool, AddressSetView addressSet) {
        ProgramSelection programSelection = new ProgramSelection(addressSet);
        CodeViewerService service = (CodeViewerService)tool.getService(CodeViewerService.class);
        if (service == null) {
            return;
        }
        service.getNavigatable().setSelection(programSelection);
    }

    AddressSetView getSelectionInSourceTool() {
        return this.getSelectionInTool(this.sourceTool);
    }

    AddressSetView getSelectionInDestinationTool() {
        return this.getSelectionInTool(this.destinationTool);
    }

    public void setSelectionInDestinationTool(AddressSetView destinationSet) {
        this.setSelectionInTool(this.destinationTool, destinationSet);
    }

    public void setSelectionInSourceTool(AddressSetView sourceSet) {
        this.setSelectionInTool(this.sourceTool, sourceSet);
    }

    public ColorizingService getSourceColorizingService() {
        return (ColorizingService)this.sourceTool.getService(ColorizingService.class);
    }

    public ColorizingService getDestinationColorizingService() {
        return (ColorizingService)this.destinationTool.getService(ColorizingService.class);
    }

    @PluginInfo(status=PluginStatus.HIDDEN, packageName="Version Tracking", category="Version Tracking", shortDescription="", description="", servicesRequired={ProgramManager.class}, eventsConsumed={ProgramLocationPluginEvent.class, ProgramActivatedPluginEvent.class})
    class VersionTrackingSubordinatePluginX
    extends Plugin {
        private VTMatchOneToManyTableProvider provider;
        private final boolean isSourceTool;
        private boolean tracking;
        private VTDualListingHighlightProvider highlightProvider;

        public VersionTrackingSubordinatePluginX(PluginTool tool, boolean isSourceTool) {
            super(tool);
            this.tracking = true;
            this.isSourceTool = isSourceTool;
            this.provider = isSourceTool ? new VTMatchSourceTableProvider(tool, VTSubToolManager.this.controller, VTSubToolManager.this) : new VTMatchDestinationTableProvider(tool, VTSubToolManager.this.controller, VTSubToolManager.this);
            this.highlightProvider = new VTDualListingHighlightProvider(VTSubToolManager.this.controller, isSourceTool);
        }

        protected void dispose() {
            this.provider.disposed();
        }

        public void update() {
            Program vtProgram;
            ProgramManager service = (ProgramManager)this.tool.getService(ProgramManager.class);
            Program currentProgram = service.getCurrentProgram();
            this.setTracking(currentProgram == (vtProgram = this.getVTProgram()));
            this.highlightProvider.updateMarkup();
            this.updateListing();
        }

        public void updateMarkup(VTMarkupItem markupItem) {
            CodeViewerService codeViewerService;
            this.highlightProvider.setMarkupItem(markupItem);
            if (markupItem != null) {
                Program program = this.highlightProvider.isSource() ? VTSubToolManager.this.controller.getSourceProgram() : VTSubToolManager.this.controller.getDestinationProgram();
                ProgramLocation location = this.highlightProvider.isSource() ? markupItem.getSourceLocation() : markupItem.getDestinationLocation();
                GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
                if (goToService != null && location != null) {
                    goToService.goTo(location, program);
                }
            }
            if ((codeViewerService = (CodeViewerService)this.tool.getService(CodeViewerService.class)) != null) {
                codeViewerService.updateDisplay();
            }
        }

        protected boolean canClose() {
            if (VTSubToolManager.this.isToolExecutingCommand(VTSubToolManager.this.sourceTool)) {
                VTPlugin.showBusyToolMessage(VTSubToolManager.this.sourceTool);
                return false;
            }
            if (VTSubToolManager.this.isToolExecutingCommand(VTSubToolManager.this.destinationTool)) {
                VTPlugin.showBusyToolMessage(VTSubToolManager.this.destinationTool);
                return false;
            }
            int resp = OptionDialog.showYesNoDialog((Component)this.tool.getToolFrame(), (String)"Version Tracking", (String)"Closing this tool will terminate the active Version Tracking Session.\nContinue closing tool?");
            if (resp != 2) {
                VTSubToolManager.this.closeSessionLater();
            }
            return false;
        }

        protected boolean canCloseDomainObject(DomainObject dObj) {
            Program sourceProgram = VTSubToolManager.this.controller.getSourceProgram();
            Program destintationProgram = VTSubToolManager.this.controller.getDestinationProgram();
            if (dObj != sourceProgram && dObj != destintationProgram) {
                return true;
            }
            int resp = OptionDialog.showYesNoDialog((Component)this.tool.getToolFrame(), (String)"Version Tracking", (String)"Closing this program will terminate the active Version Tracking Session.\nContinue?");
            if (resp != 2) {
                VTSubToolManager.this.closeSessionLater();
            }
            return false;
        }

        public void processEvent(PluginEvent event) {
            if (event instanceof ProgramActivatedPluginEvent) {
                ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
                Program currentProgram = ev.getActiveProgram();
                Program vtProgram = this.getVTProgram();
                this.setTracking(vtProgram == currentProgram && currentProgram != null);
            } else if (event instanceof ProgramLocationPluginEvent) {
                if (!this.tracking) {
                    return;
                }
                ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
                ProgramLocation currentLocation = ev.getLocation();
                Address address = currentLocation == null ? null : currentLocation.getAddress();
                this.provider.setAddress(this.getFunctionOrDataStartAddress(address));
            }
        }

        private Address getFunctionOrDataStartAddress(Address address) {
            if (address == null) {
                return null;
            }
            Program program = this.getVTProgram();
            if (program == null) {
                return null;
            }
            Function function = program.getFunctionManager().getFunctionContaining(address);
            if (function == null) {
                Reference ref;
                Data data = program.getListing().getDataContaining(address);
                if (data == null) {
                    return null;
                }
                if (data.isPointer() && (ref = data.getPrimaryReference(0)) != null && ref.isExternalReference()) {
                    return ref.getToAddress();
                }
                return data.getAddress();
            }
            if (function.isThunk()) {
                function = function.getThunkedFunction(true);
            }
            return function.getEntryPoint();
        }

        private void setTracking(boolean b) {
            this.tracking = b;
            if (!this.tracking) {
                this.provider.setAddress(null);
                this.setHighlightProvider(null, this.highlightProvider);
            } else {
                this.setHighlightProvider(this.highlightProvider, null);
            }
        }

        private void setHighlightProvider(VTDualListingHighlightProvider newProvider, VTDualListingHighlightProvider lastProvider) {
            CodeViewerService service = (CodeViewerService)this.tool.getService(CodeViewerService.class);
            if (service == null) {
                return;
            }
            ListingPanel listingPanel = service.getListingPanel();
            if (newProvider == null) {
                this.highlightProvider.setListingPanel(null);
                listingPanel.getFormatManager().removeHighlightProvider((ListingHighlightProvider)lastProvider);
            } else {
                newProvider.setListingPanel(listingPanel);
                listingPanel.getFormatManager().removeHighlightProvider((ListingHighlightProvider)newProvider);
                listingPanel.getFormatManager().addHighlightProvider((ListingHighlightProvider)newProvider);
            }
        }

        private void updateListing() {
            CodeViewerService service = (CodeViewerService)this.tool.getService(CodeViewerService.class);
            if (service == null) {
                return;
            }
            service.updateDisplay();
        }

        private Program getVTProgram() {
            if (this.isSourceTool) {
                return VTSubToolManager.this.controller.getSourceProgram();
            }
            return VTSubToolManager.this.controller.getDestinationProgram();
        }
    }
}

