/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarning;
import ghidra.app.plugin.core.debug.stack.Sym;
import ghidra.app.plugin.core.debug.stack.SymPcodeArithmetic;
import ghidra.app.plugin.core.debug.stack.SymPcodeExecutorState;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class SymPcodeExecutor
extends PcodeExecutor<Sym> {
    private final Program program;
    private final Register sp;
    private final Set<StackUnwindWarning> warnings;
    private final TaskMonitor monitor;
    private final DecompInterface decomp = new DecompInterface();
    private final Map<Function, HighFunction> decompCache = new HashMap<Function, HighFunction>();

    public static SymPcodeExecutor forProgram(Program program, SymPcodeExecutorState state, PcodeExecutorStatePiece.Reason reason, Set<StackUnwindWarning> warnings, TaskMonitor monitor) {
        CompilerSpec cSpec = program.getCompilerSpec();
        SleighLanguage language = (SleighLanguage)cSpec.getLanguage();
        SymPcodeArithmetic arithmetic = new SymPcodeArithmetic(cSpec);
        return new SymPcodeExecutor(program, cSpec, language, arithmetic, state, reason, warnings, monitor);
    }

    public SymPcodeExecutor(Program program, CompilerSpec cSpec, SleighLanguage language, SymPcodeArithmetic arithmetic, SymPcodeExecutorState state, PcodeExecutorStatePiece.Reason reason, Set<StackUnwindWarning> warnings, TaskMonitor monitor) {
        super(language, (PcodeArithmetic)arithmetic, (PcodeExecutorState)state, reason);
        this.program = program;
        this.sp = cSpec.getStackPointer();
        this.warnings = warnings;
        this.monitor = monitor;
    }

    public void executeCallother(PcodeOp op, PcodeFrame frame, PcodeUseropLibrary<Sym> library) {
    }

    public static int computeStackChange(Function function, Set<StackUnwindWarning> warnings) {
        int extrapop;
        PrototypeModel convention = function.getCallingConvention();
        if (convention == null) {
            if (warnings != null) {
                warnings.add(new StackUnwindWarning.UnspecifiedConventionStackUnwindWarning(function));
            }
            convention = function.getProgram().getCompilerSpec().getDefaultCallingConvention();
        }
        if ((extrapop = convention.getExtrapop()) == 32768) {
            throw new PcodeExecutionException("Cannot get stack change for function " + function);
        }
        if (function.isStackPurgeSizeValid()) {
            return extrapop + function.getStackPurgeSize();
        }
        if (warnings != null) {
            warnings.add(new StackUnwindWarning.UnknownPurgeStackUnwindWarning(function));
        }
        return extrapop;
    }

    public int computeStackChange(Function callee) {
        return SymPcodeExecutor.computeStackChange(callee, this.warnings);
    }

    public void executeCall(PcodeOp op, PcodeFrame frame, PcodeUseropLibrary<Sym> library) {
        Address target = op.getInput(0).getAddress();
        Function callee = this.program.getFunctionManager().getFunctionAt(target);
        if (callee == null) {
            throw new PcodeExecutionException("Callee at " + target + " is not a function.", frame);
        }
        String fixupName = callee.getCallFixup();
        if (fixupName != null && !"".equals(fixupName)) {
            try {
                PcodeProgram snippet = PcodeProgram.fromInject((Program)this.program, (String)fixupName, (int)1);
                this.execute(snippet, library);
            }
            catch (UnknownInstructionException | MemoryAccessException | NotFoundException | IOException e) {
                throw new PcodeExecutionException("Issue executing callee fixup: ", e);
            }
            return;
        }
        int change = this.computeStackChange(callee);
        this.adjustStack(change);
    }

    protected PcodeOpAST getHighCallOp(PcodeOp op) {
        Address callSite = op.getSeqnum().getTarget();
        Function caller = this.program.getFunctionManager().getFunctionContaining(callSite);
        HighFunction hfunc = this.decompCache.computeIfAbsent(caller, c -> {
            this.decomp.openProgram(this.program);
            DecompileResults results = this.decomp.decompileFunction(c, 3, this.monitor);
            return results.getHighFunction();
        });
        ArrayList<PcodeOpAST> found = new ArrayList<PcodeOpAST>();
        Iterator oit = hfunc.getPcodeOps(callSite);
        while (oit.hasNext()) {
            PcodeOpAST hop = (PcodeOpAST)oit.next();
            if (hop.getOpcode() != 8 && hop.getOpcode() != 7) continue;
            found.add(hop);
        }
        if (found.size() == 1) {
            return (PcodeOpAST)found.get(0);
        }
        if (found.size() > 1) {
            this.warnings.add(new StackUnwindWarning.MultipleHighCallsStackUnwindWarning(found));
            return (PcodeOpAST)found.get(0);
        }
        this.warnings.add(new StackUnwindWarning.NoHighCallsStackUnwindWarning(op));
        return null;
    }

    protected FunctionSignature getSignatureFromTargetPointerType(PcodeOpAST op) {
        VarnodeAST target = (VarnodeAST)op.getInput(0);
        DataType dataType = target.getHigh().getDataType();
        if (!(dataType instanceof Pointer)) {
            this.warnings.add(new StackUnwindWarning.UnexpectedTargetTypeStackUnwindWarning(dataType));
            return null;
        }
        Pointer ptrType = (Pointer)dataType;
        DataType dataType2 = ptrType.getDataType();
        if (!(dataType2 instanceof FunctionSignature)) {
            this.warnings.add(new StackUnwindWarning.UnexpectedTargetTypeStackUnwindWarning(dataType));
            return null;
        }
        FunctionSignature sigType = (FunctionSignature)dataType2;
        return sigType;
    }

    protected FunctionSignature getSignatureFromContextAtCallSite(PcodeOpAST op) {
        FunctionDefinitionDataType sig = new FunctionDefinitionDataType("__indirect");
        sig.setReturnType(op.getOutput().getHigh().getDataType());
        int numInputs = op.getNumInputs();
        Parameter[] params = new Parameter[numInputs - 1];
        ParameterDefinition[] arguments = new ParameterDefinition[numInputs - 1];
        for (int i = 1; i < numInputs; ++i) {
            Varnode input = op.getInput(i);
            HighVariable highVar = input.getHigh();
            try {
                params[i - 1] = new ParameterImpl("param_" + i, highVar.getDataType(), this.program);
            }
            catch (InvalidInputException e) {
                throw new AssertionError((Object)e);
            }
            arguments[i - 1] = new ParameterDefinitionImpl("param_" + i, input.getHigh().getDataType(), "generated");
        }
        sig.setArguments(arguments);
        sig.setComment("generated");
        try {
            PrototypeModel convention = this.program.getCompilerSpec().findBestCallingConvention(params);
            sig.setCallingConvention(convention.getName());
        }
        catch (SleighException | InvalidInputException throwable) {
            // empty catch block
        }
        return sig;
    }

    protected FunctionSignature getSignatureOfIndirectCall(PcodeOp lowOp) {
        PcodeOpAST callOp = this.getHighCallOp(lowOp);
        if (callOp == null) {
            return null;
        }
        FunctionSignature signature = this.getSignatureFromTargetPointerType(callOp);
        if (signature != null) {
            return signature;
        }
        signature = this.getSignatureFromContextAtCallSite(callOp);
        if (signature != null) {
            return signature;
        }
        this.warnings.add(new StackUnwindWarning.CouldNotRecoverSignatureStackUnwindWarning(callOp));
        return null;
    }

    protected int computeStdcallExtrapop(PrototypeModel convention, FunctionSignature sig) {
        ParameterDefinition[] arguments = sig.getArguments();
        DataType[] types = new DataType[arguments.length + 1];
        types[0] = sig.getReturnType();
        for (int i = 0; i < arguments.length; ++i) {
            types[i + 1] = arguments[0].getDataType();
        }
        VariableStorage[] vsLocs = convention.getStorageLocations(this.program, types, false);
        Address min = null;
        Address max = null;
        for (VariableStorage vs : vsLocs) {
            if (vs == null) continue;
            for (Varnode vn : vs.getVarnodes()) {
                if (!vn.getAddress().isStackAddress()) continue;
                Address vnMin = vn.getAddress();
                Address vnMax = vnMin.add((long)vn.getSize());
                min = min == null || vnMin.compareTo(min) < 0 ? vnMin : min;
                max = max == null || vnMax.compareTo(max) > 0 ? vnMax : max;
            }
        }
        int purge = max == null ? 0 : (int)max.subtract(min);
        return purge + this.program.getLanguage().getProgramCounter().getNumBytes();
    }

    protected int computeStackChangeIndirect(PcodeOp op) {
        int extrapop;
        FunctionSignature sig = this.getSignatureOfIndirectCall(op);
        if (sig == null) {
            int extrapop2 = this.program.getCompilerSpec().getDefaultCallingConvention().getExtrapop();
            if (extrapop2 != 32768) {
                return extrapop2;
            }
            throw new PcodeExecutionException("Cannot get stack change for indirect call: " + op);
        }
        PrototypeModel convention = this.program.getCompilerSpec().matchConvention(sig.getCallingConventionName());
        if (convention == null) {
            this.warnings.add(new StackUnwindWarning.UnspecifiedConventionStackUnwindWarning(null));
            convention = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        if ((extrapop = convention.getExtrapop()) != 32768) {
            return extrapop;
        }
        return this.computeStdcallExtrapop(convention, sig);
    }

    protected void adjustStack(int change) {
        Sym spVal = (Sym)this.state.getVar(this.sp, this.reason);
        int size = this.sp.getNumBytes();
        Sym spChanged = (Sym)this.arithmetic.binaryOp(19, size, size, (Object)spVal, size, (Object)((Sym)this.arithmetic.fromConst((long)change, size)));
        this.state.setVar(this.sp, (Object)spChanged);
    }

    public void executeIndirectCall(PcodeOp op, PcodeFrame frame) {
        int change = this.computeStackChangeIndirect(op);
        assert (change != 32768);
        this.adjustStack(change);
    }

    public void executeConditionalBranch(PcodeOp op, PcodeFrame frame) {
    }

    protected void doExecuteIndirectBranch(PcodeOp op, PcodeFrame frame) {
    }
}

