/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import db.Transaction;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingProposals;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.app.plugin.core.debug.service.modules.DefaultRegionMapProposal;
import ghidra.app.plugin.core.debug.service.modules.DefaultSectionMapProposal;
import ghidra.app.plugin.core.debug.service.modules.ProgramModuleIndexer;
import ghidra.app.plugin.core.debug.utils.DomainFolderChangeAdapter;
import ghidra.app.plugin.core.debug.utils.ProgramLocationUtils;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MapEntry;
import ghidra.app.services.ModuleMapProposal;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.RegionMapProposal;
import ghidra.app.services.SectionMapProposal;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.generic.util.datastruct.TreeValueSortedMap;
import ghidra.generic.util.datastruct.ValueSortedMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.DefaultTraceSpan;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import ghidra.util.database.spatial.rect.Rectangle2D;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

@PluginInfo(shortDescription="Debugger static mapping manager", description="Track and manage static mappings (program-trace relocations)", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={ProgramManager.class, DebuggerTraceManagerService.class}, servicesProvided={DebuggerStaticMappingService.class})
public class DebuggerStaticMappingServicePlugin
extends Plugin
implements DebuggerStaticMappingService,
DomainFolderChangeAdapter {
    private final Map<Trace, InfoPerTrace> trackedTraceInfo = new HashMap<Trace, InfoPerTrace>();
    private final Map<URL, InfoPerProgram> trackedProgramInfo = new HashMap<URL, InfoPerProgram>();
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private ProgramManager programManager;
    private final AutoService.Wiring autoWiring;
    private final Object lock = new Object();
    private final AsyncDebouncer<Void> changeDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
    private final ListenerSet<DebuggerStaticMappingChangeListener> changeListeners = new ListenerSet(DebuggerStaticMappingChangeListener.class);
    private Set<Trace> affectedTraces = new HashSet<Trace>();
    private Set<Program> affectedPrograms = new HashSet<Program>();
    private final ProgramModuleIndexer programModuleIndexer;
    private final DebuggerStaticMappingProposals.ModuleMapProposalGenerator moduleMapProposalGenerator;

    public DebuggerStaticMappingServicePlugin(PluginTool tool) {
        super(tool);
        this.autoWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.programModuleIndexer = new ProgramModuleIndexer(tool);
        this.moduleMapProposalGenerator = new DebuggerStaticMappingProposals.ModuleMapProposalGenerator(this.programModuleIndexer);
        this.changeDebouncer.addListener(this::fireChangeListeners);
        tool.getProject().getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this);
    }

    protected void dispose() {
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListeners(Void v) {
        Set<Program> programs;
        Set<Trace> traces;
        Set<Trace> set = this.affectedTraces;
        synchronized (set) {
            traces = Collections.unmodifiableSet(this.affectedTraces);
            programs = Collections.unmodifiableSet(this.affectedPrograms);
            this.affectedTraces = new HashSet<Trace>();
            this.affectedPrograms = new HashSet<Program>();
        }
        ((DebuggerStaticMappingChangeListener)this.changeListeners.fire).mappingsChanged(traces, programs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceAffected(Trace trace) {
        Set<Trace> set = this.affectedTraces;
        synchronized (set) {
            this.affectedTraces.add(trace);
            this.changeDebouncer.contact(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programAffected(Program program) {
        Set<Trace> set = this.affectedTraces;
        synchronized (set) {
            this.affectedPrograms.add(program);
            this.changeDebouncer.contact(null);
        }
    }

    @Override
    public void addChangeListener(DebuggerStaticMappingChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    @Override
    public void removeChangeListener(DebuggerStaticMappingChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    @Override
    public CompletableFuture<Void> changesSettled() {
        return this.changeDebouncer.stable();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent openedEvt = (ProgramOpenedPluginEvent)event;
            this.programOpened(openedEvt.getProgram());
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent closedEvt = (ProgramClosedPluginEvent)event;
            this.programClosed(closedEvt.getProgram());
        } else if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent openedEvt = (TraceOpenedPluginEvent)event;
            this.traceOpened(openedEvt.getTrace());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent closedEvt = (TraceClosedPluginEvent)event;
            this.traceClosed(closedEvt.getTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programOpened(Program program) {
        Object object = this.lock;
        synchronized (object) {
            if (program instanceof TraceProgramView) {
                return;
            }
            URL url = ProgramURLUtils.getUrlFromProgram(program);
            if (url == null) {
                return;
            }
            InfoPerProgram newInfo = new InfoPerProgram(program);
            InfoPerProgram mustBeNull = this.trackedProgramInfo.put(url, newInfo);
            assert (mustBeNull == null);
            for (InfoPerTrace info : this.trackedTraceInfo.values()) {
                if (!info.programOpened(program, newInfo)) continue;
                this.programAffected(program);
                this.traceAffected(info.trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programClosed(Program program) {
        Object object = this.lock;
        synchronized (object) {
            if (program instanceof TraceProgramView) {
                return;
            }
            Iterator<InfoPerProgram> it = this.trackedProgramInfo.values().iterator();
            while (it.hasNext()) {
                InfoPerProgram infoPerProgram = it.next();
                if (infoPerProgram.program != program) continue;
                it.remove();
            }
            for (InfoPerTrace infoPerTrace : this.trackedTraceInfo.values()) {
                if (!infoPerTrace.programClosed(program)) continue;
                this.traceAffected(infoPerTrace.trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
        if (object instanceof Program) {
            Program program = (Program)object;
            Object object2 = this.lock;
            synchronized (object2) {
                this.programClosed(program);
                int i = ArrayUtils.indexOf((Object[])this.programManager.getAllOpenPrograms(), (Object)program);
                if (i >= 0) {
                    this.programOpened(program);
                }
            }
        }
    }

    private void doAffectedByTraceOpened(Trace trace) {
        for (InfoPerProgram info : this.trackedProgramInfo.values()) {
            if (!info.isMappedInTrace(trace)) continue;
            this.traceAffected(trace);
            this.programAffected(info.program);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceOpened(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            if (trace.isClosed()) {
                Msg.warn((Object)this, (Object)"Got traceOpened for a close trace");
                return;
            }
            InfoPerTrace newInfo = new InfoPerTrace(trace);
            InfoPerTrace mustBeNull = this.trackedTraceInfo.put(trace, newInfo);
            assert (mustBeNull == null);
            this.doAffectedByTraceOpened(trace);
        }
    }

    private void doAffectedByTraceClosed(Trace trace) {
        for (InfoPerProgram info : this.trackedProgramInfo.values()) {
            if (!info.traceClosed(trace)) continue;
            this.programAffected(info.program);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceClosed(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace traceInfo = this.trackedTraceInfo.remove(trace);
            if (traceInfo == null) {
                Msg.warn((Object)this, (Object)"Got traceClosed without/before traceOpened");
                return;
            }
            traceInfo.dispose();
            this.doAffectedByTraceClosed(trace);
        }
    }

    @Override
    public void addMapping(TraceLocation from, ProgramLocation to, long length, boolean truncateExisting) throws TraceConflictedMappingException {
        try (Transaction tx = from.getTrace().openTransaction("Add mapping");){
            DebuggerStaticMappingUtils.addMapping(from, to, length, truncateExisting);
        }
    }

    @Override
    public void addMapping(MapEntry<?, ?> entry, boolean truncateExisting) throws TraceConflictedMappingException {
        try (Transaction tx = entry.getFromTrace().openTransaction("Add mapping");){
            DebuggerStaticMappingUtils.addMapping(entry, truncateExisting);
        }
    }

    @Override
    public void addMappings(Collection<? extends MapEntry<?, ?>> entries, TaskMonitor monitor, boolean truncateExisting, String description) throws CancelledException {
        Map<Trace, List<MapEntry>> byTrace = entries.stream().collect(Collectors.groupingBy(ent -> ent.getFromTrace()));
        for (Map.Entry<Trace, List<MapEntry>> ent2 : byTrace.entrySet()) {
            Trace trace = ent2.getKey();
            Transaction tx = trace.openTransaction(description);
            try {
                DebuggerStaticMappingServicePlugin.doAddMappings(trace, (Collection)ent2.getValue(), monitor, truncateExisting);
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    protected static void doAddMappings(Trace trace, Collection<MapEntry<?, ?>> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        for (MapEntry<?, ?> ent : entries) {
            monitor.checkCancelled();
            try {
                DebuggerStaticMappingUtils.addMapping(ent, truncateExisting);
            }
            catch (Exception e) {
                Msg.error(DebuggerStaticMappingService.class, (Object)("Could not add mapping " + ent + ": " + e.getMessage()));
            }
        }
    }

    @Override
    public void addIdentityMapping(Trace from, Program toProgram, Lifespan lifespan, boolean truncateExisting) {
        try (Transaction tx = from.openTransaction("Add identity mappings");){
            DebuggerStaticMappingUtils.addIdentityMapping(from, toProgram, lifespan, truncateExisting);
        }
    }

    @Override
    public void addModuleMappings(Collection<ModuleMapProposal.ModuleMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        this.addMappings(entries, monitor, truncateExisting, "Add module mappings");
        HashMap<Program, List> entriesByProgram = new HashMap<Program, List>();
        for (ModuleMapProposal.ModuleMapEntry moduleMapEntry : entries) {
            if (!moduleMapEntry.isMemorize()) continue;
            entriesByProgram.computeIfAbsent(moduleMapEntry.getToProgram(), p -> new ArrayList()).add(moduleMapEntry);
        }
        for (Map.Entry entry : entriesByProgram.entrySet()) {
            Transaction tx = ((Program)entry.getKey()).openTransaction("Memorize module mapping");
            try {
                for (ModuleMapProposal.ModuleMapEntry entry2 : (List)entry.getValue()) {
                    ProgramModuleIndexer.addModulePaths(entry2.getToProgram(), List.of(entry2.getModule().getName()));
                }
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    @Override
    public void addSectionMappings(Collection<SectionMapProposal.SectionMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        this.addMappings(entries, monitor, truncateExisting, "Add sections mappings");
    }

    @Override
    public void addRegionMappings(Collection<RegionMapProposal.RegionMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        this.addMappings(entries, monitor, truncateExisting, "Add regions mappings");
    }

    protected <T> T noTraceInfo() {
        Msg.warn((Object)this, (Object)"The given trace is not open in this tool (or the service hasn't received and processed the open-trace event, yet)");
        return null;
    }

    protected <T> T noProgramInfo() {
        Msg.warn((Object)this, (Object)"The given program is not open in this tool (or the service hasn't received and processed the open-program event, yet)");
        return null;
    }

    protected <T> T noProject() {
        return DebuggerStaticMappingUtils.noProject(this);
    }

    protected InfoPerTrace requireTrackedInfo(Trace trace) {
        InfoPerTrace info = this.trackedTraceInfo.get(trace);
        if (info == null) {
            return (InfoPerTrace)((Object)this.noTraceInfo());
        }
        return info;
    }

    protected InfoPerProgram requireTrackedInfo(Program program) {
        URL url = ProgramURLUtils.getUrlFromProgram(program);
        if (url == null) {
            return (InfoPerProgram)this.noProject();
        }
        InfoPerProgram info = this.trackedProgramInfo.get(url);
        if (info == null) {
            return (InfoPerProgram)this.noProgramInfo();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Program> getOpenMappedProgramsAtSnap(Trace trace, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            return info.getOpenMappedProgramsAtSnap(snap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramLocation getOpenMappedLocation(TraceLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(loc.getTrace());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedLocations(loc.getAddress(), loc.getLifespan());
        }
    }

    protected long getNonScratchSnap(TraceProgramView view) {
        return (Long)view.getViewport().getTop(s -> s >= 0L ? s : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramLocation getStaticLocationFromDynamic(ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            loc = ProgramLocationUtils.fixLocation(loc, true);
            TraceProgramView view = (TraceProgramView)loc.getProgram();
            Trace trace = view.getTrace();
            DefaultTraceLocation tloc = new DefaultTraceLocation(trace, null, Lifespan.at((long)this.getNonScratchSnap(view)), loc.getByteAddress());
            ProgramLocation mapped = this.getOpenMappedLocation((TraceLocation)tloc);
            if (mapped == null) {
                return null;
            }
            return ProgramLocationUtils.replaceAddress(loc, mapped.getProgram(), mapped.getByteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TraceLocation> getOpenMappedLocations(ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(loc.getProgram());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedTraceLocations(loc.getByteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceLocation getOpenMappedLocation(Trace trace, ProgramLocation loc, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(loc.getProgram());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedTraceLocation(trace, loc.getByteAddress(), snap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramLocation getDynamicLocationFromStatic(TraceProgramView view, ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            TraceLocation tloc = this.getOpenMappedLocation(view.getTrace(), loc, this.getNonScratchSnap(view));
            if (tloc == null) {
                return null;
            }
            return ProgramLocationUtils.replaceAddress(loc, (Program)view, tloc.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(Trace trace, AddressSetView set, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            return info.getOpenMappedViews(set, Lifespan.at((long)snap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(Program program, AddressSetView set) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(program);
            if (info == null) {
                return Map.of();
            }
            return info.getOpenMappedViews(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Program> openMappedProgramsInView(Trace trace, AddressSetView set, long snap, Set<Exception> failures) {
        Set<URL> urls;
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            urls = info.getMappedProgramURLsInView(set, Lifespan.at((long)snap));
        }
        HashSet<Program> result = new HashSet<Program>();
        for (URL url : urls) {
            try {
                Program program = ProgramURLUtils.openHackedUpGhidraURL(this.programManager, this.tool.getProject(), url, 2);
                result.add(program);
            }
            catch (Exception e) {
                if (failures == null) {
                    throw e;
                }
                failures.add(e);
            }
        }
        return result;
    }

    protected Collection<? extends Program> orderCurrentFirst(Collection<? extends Program> programs) {
        if (this.programManager == null) {
            return programs;
        }
        Program currentProgram = this.programManager.getCurrentProgram();
        if (!programs.contains(currentProgram)) {
            return programs;
        }
        LinkedHashSet<Object> reordered = new LinkedHashSet<Object>(programs.size());
        reordered.add(currentProgram);
        reordered.addAll(programs);
        return reordered;
    }

    @Override
    public DomainFile findBestModuleProgram(AddressSpace space, TraceModule module) {
        return this.programModuleIndexer.getBestMatch(space, module, this.programManager.getCurrentProgram());
    }

    @Override
    public ModuleMapProposal proposeModuleMap(TraceModule module, Program program) {
        return this.moduleMapProposalGenerator.proposeMap(module, program);
    }

    @Override
    public ModuleMapProposal proposeModuleMap(TraceModule module, Collection<? extends Program> programs) {
        return this.moduleMapProposalGenerator.proposeBestMap(module, this.orderCurrentFirst(programs));
    }

    @Override
    public Map<TraceModule, ModuleMapProposal> proposeModuleMaps(Collection<? extends TraceModule> modules, Collection<? extends Program> programs) {
        return this.moduleMapProposalGenerator.proposeBestMaps(modules, this.orderCurrentFirst(programs));
    }

    @Override
    public SectionMapProposal proposeSectionMap(TraceSection section, Program program, MemoryBlock block) {
        return new DefaultSectionMapProposal(section, program, block);
    }

    @Override
    public SectionMapProposal proposeSectionMap(TraceModule module, Program program) {
        return DebuggerStaticMappingProposals.SECTIONS.proposeMap(module, program);
    }

    @Override
    public SectionMapProposal proposeSectionMap(TraceModule module, Collection<? extends Program> programs) {
        return (SectionMapProposal)DebuggerStaticMappingProposals.SECTIONS.proposeBestMap(module, this.orderCurrentFirst(programs));
    }

    @Override
    public Map<TraceModule, SectionMapProposal> proposeSectionMaps(Collection<? extends TraceModule> modules, Collection<? extends Program> programs) {
        return DebuggerStaticMappingProposals.SECTIONS.proposeBestMaps(modules, this.orderCurrentFirst(programs));
    }

    @Override
    public RegionMapProposal proposeRegionMap(TraceMemoryRegion region, Program program, MemoryBlock block) {
        return new DefaultRegionMapProposal(region, program, block);
    }

    @Override
    public RegionMapProposal proposeRegionMap(Collection<? extends TraceMemoryRegion> regions, Program program) {
        return DebuggerStaticMappingProposals.REGIONS.proposeMap(Collections.unmodifiableCollection(regions), program);
    }

    @Override
    public Map<Collection<TraceMemoryRegion>, RegionMapProposal> proposeRegionMaps(Collection<? extends TraceMemoryRegion> regions, Collection<? extends Program> programs) {
        Set<Set<TraceMemoryRegion>> groups = DebuggerStaticMappingProposals.groupRegionsByLikelyModule(regions);
        return DebuggerStaticMappingProposals.REGIONS.proposeBestMaps(groups, programs);
    }

    protected class InfoPerProgram
    implements DomainObjectListener {
        private Program program;
        private ValueSortedMap<MappingEntry, Address> inbound = TreeValueSortedMap.createWithNaturalOrder();

        public InfoPerProgram(Program program) {
            this.program = program;
            program.addListener((DomainObjectListener)this);
            this.loadInboundEntries();
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            if (ev.containsEvent(2)) {
                DebuggerStaticMappingServicePlugin.this.programClosed(this.program);
                DebuggerStaticMappingServicePlugin.this.programOpened(this.program);
            }
        }

        protected void loadInboundEntries() {
            for (InfoPerTrace traceInfo : DebuggerStaticMappingServicePlugin.this.trackedTraceInfo.values()) {
                for (MappingEntry out : traceInfo.outbound.values()) {
                    if (out.program != this.program) continue;
                    this.inbound.put((Object)out, (Object)out.getStaticAddress());
                }
            }
        }

        public boolean isMappedInTrace(Trace trace) {
            for (MappingEntry me : this.inbound.keySet()) {
                if (!Objects.equals(trace, me.getTrace())) continue;
                return true;
            }
            return false;
        }

        public boolean traceClosed(Trace trace) {
            HashSet<MappingEntry> updates = new HashSet<MappingEntry>();
            for (Map.Entry ent : this.inbound.entrySet()) {
                MappingEntry me = (MappingEntry)ent.getKey();
                if (!Objects.equals(trace, me.getTrace())) continue;
                updates.add(me);
            }
            return this.inbound.keySet().removeAll(updates);
        }

        public Set<TraceLocation> getOpenMappedTraceLocations(Address address) {
            HashSet<TraceLocation> result = new HashSet<TraceLocation>();
            for (Map.Entry inPreceding : this.inbound.headMapByValue((Object)address, true).entrySet()) {
                MappingEntry me;
                Address start = (Address)inPreceding.getValue();
                if (start == null || !(me = (MappingEntry)inPreceding.getKey()).isInProgramRange(address)) continue;
                result.add(me.mapProgramAddressToTraceLocation(address));
            }
            return result;
        }

        public TraceLocation getOpenMappedTraceLocation(Trace trace, Address address, long snap) {
            for (Map.Entry inPreceding : this.inbound.headMapByValue((Object)address, true).entrySet()) {
                MappingEntry me;
                Address start = (Address)inPreceding.getValue();
                if (start == null || (me = (MappingEntry)inPreceding.getKey()).getTrace() != trace || !me.isInProgramRange(address) || !me.isInTraceLifespan(snap)) continue;
                return me.mapProgramAddressToTraceLocation(address);
            }
            return null;
        }

        protected void collectOpenMappedViews(AddressRange rng, Map<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> result) {
            for (Map.Entry inPreceeding : this.inbound.headMapByValue((Object)rng.getMaxAddress(), true).entrySet()) {
                MappingEntry me;
                Address start = (Address)inPreceeding.getValue();
                if (start == null || !(me = (MappingEntry)inPreceeding.getKey()).isInProgramRange(rng)) continue;
                AddressRange srcRange = me.staticRange.intersect(rng);
                AddressRange dstRange = me.mapProgramRangeToTrace(rng);
                result.computeIfAbsent(me.getTraceSpan(), p -> new TreeSet()).add(new DebuggerStaticMappingService.MappedAddressRange(srcRange, dstRange));
            }
        }

        public Map<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(AddressSetView set) {
            HashMap<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>> result = new HashMap<TraceSpan, Collection<DebuggerStaticMappingService.MappedAddressRange>>();
            for (AddressRange rng : set) {
                this.collectOpenMappedViews(rng, result);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    protected class InfoPerTrace
    extends TraceDomainObjectListener {
        private Trace trace;
        private Map<TraceAddressSnapRange, MappingEntry> outbound = new HashMap<TraceAddressSnapRange, MappingEntry>();

        public InfoPerTrace(Trace trace) {
            this.trace = trace;
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceStaticMappingChangeType.ADDED, this::staticMappingAdded);
            this.listenFor((TraceChangeType)Trace.TraceStaticMappingChangeType.DELETED, this::staticMappingDeleted);
            trace.addListener((DomainObjectListener)this);
            this.loadOutboundEntries();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void objectRestored() {
            Object object = DebuggerStaticMappingServicePlugin.this.lock;
            synchronized (object) {
                DebuggerStaticMappingServicePlugin.this.doAffectedByTraceClosed(this.trace);
                this.outbound.clear();
                this.loadOutboundEntries();
                DebuggerStaticMappingServicePlugin.this.doAffectedByTraceOpened(this.trace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void staticMappingAdded(TraceStaticMapping mapping) {
            Object object = DebuggerStaticMappingServicePlugin.this.lock;
            synchronized (object) {
                MappingEntry me = new MappingEntry(mapping);
                this.putOutboundAndInboundEntries(me);
                if (me.program != null) {
                    DebuggerStaticMappingServicePlugin.this.traceAffected(this.trace);
                    DebuggerStaticMappingServicePlugin.this.programAffected(me.program);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void staticMappingDeleted(TraceStaticMapping mapping) {
            Object object = DebuggerStaticMappingServicePlugin.this.lock;
            synchronized (object) {
                MappingEntry me = this.outbound.get(new ImmutableTraceAddressSnapRange(mapping.getTraceAddressRange(), mapping.getLifespan()));
                if (me == null) {
                    Msg.warn((Object)((Object)this), (Object)"It appears I lost track of something that just got removed");
                    return;
                }
                Program program = me.program;
                this.removeOutboundAndInboundEntries(me);
                if (program != null) {
                    DebuggerStaticMappingServicePlugin.this.traceAffected(this.trace);
                    DebuggerStaticMappingServicePlugin.this.programAffected(program);
                }
            }
        }

        public void dispose() {
            this.trace.removeListener((DomainObjectListener)this);
        }

        protected void putOutboundAndInboundEntries(MappingEntry me) {
            this.outbound.put(me.getTraceAddressSnapRange(), me);
            InfoPerProgram destInfo = DebuggerStaticMappingServicePlugin.this.trackedProgramInfo.get(me.getStaticProgramURL());
            if (destInfo == null) {
                return;
            }
            me.programOpened(destInfo.program);
            destInfo.inbound.put((Object)me, (Object)me.getStaticAddress());
        }

        protected void removeOutboundAndInboundEntries(MappingEntry me) {
            this.outbound.remove(me.getTraceAddressSnapRange());
            InfoPerProgram destInfo = DebuggerStaticMappingServicePlugin.this.trackedProgramInfo.get(me.getStaticProgramURL());
            if (destInfo == null) {
                return;
            }
            destInfo.inbound.remove((Object)me);
        }

        protected void loadOutboundEntries() {
            TraceStaticMappingManager manager = this.trace.getStaticMappingManager();
            for (TraceStaticMapping mapping : manager.getAllEntries()) {
                this.putOutboundAndInboundEntries(new MappingEntry(mapping));
            }
        }

        public boolean programOpened(Program other, InfoPerProgram otherInfo) {
            boolean result = false;
            for (MappingEntry me : this.outbound.values()) {
                if (!me.programOpened(other)) continue;
                otherInfo.inbound.put((Object)me, (Object)me.getStaticAddress());
                result = true;
            }
            return result;
        }

        public boolean programClosed(Program other) {
            boolean result = false;
            for (MappingEntry me : this.outbound.values()) {
                result |= me.programClosed(other);
            }
            return result;
        }

        public Set<Program> getOpenMappedProgramsAtSnap(long snap) {
            HashSet<Program> result = new HashSet<Program>();
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                MappingEntry me = out.getValue();
                if (!me.isStaticProgramOpen() || !out.getKey().getLifespan().contains(snap)) continue;
                result.add(me.program);
            }
            return result;
        }

        public ProgramLocation getOpenMappedLocations(Address address, Lifespan span) {
            ImmutableTraceAddressSnapRange at = new ImmutableTraceAddressSnapRange(address, span);
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                MappingEntry me;
                if (!out.getKey().intersects((Rectangle2D)at) || !(me = out.getValue()).isStaticProgramOpen()) continue;
                return me.mapTraceAddressToProgramLocation(address);
            }
            return null;
        }

        protected void collectOpenMappedPrograms(AddressRange rng, Lifespan span, Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> result) {
            ImmutableTraceAddressSnapRange tatr = new ImmutableTraceAddressSnapRange(rng, span);
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                MappingEntry me = out.getValue();
                if (me.program == null || !out.getKey().intersects((Rectangle2D)tatr)) continue;
                AddressRange srcRng = out.getKey().getRange().intersect(rng);
                AddressRange dstRng = me.mapTraceRangeToProgram(rng);
                result.computeIfAbsent(me.program, p -> new TreeSet()).add(new DebuggerStaticMappingService.MappedAddressRange(srcRng, dstRng));
            }
        }

        public Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(AddressSetView set, Lifespan span) {
            HashMap<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> result = new HashMap<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>>();
            for (AddressRange rng : set) {
                this.collectOpenMappedPrograms(rng, span, result);
            }
            return Collections.unmodifiableMap(result);
        }

        protected void collectMappedProgramURLsInView(AddressRange rng, Lifespan span, Set<URL> result) {
            ImmutableTraceAddressSnapRange tatr = new ImmutableTraceAddressSnapRange(rng, span);
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                if (!out.getKey().intersects((Rectangle2D)tatr)) continue;
                MappingEntry me = out.getValue();
                result.add(me.getStaticProgramURL());
            }
        }

        public Set<URL> getMappedProgramURLsInView(AddressSetView set, Lifespan span) {
            HashSet<URL> result = new HashSet<URL>();
            for (AddressRange rng : set) {
                this.collectMappedProgramURLsInView(rng, span, result);
            }
            return Collections.unmodifiableSet(result);
        }
    }

    protected class MappingEntry {
        private final TraceStaticMapping mapping;
        private Program program;
        private AddressRange staticRange;

        public MappingEntry(TraceStaticMapping mapping) {
            this.mapping = mapping;
        }

        public Trace getTrace() {
            return this.mapping.getTrace();
        }

        public Address addOrMax(Address start, long length) {
            Address result = start.addWrapSpace(length);
            if (result.compareTo((Object)start) < 0) {
                Msg.warn((Object)this, (Object)"Mapping entry caused overflow in static address space");
                return start.getAddressSpace().getMaxAddress();
            }
            return result;
        }

        public boolean programOpened(Program opened) {
            if (this.mapping.getStaticProgramURL().equals(ProgramURLUtils.getUrlFromProgram(opened))) {
                this.program = opened;
                Address minAddr = opened.getAddressFactory().getAddress(this.mapping.getStaticAddress());
                Address maxAddr = this.addOrMax(minAddr, this.mapping.getLength() - 1L);
                this.staticRange = new AddressRangeImpl(minAddr, maxAddr);
                return true;
            }
            return false;
        }

        public boolean programClosed(Program closed) {
            if (this.program == closed) {
                this.program = null;
                this.staticRange = null;
                return true;
            }
            return false;
        }

        public Address getTraceAddress() {
            return this.mapping.getMinTraceAddress();
        }

        public Address getStaticAddress() {
            if (this.staticRange == null) {
                return null;
            }
            return this.staticRange.getMinAddress();
        }

        public TraceSpan getTraceSpan() {
            return new DefaultTraceSpan(this.mapping.getTrace(), this.mapping.getLifespan());
        }

        public TraceAddressSnapRange getTraceAddressSnapRange() {
            return new ImmutableTraceAddressSnapRange(this.mapping.getTraceAddressRange(), this.mapping.getLifespan());
        }

        public boolean isInTraceRange(Address address, Long snap) {
            return this.mapping.getTraceAddressRange().contains(address) && (snap == null || this.mapping.getLifespan().contains((Object)snap));
        }

        public boolean isInTraceRange(AddressRange rng, Long snap) {
            return this.mapping.getTraceAddressRange().intersects(rng) && (snap == null || this.mapping.getLifespan().contains((Object)snap));
        }

        public boolean isInTraceLifespan(long snap) {
            return this.mapping.getLifespan().contains(snap);
        }

        public boolean isInProgramRange(Address address) {
            if (this.staticRange == null) {
                return false;
            }
            return this.staticRange.contains(address);
        }

        public boolean isInProgramRange(AddressRange rng) {
            if (this.staticRange == null) {
                return false;
            }
            return this.staticRange.intersects(rng);
        }

        protected Address mapTraceAddressToProgram(Address address) {
            assert (this.isInTraceRange(address, null));
            long offset = address.subtract(this.mapping.getMinTraceAddress());
            return this.staticRange.getMinAddress().addWrapSpace(offset);
        }

        public ProgramLocation mapTraceAddressToProgramLocation(Address address) {
            if (this.program == null) {
                throw new IllegalStateException("Static program is not opened");
            }
            return new ProgramLocation(this.program, this.mapTraceAddressToProgram(address));
        }

        public AddressRange mapTraceRangeToProgram(AddressRange rng) {
            assert (this.isInTraceRange(rng, null));
            AddressRange part = rng.intersect(this.mapping.getTraceAddressRange());
            Address min = this.mapTraceAddressToProgram(part.getMinAddress());
            Address max = this.mapTraceAddressToProgram(part.getMaxAddress());
            return new AddressRangeImpl(min, max);
        }

        protected Address mapProgramAddressToTrace(Address address) {
            assert (this.isInProgramRange(address));
            long offset = address.subtract(this.staticRange.getMinAddress());
            return this.mapping.getMinTraceAddress().addWrapSpace(offset);
        }

        protected TraceLocation mapProgramAddressToTraceLocation(Address address) {
            return new DefaultTraceLocation(this.mapping.getTrace(), null, this.mapping.getLifespan(), this.mapProgramAddressToTrace(address));
        }

        public AddressRange mapProgramRangeToTrace(AddressRange rng) {
            assert (rng.intersects(this.staticRange));
            AddressRange part = rng.intersect(this.staticRange);
            Address min = this.mapProgramAddressToTrace(part.getMinAddress());
            Address max = this.mapProgramAddressToTrace(part.getMaxAddress());
            return new AddressRangeImpl(min, max);
        }

        public boolean isStaticProgramOpen() {
            return this.program != null;
        }

        public URL getStaticProgramURL() {
            return this.mapping.getStaticProgramURL();
        }
    }
}

