/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.record;

import db.Transaction;
import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.ObjectBasedDebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.service.model.DebuggerModelServicePlugin;
import ghidra.app.plugin.core.debug.service.model.PermanentTransactionExecutor;
import ghidra.app.plugin.core.debug.service.model.record.DataTypeRecorder;
import ghidra.app.plugin.core.debug.service.model.record.EmptyDebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.service.model.record.MemoryRecorder;
import ghidra.app.plugin.core.debug.service.model.record.ObjectRecorder;
import ghidra.app.plugin.core.debug.service.model.record.RecorderUtils;
import ghidra.app.plugin.core.debug.service.model.record.SymbolRecorder;
import ghidra.app.plugin.core.debug.service.model.record.TimeRecorder;
import ghidra.app.services.TraceRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.error.DebuggerModelAccessException;
import ghidra.dbg.target.TargetActiveScope;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetDataTypeNamespace;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetSymbolNamespace;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.Msg;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.task.TaskMonitor;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class ObjectBasedTraceRecorder
implements TraceRecorder {
    protected static final int POOL_SIZE = Math.min(16, Runtime.getRuntime().availableProcessors());
    protected static final int DELAY_MS = 100;
    protected static final int BLOCK_BITS = 12;
    protected final Trace trace;
    protected final TargetObject target;
    protected final ObjectBasedDebuggerTargetTraceMapper mapper;
    protected final DebuggerMemoryMapper memoryMapper;
    protected final DebuggerRegisterMapper emptyRegisterMapper = new EmptyDebuggerRegisterMapper();
    protected final TimeRecorder timeRecorder;
    protected final ObjectRecorder objectRecorder;
    protected final MemoryRecorder memoryRecorder;
    protected final DataTypeRecorder dataTypeRecorder;
    protected final SymbolRecorder symbolRecorder;
    protected final ListenerForRecord listenerForRecord;
    protected final ListenerSet<TraceRecorderListener> listeners = new ListenerSet(TraceRecorderListener.class);
    protected TargetObject curFocus;
    protected boolean valid = true;

    public ObjectBasedTraceRecorder(DebuggerModelServicePlugin service, Trace trace, TargetObject target, ObjectBasedDebuggerTargetTraceMapper mapper) {
        trace.addConsumer((Object)this);
        this.trace = trace;
        this.target = target;
        this.mapper = mapper;
        this.memoryMapper = mapper.offerMemory(null).getNow(null);
        this.timeRecorder = new TimeRecorder(this);
        this.objectRecorder = new ObjectRecorder(this);
        this.memoryRecorder = new MemoryRecorder(this);
        this.dataTypeRecorder = new DataTypeRecorder(this);
        this.symbolRecorder = new SymbolRecorder(this);
        this.listenerForRecord = new ListenerForRecord();
    }

    @Override
    public CompletableFuture<Void> init() {
        this.timeRecorder.createSnapshot("Started recording " + this.target.getModel(), null, null);
        this.target.getModel().addModelListener((DebuggerModelListener)this.listenerForRecord, true);
        return AsyncUtils.NIL;
    }

    @Override
    public TargetObject getTarget() {
        return this.target;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public long getSnap() {
        return this.timeRecorder.getSnap();
    }

    @Override
    public TraceSnapshot forceSnapshot() {
        return this.timeRecorder.forceSnapshot();
    }

    @Override
    public boolean isRecording() {
        return this.valid;
    }

    @Override
    public void stopRecording() {
        this.invalidate();
        this.fireRecordingStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate() {
        this.target.getModel().removeModelListener((DebuggerModelListener)this.listenerForRecord);
        ObjectBasedTraceRecorder objectBasedTraceRecorder = this;
        synchronized (objectBasedTraceRecorder) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
        }
        this.trace.release((Object)this);
    }

    @Override
    public void addListener(TraceRecorderListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(TraceRecorderListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public TargetObject getTargetObject(TraceObject obj) {
        return this.objectRecorder.toTarget(obj);
    }

    @Override
    public TraceObject getTraceObject(TargetObject obj) {
        return this.objectRecorder.toTrace(obj);
    }

    @Override
    public TargetBreakpointLocation getTargetBreakpoint(TraceBreakpoint bpt) {
        return this.objectRecorder.getTargetInterface((TraceUniqueObject)bpt, TraceObjectBreakpointLocation.class, TargetBreakpointLocation.class);
    }

    @Override
    public TraceBreakpoint getTraceBreakpoint(TargetBreakpointLocation bpt) {
        return (TraceBreakpoint)this.objectRecorder.getTraceInterface((TargetObject)bpt, TraceObjectBreakpointLocation.class);
    }

    @Override
    public TargetMemoryRegion getTargetMemoryRegion(TraceMemoryRegion region) {
        return this.objectRecorder.getTargetInterface((TraceUniqueObject)region, TraceObjectMemoryRegion.class, TargetMemoryRegion.class);
    }

    @Override
    public TraceMemoryRegion getTraceMemoryRegion(TargetMemoryRegion region) {
        return (TraceMemoryRegion)this.objectRecorder.getTraceInterface((TargetObject)region, TraceObjectMemoryRegion.class);
    }

    @Override
    public TargetModule getTargetModule(TraceModule module) {
        return this.objectRecorder.getTargetInterface((TraceUniqueObject)module, TraceObjectModule.class, TargetModule.class);
    }

    @Override
    public TraceModule getTraceModule(TargetModule module) {
        return (TraceModule)this.objectRecorder.getTraceInterface((TargetObject)module, TraceObjectModule.class);
    }

    @Override
    public TargetSection getTargetSection(TraceSection section) {
        return this.objectRecorder.getTargetInterface((TraceUniqueObject)section, TraceObjectSection.class, TargetSection.class);
    }

    @Override
    public TraceSection getTraceSection(TargetSection section) {
        return (TraceSection)this.objectRecorder.getTraceInterface((TargetObject)section, TraceObjectSection.class);
    }

    @Override
    public TargetThread getTargetThread(TraceThread thread) {
        if (thread == null) {
            return null;
        }
        return this.objectRecorder.getTargetInterface((TraceUniqueObject)thread, TraceObjectThread.class, TargetThread.class);
    }

    @Override
    public TargetExecutionStateful.TargetExecutionState getTargetThreadState(TargetThread thread) {
        return (TargetExecutionStateful.TargetExecutionState)thread.getTypedAttributeNowByName("_state", TargetExecutionStateful.TargetExecutionState.class, (Object)TargetExecutionStateful.TargetExecutionState.INACTIVE);
    }

    @Override
    public TargetExecutionStateful.TargetExecutionState getTargetThreadState(TraceThread thread) {
        return this.getTargetThreadState(this.getTargetThread(thread));
    }

    @Override
    public Set<TargetRegisterBank> getTargetRegisterBanks(TraceThread thread, int frameLevel) {
        return Set.of(this.objectRecorder.getTargetFrameInterface(thread, frameLevel, TargetRegisterBank.class));
    }

    @Override
    public TraceThread getTraceThread(TargetThread thread) {
        return (TraceThread)this.objectRecorder.getTraceInterface((TargetObject)thread, TraceObjectThread.class);
    }

    @Override
    public TraceThread getTraceThreadForSuccessor(TargetObject successor) {
        TraceObject traceObject = this.objectRecorder.toTrace(successor);
        if (traceObject == null) {
            return null;
        }
        return traceObject.queryCanonicalAncestorsInterface(TraceObjectThread.class).findFirst().orElse(null);
    }

    @Override
    public TraceStackFrame getTraceStackFrame(TargetStackFrame frame) {
        return (TraceStackFrame)this.objectRecorder.getTraceInterface((TargetObject)frame, TraceObjectStackFrame.class);
    }

    @Override
    public TraceStackFrame getTraceStackFrameForSuccessor(TargetObject successor) {
        TraceObject traceObject = this.objectRecorder.toTrace(successor);
        if (traceObject == null) {
            return null;
        }
        return traceObject.queryCanonicalAncestorsInterface(TraceObjectStackFrame.class).findFirst().orElse(null);
    }

    @Override
    public TargetStackFrame getTargetStackFrame(TraceThread thread, int frameLevel) {
        return this.objectRecorder.getTargetFrameInterface(thread, frameLevel, TargetStackFrame.class);
    }

    @Override
    public Set<TargetThread> getLiveTargetThreads() {
        return this.trace.getObjectManager().getRootObject().querySuccessorsInterface(Lifespan.at((long)this.getSnap()), TraceObjectThread.class, true).map(t -> this.objectRecorder.getTargetInterface(t.getObject(), TargetThread.class)).collect(Collectors.toSet());
    }

    @Override
    public DebuggerRegisterMapper getRegisterMapper(TraceThread thread) {
        return this.emptyRegisterMapper;
    }

    @Override
    public DebuggerMemoryMapper getMemoryMapper() {
        return this.memoryMapper;
    }

    @Override
    public boolean isRegisterBankAccessible(TargetRegisterBank bank) {
        return true;
    }

    @Override
    public boolean isRegisterBankAccessible(TraceThread thread, int frameLevel) {
        return true;
    }

    @Override
    public AddressSetView getAccessibleMemory() {
        return this.memoryRecorder.getAccessible();
    }

    protected TargetRegisterContainer getTargetRegisterContainer(TraceThread thread, int frameLevel) {
        if (!(thread instanceof TraceObjectThread)) {
            throw new AssertionError((Object)("thread = " + thread));
        }
        TraceObjectThread tot = (TraceObjectThread)thread;
        TraceObject objThread = tot.getObject();
        TraceObject regContainer = objThread.queryRegisterContainer(frameLevel);
        if (regContainer == null) {
            Msg.error((Object)this, (Object)("No register container for " + thread + " and frame " + frameLevel + " in trace"));
            return null;
        }
        TargetObject result = this.target.getModel().getModelObject(regContainer.getCanonicalPath().getKeyList());
        if (result == null) {
            Msg.error((Object)this, (Object)("No register container for " + thread + " and frame " + frameLevel + " on target"));
            return null;
        }
        return (TargetRegisterContainer)result;
    }

    @Override
    public CompletableFuture<Void> captureThreadRegisters(TracePlatform platform, TraceThread thread, int frameLevel, Set<Register> registers) {
        TargetRegisterContainer regContainer = this.getTargetRegisterContainer(thread, frameLevel);
        if (regContainer == null) {
            return AsyncUtils.NIL;
        }
        return regContainer.resync();
    }

    protected static byte[] encodeValue(int byteLength, BigInteger value) {
        return Utils.bigIntegerToBytes((BigInteger)value, (int)byteLength, (boolean)true);
    }

    protected TargetRegisterBank isExactRegisterOnTarget(TracePlatform platform, TargetRegisterContainer regContainer, Register register) {
        PathMatcher matcher = platform.getConventionalRegisterPath(regContainer.getSchema(), List.of(), register);
        for (TargetObject targetObject : matcher.getCachedSuccessors((TargetObject)regContainer).values()) {
            TargetObject targetObject2;
            TargetRegister targetRegister;
            DebuggerObjectModel model;
            List pathBank;
            if (!(targetObject instanceof TargetRegister) || (pathBank = (model = (targetRegister = (TargetRegister)targetObject).getModel()).getRootSchema().searchForAncestor(TargetRegisterBank.class, targetRegister.getPath())) == null || !((targetObject2 = model.getModelObject(pathBank)) instanceof TargetRegisterBank)) continue;
            TargetRegisterBank targetBank = (TargetRegisterBank)targetObject2;
            return targetBank;
        }
        return null;
    }

    protected TargetRegisterBank isExactRegisterOnTarget(TracePlatform platform, TraceThread thread, int frameLevel, Register register) {
        TargetRegisterContainer regContainer = this.getTargetRegisterContainer(thread, frameLevel);
        if (regContainer == null) {
            return null;
        }
        return this.isExactRegisterOnTarget(platform, regContainer, register);
    }

    @Override
    public Register isRegisterOnTarget(TracePlatform platform, TraceThread thread, int frameLevel, Register register) {
        while (register != null) {
            TargetRegisterBank targetBank = this.isExactRegisterOnTarget(platform, thread, frameLevel, register);
            if (targetBank != null) {
                return register;
            }
            register = register.getParentRegister();
        }
        return null;
    }

    @Override
    public CompletableFuture<Void> writeThreadRegisters(TracePlatform platform, TraceThread thread, int frameLevel, Map<Register, RegisterValue> values) {
        TargetRegisterContainer regContainer = this.getTargetRegisterContainer(thread, frameLevel);
        if (regContainer == null) {
            return AsyncUtils.NIL;
        }
        HashMap<TargetRegisterBank, Map> writesByBank = new HashMap<TargetRegisterBank, Map>();
        for (RegisterValue rv : values.values()) {
            Register register = rv.getRegister();
            PathMatcher matcher = platform.getConventionalRegisterPath(regContainer.getSchema(), List.of(), register);
            Collection regs = matcher.getCachedSuccessors((TargetObject)regContainer).values();
            if (regs.isEmpty()) {
                Msg.warn((Object)this, (Object)("No register object for " + register));
            }
            for (TargetObject objRegUntyped : regs) {
                TargetRegister objReg = (TargetRegister)objRegUntyped;
                List pathBank = objReg.getModel().getRootSchema().searchForAncestor(TargetRegisterBank.class, objReg.getPath());
                if (pathBank == null) {
                    Msg.warn((Object)this, (Object)("No register bank for " + register));
                    continue;
                }
                TargetRegisterBank objBank = (TargetRegisterBank)objReg.getModel().getModelObject(pathBank);
                if (objBank == null) {
                    Msg.warn((Object)this, (Object)("No register bank for " + register));
                    continue;
                }
                writesByBank.computeIfAbsent(objBank, __ -> new HashMap()).put(objReg, ObjectBasedTraceRecorder.encodeValue(objReg.getByteLength(), rv.getUnsignedValue()));
            }
        }
        AsyncFence fence = new AsyncFence();
        for (Map.Entry ent : writesByBank.entrySet()) {
            fence.include(((TargetRegisterBank)ent.getKey()).writeRegisters((Map)ent.getValue()));
        }
        return fence.ready();
    }

    @Override
    public CompletableFuture<byte[]> readMemory(Address start, int length) {
        return this.memoryRecorder.read(start, length);
    }

    @Override
    public CompletableFuture<Void> writeMemory(Address start, byte[] data) {
        return this.memoryRecorder.write(start, data);
    }

    @Override
    public CompletableFuture<Void> readMemoryBlocks(AddressSetView set, TaskMonitor monitor) {
        return RecorderUtils.INSTANCE.readMemoryBlocks(this, 12, set, monitor);
    }

    @Override
    public CompletableFuture<Void> captureDataTypes(TraceModule module, TaskMonitor monitor) {
        return this.dataTypeRecorder.captureDataTypes(this.getTargetModule(module), monitor);
    }

    @Override
    public CompletableFuture<Void> captureDataTypes(TargetDataTypeNamespace namespace, TaskMonitor monitor) {
        return this.dataTypeRecorder.captureDataTypes(namespace, monitor);
    }

    @Override
    public CompletableFuture<Void> captureSymbols(TraceModule module, TaskMonitor monitor) {
        return this.symbolRecorder.captureSymbols(this.getTargetModule(module), monitor);
    }

    @Override
    public CompletableFuture<Void> captureSymbols(TargetSymbolNamespace namespace, TaskMonitor monitor) {
        return this.symbolRecorder.captureSymbols(namespace, monitor);
    }

    @Override
    public List<TargetBreakpointSpecContainer> collectBreakpointContainers(TargetThread thread) {
        if (thread == null) {
            return this.objectRecorder.collectTargetSuccessors(this.target, TargetBreakpointSpecContainer.class, false);
        }
        return this.objectRecorder.collectTargetSuccessors((TargetObject)thread, TargetBreakpointSpecContainer.class, false);
    }

    @Override
    public List<TargetBreakpointLocation> collectBreakpoints(TargetThread thread) {
        if (thread == null) {
            return this.objectRecorder.collectTargetSuccessors(this.target, TargetBreakpointLocation.class, true);
        }
        BreakpointConvention convention = new BreakpointConvention(this.objectRecorder.getTraceInterface((TargetObject)thread, TraceObjectThread.class));
        return this.trace.getObjectManager().queryAllInterface(Lifespan.at((long)this.getSnap()), TraceObjectBreakpointLocation.class).filter(convention::appliesTo).map(tl -> this.objectRecorder.getTargetInterface(tl.getObject(), TargetBreakpointLocation.class)).collect(Collectors.toList());
    }

    @Override
    public Set<TraceBreakpointKind> getSupportedBreakpointKinds() {
        return this.objectRecorder.collectTargetSuccessors(this.target, TargetBreakpointSpecContainer.class, false).stream().flatMap(c -> c.getSupportedBreakpointKinds().stream()).map(k -> TraceRecorder.targetToTraceBreakpointKind(k)).collect(Collectors.toSet());
    }

    @Override
    public boolean isSupportsFocus() {
        return this.objectRecorder.isSupportsFocus;
    }

    @Override
    public boolean isSupportsActivation() {
        return this.objectRecorder.isSupportsActivation;
    }

    @Override
    public TargetObject getFocus() {
        return this.curFocus;
    }

    @Override
    public CompletableFuture<Boolean> requestFocus(TargetObject focus) {
        for (TargetFocusScope scope : this.objectRecorder.collectTargetSuccessors(this.target, TargetFocusScope.class, false)) {
            if (!PathUtils.isAncestor((List)scope.getPath(), (List)focus.getPath())) continue;
            return ((CompletableFuture)scope.requestFocus(focus).thenApply(__ -> true)).exceptionally(ex -> {
                ex = AsyncUtils.unwrapThrowable((Throwable)ex);
                String msg = "Could not focus " + focus + ": " + ex.getMessage();
                if (ex instanceof DebuggerModelAccessException) {
                    Msg.info((Object)this, (Object)msg);
                } else {
                    Msg.error((Object)this, (Object)msg, (Throwable)ex);
                }
                return false;
            });
        }
        Msg.info((Object)this, (Object)("Could not find suitable focus scope for " + focus));
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Boolean> requestActivation(TargetObject active) {
        for (TargetActiveScope scope : this.objectRecorder.collectTargetSuccessors(this.target, TargetActiveScope.class, false)) {
            if (!PathUtils.isAncestor((List)scope.getPath(), (List)active.getPath())) continue;
            return ((CompletableFuture)scope.requestActivation(active).thenApply(__ -> true)).exceptionally(ex -> {
                ex = AsyncUtils.unwrapThrowable((Throwable)ex);
                String msg = "Could not activate " + active + ": " + ex.getMessage();
                if (ex instanceof DebuggerModelAccessException) {
                    Msg.info((Object)this, (Object)msg);
                } else {
                    Msg.error((Object)this, (Object)msg, (Throwable)ex);
                }
                return false;
            });
        }
        Msg.info((Object)this, (Object)("Could not find suitable active scope for " + active));
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Void> flushTransactions() {
        return this.listenerForRecord.tx.flush();
    }

    protected void fireSnapAdvanced(long key) {
        ((TraceRecorderListener)this.listeners.fire).snapAdvanced(this, key);
    }

    protected void fireRecordingStopped() {
        ((TraceRecorderListener)this.listeners.fire).recordingStopped(this);
    }

    protected class ListenerForRecord
    extends AnnotatedDebuggerAttributeListener {
        private final PermanentTransactionExecutor tx;
        private boolean ignoreInvalidation;

        public ListenerForRecord() {
            super(MethodHandles.lookup());
            this.tx = new PermanentTransactionExecutor((UndoableDomainObject)ObjectBasedTraceRecorder.this.trace, "OBTraceRecorder: ", POOL_SIZE, 100);
            this.ignoreInvalidation = false;
        }

        public void event(TargetObject object, TargetThread eventThread, TargetEventScope.TargetEventType type, String description, List<Object> parameters) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            if (type == TargetEventScope.TargetEventType.RUNNING) {
                this.ignoreInvalidation = true;
                return;
            }
            TraceObjectThread traceEventThread = ObjectBasedTraceRecorder.this.objectRecorder.getTraceInterface((TargetObject)eventThread, TraceObjectThread.class);
            ObjectBasedTraceRecorder.this.timeRecorder.createSnapshot(description, (TraceThread)traceEventThread, null);
            this.ignoreInvalidation = false;
        }

        public void invalidateCacheRequested(TargetObject object) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            if (this.ignoreInvalidation) {
                return;
            }
            if (object instanceof TargetMemory) {
                long snap = ObjectBasedTraceRecorder.this.timeRecorder.getSnap();
                String path = object.getJoinedPath(".");
                this.tx.execute("Memory invalidated: " + path, () -> ObjectBasedTraceRecorder.this.memoryRecorder.invalidate((TargetMemory)object, snap), path);
            }
        }

        public void memoryUpdated(TargetObject memory, Address address, byte[] data) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            long snap = ObjectBasedTraceRecorder.this.timeRecorder.getSnap();
            String path = memory.getJoinedPath(".");
            Address tAddress = ObjectBasedTraceRecorder.this.getMemoryMapper().targetToTrace(address);
            this.tx.execute("Memory observed: " + path, () -> ObjectBasedTraceRecorder.this.memoryRecorder.recordMemory(snap, tAddress, data), path);
        }

        public void memoryReadError(TargetObject memory, AddressRange range, DebuggerMemoryAccessException e) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            long snap = ObjectBasedTraceRecorder.this.timeRecorder.getSnap();
            String path = memory.getJoinedPath(".");
            Address tMin = ObjectBasedTraceRecorder.this.getMemoryMapper().targetToTrace(range.getMinAddress());
            this.tx.execute("Memory read error: " + path, () -> ObjectBasedTraceRecorder.this.memoryRecorder.recordError(snap, tMin, e), path);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_focus")
        protected void focusChanged(TargetObject scope, TargetObject focused) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            ObjectBasedTraceRecorder.this.curFocus = focused;
        }

        public void created(TargetObject object) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            long snap = ObjectBasedTraceRecorder.this.timeRecorder.getSnap();
            String path = object.getJoinedPath(".");
            try (Transaction trans = ObjectBasedTraceRecorder.this.trace.openTransaction("Object created: " + path);){
                ObjectBasedTraceRecorder.this.objectRecorder.recordCreated(snap, object);
            }
        }

        public void invalidated(TargetObject object, TargetObject branch, String reason) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            long snap = ObjectBasedTraceRecorder.this.timeRecorder.getSnap();
            String path = object.getJoinedPath(".");
            this.tx.execute("Object invalidated: " + path, () -> ObjectBasedTraceRecorder.this.objectRecorder.recordInvalidated(snap, object), path);
            if (object == ObjectBasedTraceRecorder.this.target) {
                ObjectBasedTraceRecorder.this.stopRecording();
                return;
            }
            if (object instanceof TargetMemory) {
                ObjectBasedTraceRecorder.this.memoryRecorder.removeMemory((TargetMemory)object);
            }
            if (object instanceof TargetMemoryRegion) {
                ObjectBasedTraceRecorder.this.memoryRecorder.removeRegion((TargetMemoryRegion)object);
            }
        }

        public void attributesChanged(TargetObject object, Collection<String> removed, Map<String, ?> added) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            long snap = ObjectBasedTraceRecorder.this.timeRecorder.getSnap();
            String path = object.getJoinedPath(".");
            this.tx.execute("Object attributes changed: " + path, () -> ObjectBasedTraceRecorder.this.objectRecorder.recordAttributes(snap, object, removed, added), path);
            super.attributesChanged(object, removed, added);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_range")
        public void rangeChanged(TargetObject object, AddressRange range) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            if (!(object instanceof TargetMemoryRegion)) {
                return;
            }
            ObjectBasedTraceRecorder.this.memoryRecorder.adjustRegionRange((TargetMemoryRegion)object, range);
        }

        @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_memory")
        public void memoryChanged(TargetObject object, TargetMemory memory) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            if (!(object instanceof TargetMemoryRegion)) {
                return;
            }
            ObjectBasedTraceRecorder.this.memoryRecorder.addRegionMemory((TargetMemoryRegion)object, memory);
        }

        public void elementsChanged(TargetObject object, Collection<String> removed, Map<String, ? extends TargetObject> added) {
            if (!ObjectBasedTraceRecorder.this.valid) {
                return;
            }
            long snap = ObjectBasedTraceRecorder.this.timeRecorder.getSnap();
            String path = object.getJoinedPath(".");
            this.tx.execute("Object elements changed: " + path, () -> ObjectBasedTraceRecorder.this.objectRecorder.recordElements(snap, object, removed, added), path);
        }
    }

    private class BreakpointConvention {
        private final TraceObjectThread thread;
        private final TraceObject process;

        private BreakpointConvention(TraceObjectThread thread) {
            this.thread = thread;
            TraceObject object = thread.getObject();
            this.process = object.queryAncestorsTargetInterface(Lifespan.at((long)ObjectBasedTraceRecorder.this.getSnap()), TargetProcess.class).map(p -> p.getSource(object)).findFirst().orElse(null);
        }

        private boolean appliesTo(TraceObjectBreakpointLocation loc) {
            TraceObject object = loc.getObject();
            if (object.queryAncestorsInterface(Lifespan.at((long)ObjectBasedTraceRecorder.this.getSnap()), TraceObjectThread.class).anyMatch(t -> t == this.thread)) {
                return true;
            }
            if (this.process == null) {
                return false;
            }
            return object.queryAncestorsTargetInterface(Lifespan.at((long)ObjectBasedTraceRecorder.this.getSnap()), TargetProcess.class).map(p -> p.getSource(object)).anyMatch(p -> p == this.process);
        }
    }
}

