/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model.record;

import ghidra.app.plugin.core.debug.service.model.record.ObjectBasedTraceRecorder;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressCollectors;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import utilities.util.IDKeyed;

class MemoryRecorder {
    protected final ObjectBasedTraceRecorder recorder;
    protected final TraceMemoryManager memoryManager;
    protected final Map<IDKeyed<AddressSpace>, TargetMemory> memoriesByTargetSpace = new HashMap<IDKeyed<AddressSpace>, TargetMemory>();
    protected final Map<IDKeyed<TargetMemoryRegion>, AddressRange> regions = new HashMap<IDKeyed<TargetMemoryRegion>, AddressRange>();

    protected MemoryRecorder(ObjectBasedTraceRecorder recorder) {
        this.recorder = recorder;
        this.memoryManager = recorder.trace.getMemoryManager();
    }

    private TargetMemory getMemoryForSpace(AddressSpace space) {
        return this.memoriesByTargetSpace.get(new IDKeyed((Object)space));
    }

    private void addMemoryForSpace(AddressSpace targetSpace, TargetMemory memory) {
        TargetMemory exists = this.memoriesByTargetSpace.put((IDKeyed<AddressSpace>)new IDKeyed((Object)targetSpace), memory);
        if (exists != null && exists != memory) {
            Msg.warn((Object)this, (Object)("Address space duplicated between memories: " + exists + " and " + memory));
        }
    }

    protected void addRegionMemory(TargetMemoryRegion region, TargetMemory memory) {
        this.addMemoryForSpace(region.getRange().getMinAddress().getAddressSpace(), memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustRegionRange(TargetMemoryRegion region, AddressRange range) {
        Map<IDKeyed<TargetMemoryRegion>, AddressRange> map = this.regions;
        synchronized (map) {
            AddressRange tRange = this.recorder.memoryMapper.targetToTrace(range);
            if (tRange == null) {
                this.regions.remove(new IDKeyed((Object)region));
            } else {
                this.regions.put((IDKeyed<TargetMemoryRegion>)new IDKeyed((Object)region), tRange);
            }
        }
    }

    protected void removeMemory(TargetMemory memory) {
        while (this.memoriesByTargetSpace.values().remove(memory)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRegion(TargetMemoryRegion region) {
        Map<IDKeyed<TargetMemoryRegion>, AddressRange> map = this.regions;
        synchronized (map) {
            this.regions.remove(new IDKeyed((Object)region));
        }
    }

    protected CompletableFuture<byte[]> read(Address start, int length) {
        Address tStart = this.recorder.memoryMapper.traceToTarget(start);
        if (tStart == null) {
            return CompletableFuture.completedFuture(new byte[0]);
        }
        TargetMemory memory = this.getMemoryForSpace(tStart.getAddressSpace());
        if (memory == null) {
            return CompletableFuture.completedFuture(new byte[0]);
        }
        return memory.readMemory(tStart, length);
    }

    protected CompletableFuture<Void> write(Address start, byte[] data) {
        Address tStart = this.recorder.memoryMapper.traceToTarget(start);
        if (tStart == null) {
            throw new IllegalArgumentException("Address space " + start.getAddressSpace() + " not defined on the target");
        }
        TargetMemory memory = this.getMemoryForSpace(tStart.getAddressSpace());
        if (memory == null) {
            throw new IllegalArgumentException("Address space " + tStart.getAddressSpace() + " cannot be found in target memory");
        }
        return memory.writeMemory(tStart, data);
    }

    protected void invalidate(TargetMemory memory, long snap) {
        Set targetSpaces = this.memoriesByTargetSpace.entrySet().stream().filter(e -> e.getValue() == memory).map(e -> (AddressSpace)((IDKeyed)e.getKey()).obj).collect(Collectors.toSet());
        for (AddressSpace targetSpace : targetSpaces) {
            Address traceMin = this.recorder.memoryMapper.targetToTrace(targetSpace.getMinAddress());
            Address traceMax = traceMin.getAddressSpace().getMaxAddress();
            this.memoryManager.setState(snap, traceMin, traceMax, TraceMemoryState.UNKNOWN);
        }
    }

    protected void recordMemory(long snap, Address start, byte[] data) {
        this.memoryManager.putBytes(snap, start, ByteBuffer.wrap(data));
    }

    public void recordError(long snap, Address tMin, DebuggerMemoryAccessException e) {
        this.memoryManager.setState(snap, tMin, TraceMemoryState.ERROR);
    }

    protected boolean isAccessible(TraceMemoryRegion r) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressSetView getAccessible() {
        Map<IDKeyed<TargetMemoryRegion>, AddressRange> map = this.regions;
        synchronized (map) {
            return (AddressSetView)this.regions.values().stream().collect(AddressCollectors.toAddressSet());
        }
    }
}

