/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import db.Transaction;
import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionSet;
import ghidra.app.plugin.core.debug.service.breakpoint.PlaceEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.PlaceTargetBreakpointActionItem;
import ghidra.app.services.ControlMode;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.LogicalBreakpoint;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import utilities.util.IDHashed;

class TraceBreakpointSet {
    private final PluginTool tool;
    private final Trace trace;
    private final Address address;
    private final Set<IDHashed<TraceBreakpoint>> breakpoints = new HashSet<IDHashed<TraceBreakpoint>>();
    private TraceRecorder recorder;
    private String emuSleigh;

    public TraceBreakpointSet(PluginTool tool, Trace trace, Address address) {
        this.tool = Objects.requireNonNull(tool);
        this.trace = Objects.requireNonNull(trace);
        this.address = Objects.requireNonNull(address);
    }

    public String toString() {
        return String.format("<at %s in %s: %s>", this.address, this.trace.getName(), this.breakpoints);
    }

    public void setRecorder(TraceRecorder recorder) {
        this.recorder = recorder;
    }

    private ControlMode getControlMode() {
        DebuggerControlService service = (DebuggerControlService)this.tool.getService(DebuggerControlService.class);
        return service == null ? ControlMode.DEFAULT : service.getCurrentMode(this.trace);
    }

    private long getSnap() {
        DebuggerTraceManagerService service = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        if (service == null) {
            return (Long)this.trace.getProgramView().getViewport().getReversedSnaps().get(0);
        }
        return service.getCurrentFor(this.trace).getSnap();
    }

    public Trace getTrace() {
        return this.trace;
    }

    public Address getAddress() {
        return this.address;
    }

    public Address computeTargetAddress() {
        if (this.recorder == null) {
            throw new AssertionError();
        }
        return this.recorder.getMemoryMapper().traceToTarget(this.address);
    }

    public LogicalBreakpoint.TraceMode computeMode() {
        LogicalBreakpoint.TraceMode mode = LogicalBreakpoint.TraceMode.NONE;
        if (this.getControlMode().useEmulatedBreakpoints()) {
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                if ((mode = mode.combine(this.computeEmuMode((TraceBreakpoint)bpt.obj))) != LogicalBreakpoint.TraceMode.MISSING) continue;
                return mode;
            }
            return mode;
        }
        for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
            if ((mode = mode.combine(this.computeTargetMode((TraceBreakpoint)bpt.obj))) != LogicalBreakpoint.TraceMode.MISSING) continue;
            return mode;
        }
        return mode;
    }

    public LogicalBreakpoint.TraceMode computeMode(TraceBreakpoint bpt) {
        return this.getControlMode().useEmulatedBreakpoints() ? this.computeEmuMode(bpt) : this.computeTargetMode(bpt);
    }

    public LogicalBreakpoint.TraceMode computeTargetMode(TraceBreakpoint bpt) {
        return LogicalBreakpoint.TraceMode.fromBool(bpt.isEnabled(this.getSnap()));
    }

    public LogicalBreakpoint.TraceMode computeEmuMode(TraceBreakpoint bpt) {
        return LogicalBreakpoint.TraceMode.fromBool(bpt.isEmuEnabled(this.getSnap()));
    }

    public String computeSleigh() {
        String sleigh = null;
        for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
            String s = ((TraceBreakpoint)bpt.obj).getEmuSleigh();
            if (sleigh != null && !sleigh.equals(s)) {
                return null;
            }
            sleigh = s;
        }
        return sleigh;
    }

    public void setEmuSleigh(String emuSleigh) {
        this.emuSleigh = emuSleigh;
        try (Transaction tx = this.trace.openTransaction("Set breakpoint Sleigh");){
            for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
                ((TraceBreakpoint)bpt.obj).setEmuSleigh(emuSleigh);
            }
        }
    }

    public boolean isEmpty() {
        return this.breakpoints.isEmpty();
    }

    public Set<TraceBreakpoint> getBreakpoints() {
        return this.breakpoints.stream().map(e -> (TraceBreakpoint)e.obj).collect(Collectors.toUnmodifiableSet());
    }

    public boolean add(TraceBreakpoint bpt) {
        if ("emu_swi();\nemu_exec_decoded();\n".equals(bpt.getEmuSleigh()) && this.emuSleigh != null) {
            try (Transaction tx = this.trace.openTransaction("Set breakpoint Sleigh");){
                bpt.setEmuSleigh(this.emuSleigh);
            }
        }
        return this.breakpoints.add((IDHashed<TraceBreakpoint>)new IDHashed((Object)bpt));
    }

    public boolean canMerge(TraceBreakpoint bpt) {
        if (this.trace != bpt.getTrace()) {
            return false;
        }
        return this.address.equals((Object)bpt.getMinAddress());
    }

    public boolean remove(TraceBreakpoint bpt) {
        return this.breakpoints.remove(new IDHashed((Object)bpt));
    }

    public void planEnable(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
        long snap = this.getSnap();
        if (this.breakpoints.isEmpty()) {
            if (this.recorder == null || this.getControlMode().useEmulatedBreakpoints()) {
                this.planPlaceEmu(actions, snap, length, kinds);
            } else {
                this.planPlaceTarget(actions, snap, length, kinds);
            }
        } else if (this.recorder == null || this.getControlMode().useEmulatedBreakpoints()) {
            this.planEnableEmu(actions);
        } else {
            this.planEnableTarget(actions);
        }
    }

    private void planPlaceTarget(BreakpointActionSet actions, long snap, long length, Collection<TraceBreakpointKind> kinds) {
        if (snap != this.recorder.getSnap()) {
            throw new AssertionError((Object)"Target breakpoints must be requested at present snap");
        }
        Set<TargetBreakpointSpec.TargetBreakpointKind> tKinds = TraceRecorder.traceToTargetBreakpointKinds(kinds);
        for (TargetBreakpointSpecContainer cont : this.recorder.collectBreakpointContainers(null)) {
            LinkedHashSet<TargetBreakpointSpec.TargetBreakpointKind> supKinds = new LinkedHashSet<TargetBreakpointSpec.TargetBreakpointKind>(tKinds);
            supKinds.retainAll((Collection<?>)cont.getSupportedBreakpointKinds());
            actions.add(new PlaceTargetBreakpointActionItem(cont, this.computeTargetAddress(), length, supKinds));
        }
    }

    private void planPlaceEmu(BreakpointActionSet actions, long snap, long length, Collection<TraceBreakpointKind> kinds) {
        actions.add(new PlaceEmuBreakpointActionItem(this.trace, snap, this.address, length, Set.copyOf(kinds), this.emuSleigh));
    }

    private void planEnableTarget(BreakpointActionSet actions) {
        for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
            TargetBreakpointLocation loc = this.recorder.getTargetBreakpoint((TraceBreakpoint)bpt.obj);
            if (loc == null) continue;
            actions.planEnableTarget(loc);
        }
    }

    private void planEnableEmu(BreakpointActionSet actions) {
        for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
            actions.planEnableEmu((TraceBreakpoint)bpt.obj);
        }
    }

    public void planDisable(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
        if (this.getControlMode().useEmulatedBreakpoints()) {
            this.planDisableEmu(actions);
        } else {
            this.planDisableTarget(actions, length, kinds);
        }
    }

    private void planDisableTarget(BreakpointActionSet actions, long length, Collection<TraceBreakpointKind> kinds) {
        Set<TargetBreakpointSpec.TargetBreakpointKind> tKinds = TraceRecorder.traceToTargetBreakpointKinds(kinds);
        Address targetAddr = this.computeTargetAddress();
        for (TargetBreakpointLocation loc : this.recorder.collectBreakpoints(null)) {
            TargetBreakpointSpec spec;
            AddressRange range = loc.getRange();
            if (!targetAddr.equals((Object)range.getMinAddress()) || length != range.getLength() || !Objects.equals((spec = loc.getSpecification()).getKinds(), tKinds)) continue;
            actions.planDisableTarget(loc);
        }
    }

    private void planDisableEmu(BreakpointActionSet actions) {
        for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
            actions.planDisableEmu((TraceBreakpoint)bpt.obj);
        }
    }

    public void planDelete(BreakpointActionSet actions, long length, Set<TraceBreakpointKind> kinds) {
        if (this.getControlMode().useEmulatedBreakpoints()) {
            this.planDeleteEmu(actions);
        } else {
            this.planDeleteTarget(actions, length, kinds);
        }
    }

    private void planDeleteTarget(BreakpointActionSet actions, long length, Set<TraceBreakpointKind> kinds) {
        Set<TargetBreakpointSpec.TargetBreakpointKind> tKinds = TraceRecorder.traceToTargetBreakpointKinds(kinds);
        Address targetAddr = this.computeTargetAddress();
        for (TargetBreakpointLocation loc : this.recorder.collectBreakpoints(null)) {
            TargetBreakpointSpec spec;
            AddressRange range = loc.getRange();
            if (!targetAddr.equals((Object)range.getMinAddress()) || length != range.getLength() || !Objects.equals((spec = loc.getSpecification()).getKinds(), tKinds)) continue;
            actions.planDeleteTarget(loc);
        }
    }

    private void planDeleteEmu(BreakpointActionSet actions) {
        for (IDHashed<TraceBreakpoint> bpt : this.breakpoints) {
            actions.planDeleteEmu((TraceBreakpoint)bpt.obj);
        }
    }
}

