/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.RangeCursorTableHeaderRenderer;
import docking.widgets.tree.support.GTreeSelectionEvent;
import generic.theme.GColor;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.MultiProviderSaveBehavior;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTablePanel;
import ghidra.app.plugin.core.debug.gui.model.DebuggerModelPlugin;
import ghidra.app.plugin.core.debug.gui.model.DebuggerObjectActionContext;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.ObjectTreeModel;
import ghidra.app.plugin.core.debug.gui.model.ObjectsTablePanel;
import ghidra.app.plugin.core.debug.gui.model.ObjectsTreePanel;
import ghidra.app.plugin.core.debug.gui.model.PathTableModel;
import ghidra.app.plugin.core.debug.gui.model.PathsTablePanel;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class DebuggerModelProvider
extends ComponentProvider
implements MultiProviderSaveBehavior.SaveableProvider {
    private static final GColor COLOR_BORDER_DISCONNECTED = new GColor("color.border.provider.disconnected");
    private static final AutoConfigState.ClassHandler<DebuggerModelProvider> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerModelProvider.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String KEY_DEBUGGER_COORDINATES = "DebuggerCoordinates";
    private static final String KEY_PATH = "Path";
    private final DebuggerModelPlugin plugin;
    private final boolean isClone;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    protected JTextField pathField;
    protected JButton goButton;
    protected ObjectsTreePanel objectsTreePanel;
    protected ObjectsTablePanel elementsTablePanel;
    protected PathsTablePanel attributesTablePanel;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    TraceObjectKeyPath path = TraceObjectKeyPath.of((String[])new String[0]);
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    @AutoConfigStateField
    private boolean limitToSnap = false;
    @AutoConfigStateField
    private boolean showHidden = false;
    @AutoConfigStateField
    private boolean showPrimitivesInTree = false;
    @AutoConfigStateField
    private boolean showMethodsInTree = false;
    DockingAction actionCloneWindow;
    ToggleDockingAction actionLimitToCurrentSnap;
    ToggleDockingAction actionShowHidden;
    ToggleDockingAction actionShowPrimitivesInTree;
    ToggleDockingAction actionShowMethodsInTree;
    DockingAction actionFollowLink;
    DebuggerObjectActionContext myActionContext;
    private final AbstractQueryTablePanel.CellActivationListener elementActivationListener = table -> this.activatedElementsTable();
    private final AbstractQueryTablePanel.CellActivationListener attributeActivationListener = table -> this.activatedAttributesTable();
    private final RangeCursorTableHeaderRenderer.SeekListener seekListener = pos -> {
        long snap = Math.round(pos);
        if (this.current.getTrace() == null || snap < 0L) {
            snap = 0L;
        }
        this.traceManager.activateSnap(snap);
    };

    public DebuggerModelProvider(DebuggerModelPlugin plugin, boolean isClone) {
        super((Tool)plugin.getTool(), "Model", plugin.getName());
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.plugin = plugin;
        this.isClone = isClone;
        this.setIcon(DebuggerResources.ICON_PROVIDER_MODEL);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_MODEL);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.createActions();
        if (isClone) {
            this.setTitle("[Model]");
            this.setWindowGroup("Debugger.Core.disconnected");
            this.setIntraGroupPosition(WindowPosition.STACK);
            this.mainPanel.setBorder(BorderFactory.createLineBorder((Color)COLOR_BORDER_DISCONNECTED, 2));
            this.setTransient();
        } else {
            this.setTitle("Model");
            this.setWindowGroup("Debugger.Core");
        }
        this.doSetLimitToCurrentSnap(this.limitToSnap);
        this.setVisible(true);
        this.contextChanged();
    }

    public void removeFromTool() {
        this.plugin.providerRemoved(this);
        super.removeFromTool();
    }

    protected void buildMainPanel() {
        this.pathField = new JTextField();
        this.pathField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                try {
                    TraceObjectKeyPath path = TraceObjectKeyPath.parse((String)DebuggerModelProvider.this.pathField.getText());
                    DebuggerModelProvider.this.setPath(path);
                    DebuggerModelProvider.this.objectsTreePanel.setSelectedKeyPaths(List.of(path));
                    return true;
                }
                catch (IllegalArgumentException e) {
                    DebuggerModelProvider.this.plugin.getTool().setStatusInfo("Invalid Path: " + DebuggerModelProvider.this.pathField.getText(), true);
                    return false;
                }
            }
        });
        this.goButton = new JButton("Go");
        ActionListener gotoPath = evt -> {
            try {
                TraceObjectKeyPath path = TraceObjectKeyPath.parse((String)this.pathField.getText());
                this.activatePath(path);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            catch (IllegalArgumentException e) {
                Msg.showError((Object)this, (Component)this.mainPanel, (String)"Model", (Object)("Invalid Query: " + this.pathField.getText()));
            }
        };
        this.goButton.addActionListener(gotoPath);
        this.pathField.addActionListener(gotoPath);
        this.pathField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DebuggerModelProvider.this.pathField.setText(DebuggerModelProvider.this.path.toString());
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                }
            }
        });
        this.objectsTreePanel = new ObjectsTreePanel();
        this.elementsTablePanel = new ObjectsTablePanel(this.plugin);
        this.attributesTablePanel = new PathsTablePanel(this.plugin);
        JSplitPane lrSplit = new JSplitPane(1);
        lrSplit.setResizeWeight(0.2);
        JSplitPane tbSplit = new JSplitPane(0);
        tbSplit.setResizeWeight(0.7);
        lrSplit.setRightComponent(tbSplit);
        JPanel queryPanel = new JPanel(new BorderLayout());
        queryPanel.add((Component)new JLabel("Path: "), "West");
        queryPanel.add((Component)this.pathField, "Center");
        queryPanel.add((Component)this.goButton, "East");
        JPanel labeledElementsTablePanel = new JPanel(new BorderLayout());
        labeledElementsTablePanel.add(this.elementsTablePanel);
        labeledElementsTablePanel.add((Component)new JLabel("Elements"), "North");
        JPanel labeledAttributesTablePanel = new JPanel(new BorderLayout());
        labeledAttributesTablePanel.add(this.attributesTablePanel);
        labeledAttributesTablePanel.add((Component)new JLabel("Attributes"), "North");
        lrSplit.setLeftComponent(this.objectsTreePanel);
        tbSplit.setLeftComponent(labeledElementsTablePanel);
        tbSplit.setRightComponent(labeledAttributesTablePanel);
        this.mainPanel.add((Component)queryPanel, "North");
        this.mainPanel.add((Component)lrSplit, "Center");
        this.objectsTreePanel.addTreeSelectionListener(evt -> {
            Trace trace = this.current.getTrace();
            if (trace == null) {
                return;
            }
            if (trace.getObjectManager().getRootObject() == null) {
                return;
            }
            List<ObjectTreeModel.AbstractNode> sel = this.objectsTreePanel.getSelectedItems();
            this.myActionContext = !sel.isEmpty() ? new DebuggerObjectActionContext(sel.stream().map(n -> n.getValue()).collect(Collectors.toList()), this, this.objectsTreePanel) : null;
            this.contextChanged();
            if (sel.size() != 1) {
                return;
            }
            TraceObjectValue value = sel.get(0).getValue();
            this.setPath(value.getCanonicalPath(), this.objectsTreePanel);
        });
        this.objectsTreePanel.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    DebuggerModelProvider.this.activateObjectSelectedInTree();
                }
            }
        });
        this.objectsTreePanel.tree.tree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerModelProvider.this.activateObjectSelectedInTree();
                    e.consume();
                }
            }
        });
        this.elementsTablePanel.addSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            List sel = this.elementsTablePanel.getSelectedItems();
            this.myActionContext = !sel.isEmpty() ? new DebuggerObjectActionContext(sel.stream().map(r -> r.getValue()).collect(Collectors.toList()), this, this.elementsTablePanel) : null;
            this.contextChanged();
            if (sel.size() != 1) {
                this.attributesTablePanel.setQuery(ModelQuery.attributesOf(this.path));
                return;
            }
            TraceObjectValue value = ((ObjectTableModel.ValueRow)sel.get(0)).getValue();
            if (!value.isObject()) {
                return;
            }
            TraceObject object = value.getChild();
            this.attributesTablePanel.setQuery(ModelQuery.attributesOf(object.getCanonicalPath()));
        });
        this.attributesTablePanel.addSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            List sel = this.attributesTablePanel.getSelectedItems();
            this.myActionContext = !sel.isEmpty() ? new DebuggerObjectActionContext(sel.stream().map(r -> Objects.requireNonNull(r.getPath().getLastEntry())).collect(Collectors.toList()), this, this.attributesTablePanel) : null;
            this.contextChanged();
        });
        this.elementsTablePanel.addCellActivationListener(this.elementActivationListener);
        this.attributesTablePanel.addCellActivationListener(this.attributeActivationListener);
        this.elementsTablePanel.addSeekListener(this.seekListener);
        this.attributesTablePanel.addSeekListener(this.seekListener);
    }

    private void activateObjectSelectedInTree() {
        List<ObjectTreeModel.AbstractNode> sel = this.objectsTreePanel.getSelectedItems();
        if (sel.size() != 1) {
            return;
        }
        TraceObjectValue value = sel.get(0).getValue();
        Object object = value.getValue();
        if (object instanceof TraceObject) {
            TraceObject child = (TraceObject)object;
            this.activatePath(child.getCanonicalPath());
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext != null) {
            return this.myActionContext;
        }
        return super.getActionContext(event);
    }

    protected void createActions() {
        this.actionCloneWindow = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloneWindowAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null)).onAction(c -> this.activatedCloneWindow())).buildAndInstallLocal((ComponentProvider)this);
        this.actionLimitToCurrentSnap = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.LimitToCurrentSnapAction.builder(this.plugin).onAction(this::toggledLimitToCurrentSnap)).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowHidden = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.ShowHiddenAction.builder(this.plugin).onAction(this::toggledShowHidden)).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowPrimitivesInTree = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.ShowPrimitivesInTreeAction.builder(this.plugin).onAction(this::toggledShowPrimitivesInTree)).buildAndInstallLocal((ComponentProvider)this);
        this.actionShowMethodsInTree = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.ShowMethodsInTreeAction.builder(this.plugin).onAction(this::toggledShowMethodsInTree)).buildAndInstallLocal((ComponentProvider)this);
        this.actionFollowLink = (DockingAction)DebuggerResources.FollowLinkAction.builder(this.plugin).withContext(DebuggerObjectActionContext.class).enabledWhen(this::hasSingleLink).onAction(this::activatedFollowLink).buildAndInstallLocal((ComponentProvider)this);
    }

    private void activatedElementsTable() {
        ObjectTableModel.ValueRow row = (ObjectTableModel.ValueRow)this.elementsTablePanel.getSelectedItem();
        if (row == null) {
            return;
        }
        if (!(row instanceof ObjectTableModel.ObjectRow)) {
            return;
        }
        ObjectTableModel.ObjectRow objectRow = (ObjectTableModel.ObjectRow)row;
        this.activatePath(objectRow.getTraceObject().getCanonicalPath());
    }

    private void activatedAttributesTable() {
        PathTableModel.PathRow row = (PathTableModel.PathRow)this.attributesTablePanel.getSelectedItem();
        if (row == null) {
            return;
        }
        Object value = row.getValue();
        if (!(value instanceof TraceObject)) {
            return;
        }
        TraceObject object = (TraceObject)value;
        this.activatePath(object.getCanonicalPath());
    }

    private void activatedCloneWindow() {
        DebuggerModelProvider clone = this.plugin.createDisconnectedProvider();
        SaveState configState = new SaveState();
        this.writeConfigState(configState);
        clone.readConfigState(configState);
        SaveState dataState = new SaveState();
        this.writeDataState(dataState);
        clone.coordinatesActivated(this.current);
        clone.readDataState(dataState);
        this.plugin.getTool().showComponentProvider((ComponentProvider)clone, true);
    }

    private void toggledLimitToCurrentSnap(ActionContext ctx) {
        this.setLimitToCurrentSnap(this.actionLimitToCurrentSnap.isSelected());
    }

    private void toggledShowHidden(ActionContext ctx) {
        this.setShowHidden(this.actionShowHidden.isSelected());
    }

    private void toggledShowPrimitivesInTree(ActionContext ctx) {
        this.setShowPrimitivesInTree(this.actionShowPrimitivesInTree.isSelected());
    }

    private void toggledShowMethodsInTree(ActionContext ctx) {
        this.setShowMethodsInTree(this.actionShowMethodsInTree.isSelected());
    }

    private boolean hasSingleLink(DebuggerObjectActionContext ctx) {
        List<TraceObjectValue> values = ctx.getObjectValues();
        if (values.size() != 1) {
            return false;
        }
        TraceObjectValue val = values.get(0);
        return !val.isCanonical() && val.isObject();
    }

    private void activatedFollowLink(DebuggerObjectActionContext ctx) {
        List<TraceObjectValue> values = ctx.getObjectValues();
        if (values.size() != 1) {
            return;
        }
        TraceObjectKeyPath canonicalPath = values.get(0).getChild().getCanonicalPath();
        this.setPath(canonicalPath);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    protected TraceObjectKeyPath findAsSibling(TraceObject object) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return null;
        }
        TraceObjectKeyPath parentPath = this.path.parent();
        if (parentPath == null) {
            return null;
        }
        TraceObject parent = trace.getObjectManager().getObjectByCanonicalPath(parentPath);
        if (parent == null) {
            return null;
        }
        for (TraceObjectValue value : parent.getValues()) {
            if (!Objects.equals(object, value.getValue())) continue;
            return value.getCanonicalPath();
        }
        return null;
    }

    protected TraceObjectKeyPath findAsParent(TraceObject object) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return null;
        }
        TraceObjectManager objectManager = trace.getObjectManager();
        if (objectManager.getRootObject() == null) {
            return null;
        }
        TraceObjectValue sel = this.getTreeSelection();
        if (sel == null) {
            return null;
        }
        for (TraceObjectKeyPath p = sel.getCanonicalPath(); p != null; p = p.parent()) {
            if (objectManager.getObjectByCanonicalPath(p) != object) continue;
            return p;
        }
        return null;
    }

    public void coordinatesActivated(DebuggerCoordinates coords) {
        this.current = coords;
        this.objectsTreePanel.goToCoordinates(coords);
        this.elementsTablePanel.goToCoordinates(coords);
        this.attributesTablePanel.goToCoordinates(coords);
        this.checkPath();
        if (this.isClone) {
            return;
        }
        TraceObject object = coords.getObject();
        if (object == null) {
            return;
        }
        if (this.attributesTablePanel.trySelect(object)) {
            return;
        }
        if (this.elementsTablePanel.trySelect(object)) {
            return;
        }
        if (this.findAsParent(object) != null) {
            return;
        }
        TraceObjectKeyPath sibling = this.findAsSibling(object);
        if (sibling != null) {
            this.objectsTreePanel.setSelectedKeyPaths(List.of(sibling));
            this.setPath(sibling);
        } else {
            this.objectsTreePanel.setSelectedObject(object);
            this.setPath(object.getCanonicalPath());
        }
    }

    public void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            this.coordinatesActivated(DebuggerCoordinates.NOWHERE);
        }
    }

    protected void activatePath(TraceObjectKeyPath path) {
        Trace trace = this.current.getTrace();
        if (trace != null) {
            TraceObject object = trace.getObjectManager().getObjectByCanonicalPath(path);
            if (object != null) {
                this.traceManager.activateObject(object);
                return;
            }
            object = trace.getObjectManager().getObjectsByPath(Lifespan.at((long)this.current.getSnap()), path).findFirst().orElse(null);
            if (object != null) {
                this.traceManager.activateObject(object);
                return;
            }
        }
    }

    protected void setPath(TraceObjectKeyPath path, JComponent source) {
        if (Objects.equals(this.path, path) && this.getTreeSelection() != null) {
            return;
        }
        this.path = path;
        if (source != this.objectsTreePanel) {
            this.setTreeSelection(path);
        }
        this.pathField.setText(path.toString());
        this.objectsTreePanel.repaint();
        this.elementsTablePanel.setQuery(ModelQuery.elementsOf(path));
        this.attributesTablePanel.setQuery(ModelQuery.attributesOf(path));
        this.checkPath();
    }

    public void setPath(TraceObjectKeyPath path) {
        this.setPath(path, null);
    }

    protected void checkPath() {
        if (this.objectsTreePanel.getNode(this.path) == null) {
            this.plugin.getTool().setStatusInfo("No such object at path " + this.path, true);
        }
    }

    public TraceObjectKeyPath getPath() {
        return this.path;
    }

    protected void doSetLimitToCurrentSnap(boolean limitToSnap) {
        this.limitToSnap = limitToSnap;
        this.actionLimitToCurrentSnap.setSelected(limitToSnap);
        this.objectsTreePanel.setLimitToSnap(limitToSnap);
        this.elementsTablePanel.setLimitToSnap(limitToSnap);
        this.attributesTablePanel.setLimitToSnap(limitToSnap);
    }

    public void setLimitToCurrentSnap(boolean limitToSnap) {
        if (this.limitToSnap == limitToSnap) {
            return;
        }
        this.doSetLimitToCurrentSnap(limitToSnap);
    }

    public boolean isLimitToCurrentSnap() {
        return this.limitToSnap;
    }

    protected void doSetShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
        this.actionShowHidden.setSelected(showHidden);
        this.objectsTreePanel.setShowHidden(showHidden);
        this.elementsTablePanel.setShowHidden(showHidden);
        this.attributesTablePanel.setShowHidden(showHidden);
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.doSetShowHidden(showHidden);
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    protected void doSetShowPrimitivesInTree(boolean showPrimitivesInTree) {
        this.showPrimitivesInTree = showPrimitivesInTree;
        this.actionShowPrimitivesInTree.setSelected(showPrimitivesInTree);
        this.objectsTreePanel.setShowPrimitives(showPrimitivesInTree);
    }

    public void setShowPrimitivesInTree(boolean showPrimitivesInTree) {
        if (this.showPrimitivesInTree == showPrimitivesInTree) {
            return;
        }
        this.doSetShowPrimitivesInTree(showPrimitivesInTree);
    }

    public boolean isShowPrimitivesInTree() {
        return this.showPrimitivesInTree;
    }

    protected void doSetShowMethodsInTree(boolean showMethodsInTree) {
        this.showMethodsInTree = showMethodsInTree;
        this.actionShowMethodsInTree.setSelected(showMethodsInTree);
        this.objectsTreePanel.setShowMethods(showMethodsInTree);
    }

    public void setShowMethodsInTree(boolean showMethodsInTree) {
        if (this.showMethodsInTree == showMethodsInTree) {
            return;
        }
        this.doSetShowMethodsInTree(showMethodsInTree);
    }

    public boolean isShowMethodsInTree() {
        return this.showMethodsInTree;
    }

    protected void setTreeSelection(TraceObjectKeyPath path, GTreeSelectionEvent.EventOrigin origin) {
        this.objectsTreePanel.setSelectedKeyPaths(List.of(path), origin);
    }

    protected void setTreeSelection(TraceObjectKeyPath path) {
        this.setTreeSelection(path, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    protected TraceObjectValue getTreeSelection() {
        ObjectTreeModel.AbstractNode sel = this.objectsTreePanel.getSelectedItem();
        return sel == null ? null : sel.getValue();
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    @Override
    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.doSetLimitToCurrentSnap(this.limitToSnap);
        this.doSetShowHidden(this.showHidden);
        this.doSetShowPrimitivesInTree(this.showPrimitivesInTree);
        this.doSetShowMethodsInTree(this.showMethodsInTree);
    }

    @Override
    public void writeDataState(SaveState saveState) {
        if (this.isClone) {
            this.current.writeDataState(this.plugin.getTool(), saveState, KEY_DEBUGGER_COORDINATES);
        }
        saveState.putString(KEY_PATH, this.path.toString());
    }

    @Override
    public void readDataState(SaveState saveState) {
        DebuggerCoordinates coords;
        if (this.isClone && (coords = DebuggerCoordinates.readDataState(this.plugin.getTool(), saveState, KEY_DEBUGGER_COORDINATES)) != DebuggerCoordinates.NOWHERE) {
            this.coordinatesActivated(coords);
        }
        this.setPath(TraceObjectKeyPath.parse((String)saveState.getString(KEY_PATH, "")));
    }
}

