/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.listing;

import docking.widgets.fieldpanel.support.BackgroundColorModel;
import generic.theme.GColor;
import ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MultiBlendedListingBackgroundColorModel
implements ListingBackgroundColorModel {
    private static final Color COLOR_BACKGROUND = new GColor("color.bg");
    private final List<BackgroundColorModel> models = new ArrayList<BackgroundColorModel>();
    private final ColorUtils.ColorBlender blender = new ColorUtils.ColorBlender();

    public void addModel(BackgroundColorModel m) {
        this.models.add(m);
    }

    public void removeModel(BackgroundColorModel m) {
        this.models.remove(m);
    }

    public Color getBackgroundColor(BigInteger index) {
        this.blender.clear();
        for (BackgroundColorModel m : this.models) {
            Color c = m.getBackgroundColor(index);
            if (c == null || c.equals(m.getDefaultBackgroundColor())) continue;
            this.blender.add(c);
        }
        return this.blender.getColor(this.getDefaultBackgroundColor());
    }

    public Color getDefaultBackgroundColor() {
        if (this.models.isEmpty()) {
            return COLOR_BACKGROUND;
        }
        return this.models.get(0).getDefaultBackgroundColor();
    }

    public void setDefaultBackgroundColor(Color c) {
        for (BackgroundColorModel m : this.models) {
            m.setDefaultBackgroundColor(c);
        }
    }

    public void modelDataChanged(ListingPanel listingPanel) {
        for (BackgroundColorModel m : this.models) {
            if (!(m instanceof ListingBackgroundColorModel)) continue;
            ListingBackgroundColorModel lm = (ListingBackgroundColorModel)m;
            lm.modelDataChanged(listingPanel);
        }
    }
}

