/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ColorProvider;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.awt.Color;
import java.util.Set;

public class SliceHighlightColorProvider
implements ColorProvider {
    private Set<Varnode> varnodes;
    private Varnode specialVn;
    private PcodeOp specialOp;
    private Color hlColor;
    private Color specialHlColor;

    SliceHighlightColorProvider(DecompilerPanel panel, Set<Varnode> varnodes, Varnode specialVn, PcodeOp specialOp) {
        this.varnodes = varnodes;
        this.specialVn = specialVn;
        this.specialOp = specialOp;
        this.hlColor = panel.getCurrentVariableHighlightColor();
        this.specialHlColor = panel.getSpecialHighlightColor();
    }

    @Override
    public Color getColor(ClangToken token) {
        Varnode vn = DecompilerUtils.getVarnodeRef(token);
        if (vn == null) {
            return null;
        }
        Color c = null;
        if (this.varnodes.contains(vn)) {
            c = this.hlColor;
        }
        if (this.specialOp == null) {
            return c;
        }
        if (vn == this.specialVn && token.getPcodeOp() == this.specialOp) {
            c = this.specialHlColor;
        }
        return c;
    }
}

