/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModel;
import generic.jar.ResourceFile;
import ghidra.docking.settings.Settings;
import ghidra.framework.Application;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.dialog.ExtensionDetails;
import ghidra.framework.plugintool.dialog.ExtensionException;
import ghidra.framework.plugintool.dialog.ExtensionUtils;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import utilities.util.FileUtilities;

class ExtensionTableModel
extends ThreadedTableModel<ExtensionDetails, Object> {
    static final int INSTALLED_COL = 0;
    static final int NAME_COL = 1;
    private Set<ExtensionDetails> extensions;
    private boolean modelChanged = false;

    protected ExtensionTableModel(ServiceProvider serviceProvider) {
        super("Extensions", serviceProvider);
    }

    protected TableColumnDescriptor<ExtensionDetails> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionInstalledColumn(), 0, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionNameColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionDescriptionColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ExtensionVersionColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ExtensionInstallationDirColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ExtensionArchiveFileColumn());
        return descriptor;
    }

    public int getPrimarySortColumnIndex() {
        return 1;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (Application.inSingleJarMode() || SystemUtilities.isInDevelopmentMode()) {
            return false;
        }
        ExtensionDetails extension = this.getSelectedExtension(rowIndex);
        if (!this.isValidVersion(extension)) {
            return false;
        }
        if (extension.getInstallPath() != null && FileUtilities.isPathContainedWithin((File)Application.getApplicationLayout().getApplicationInstallationDir().getFile(false), (File)new File(extension.getInstallPath()))) {
            return false;
        }
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        if (columnIndex != 0) {
            return;
        }
        ResourceFile installDir = (ResourceFile)Application.getApplicationLayout().getExtensionInstallationDirs().get(0);
        if (!installDir.exists() && !installDir.mkdir()) {
            Msg.showError((Object)((Object)this), null, (String)"Directory Error", (Object)"Cannot install/uninstall extensions: Failed to create extension installation directory.\nSee the \"Ghidra Extension Notes\" section of the Ghidra Installation Guide for more information.");
        }
        if (!installDir.canWrite()) {
            Msg.showError((Object)((Object)this), null, (String)"Permissions Error", (Object)"Cannot install/uninstall extensions: Invalid write permissions on installation directory.\nSee the \"Ghidra Extension Notes\" section of the Ghidra Installation Guide for more information.");
            return;
        }
        boolean install = (Boolean)aValue;
        ExtensionDetails extension = this.getSelectedExtension(rowIndex);
        if (install) {
            if (ExtensionUtils.install(extension, true)) {
                this.modelChanged = true;
            }
        } else if (ExtensionUtils.removeStateFiles(extension)) {
            this.modelChanged = true;
        }
        this.refreshTable();
    }

    private boolean isValidVersion(ExtensionDetails details) {
        String ghidraVersion = Application.getApplicationVersion();
        String extensionVersion = details.getVersion();
        return ghidraVersion.equals(extensionVersion);
    }

    public Object getDataSource() {
        return null;
    }

    protected void doLoad(Accumulator<ExtensionDetails> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.extensions != null) {
            accumulator.addAll(this.extensions);
            return;
        }
        try {
            this.extensions = ExtensionUtils.getExtensions();
        }
        catch (ExtensionException e) {
            Msg.error((Object)((Object)this), (Object)"Error loading extensions", (Throwable)((Object)e));
            return;
        }
        accumulator.addAll(this.extensions);
    }

    public boolean hasModelChanged() {
        return this.modelChanged;
    }

    public void setModelData(List<ExtensionDetails> model) {
        this.extensions = new HashSet<ExtensionDetails>(model);
        this.reload();
    }

    public void refreshTable() {
        this.extensions = null;
        this.reload();
    }

    private ExtensionDetails getSelectedExtension(int row) {
        return (ExtensionDetails)this.getRowObject(row);
    }

    private class ExtensionInstalledColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, Boolean, Object> {
        private ExtensionInstalledColumn() {
        }

        public String getColumnName() {
            return "Installation Status";
        }

        public int getColumnPreferredWidth() {
            return 30;
        }

        public Boolean getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.isInstalled();
        }
    }

    private class ExtensionNameColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtVersionRenderer renderer;

        private ExtensionNameColumn() {
            this.renderer = new ExtVersionRenderer();
        }

        public String getColumnName() {
            return "Name";
        }

        public int getColumnPreferredWidth() {
            return 50;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getName();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ExtensionDescriptionColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtVersionRenderer renderer;

        private ExtensionDescriptionColumn() {
            this.renderer = new ExtVersionRenderer();
        }

        public String getColumnName() {
            return "Description";
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getDescription();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ExtensionVersionColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtVersionRenderer renderer;

        private ExtensionVersionColumn() {
            this.renderer = new ExtVersionRenderer();
        }

        public String getColumnName() {
            return "Version";
        }

        public int getColumnPreferredWidth() {
            return 50;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            String version = rowObject.getVersion();
            if (version == null || version.equals("@extversion@")) {
                return "";
            }
            return version;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ExtensionInstallationDirColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtensionInstallationDirColumn() {
        }

        public String getColumnName() {
            return "Installation Directory";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getInstallPath();
        }
    }

    private class ExtensionArchiveFileColumn
    extends AbstractDynamicTableColumn<ExtensionDetails, String, Object> {
        private ExtensionArchiveFileColumn() {
        }

        public String getColumnName() {
            return "Archive File";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public String getValue(ExtensionDetails rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getArchivePath();
        }
    }

    private class ExtVersionRenderer
    extends AbstractGColumnRenderer<String> {
        private ExtVersionRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component comp = super.getTableCellRendererComponent(data);
            ExtensionDetails extension = ExtensionTableModel.this.getSelectedExtension(data.getRowViewIndex());
            if (!ExtensionTableModel.this.isValidVersion(extension)) {
                comp.setForeground(this.getErrorForegroundColor(data.isSelected()));
            }
            return comp;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }
}

