/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import generic.Span;
import generic.ULongSpan;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.Step;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.help.UnsupportedOperationException;

public class PatchStep
implements Step {
    protected final long threadKey;
    protected String sleigh;
    protected int hashCode;

    public static String generateSleighLine(Language language, Address address, byte[] data, int length) {
        BigInteger value = Utils.bytesToBigInteger((byte[])data, (int)length, (boolean)language.isBigEndian(), (boolean)false);
        if (address.isMemoryAddress()) {
            AddressSpace space = address.getAddressSpace();
            if (language.getDefaultSpace() == space) {
                return String.format("*:%d 0x%s:%d=0x%s", length, address.getOffsetAsBigInteger().toString(16), space.getPointerSize(), value.toString(16));
            }
            return String.format("*[%s]:%d 0x%s:%d=0x%s", space.getName(), length, address.getOffsetAsBigInteger().toString(16), space.getPointerSize(), value.toString(16));
        }
        Register register = language.getRegister(address, length);
        if (register == null) {
            throw new AssertionError((Object)"Can only modify memory or register");
        }
        return String.format("%s=0x%s", register, value.toString(16));
    }

    public static String generateSleighLine(Language language, Address address, byte[] data) {
        return PatchStep.generateSleighLine(language, address, data, data.length);
    }

    public static List<String> generateSleigh(Language language, Address address, byte[] data) {
        ArrayList<String> result = new ArrayList<String>();
        PatchStep.generateSleigh(result, language, address, data);
        return result;
    }

    protected static void generateSleigh(List<String> result, Language language, Address address, byte[] data) {
        SemisparseByteArray array = new SemisparseByteArray();
        array.putData(address.getOffset(), data);
        PatchStep.generateSleigh(result, language, address.getAddressSpace(), array);
    }

    protected static List<String> generateSleigh(Language language, Map<AddressSpace, SemisparseByteArray> patches) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<AddressSpace, SemisparseByteArray> entry : patches.entrySet()) {
            PatchStep.generateSleigh(result, language, entry.getKey(), entry.getValue());
        }
        return result;
    }

    protected static void generateSleigh(List<String> result, Language language, AddressSpace space, SemisparseByteArray array) {
        if (space.isRegisterSpace()) {
            PatchStep.generateRegisterSleigh(result, language, space, array);
        } else {
            PatchStep.generateMemorySleigh(result, language, space, array);
        }
    }

    protected static void generateMemorySleigh(List<String> result, Language language, AddressSpace space, SemisparseByteArray array) {
        byte[] data = new byte[8];
        for (ULongSpan span : array.getInitialized(0L, -1L).spans()) {
            Address start = space.getAddress(((Long)span.min()).longValue());
            Address end = space.getAddress(((Long)span.max()).longValue());
            for (AddressRange chunk : new AddressRangeChunker(start, end, data.length)) {
                Address min = chunk.getMinAddress();
                int length = (int)chunk.getLength();
                array.getData(min.getOffset(), data, 0, length);
                result.add(PatchStep.generateSleighLine(language, min, data, length));
            }
        }
    }

    protected static ULongSpan spanOfRegister(Register r) {
        return ULongSpan.extent((long)r.getAddress().getOffset(), (int)r.getNumBytes());
    }

    protected static boolean isContained(Register r, ULongSpan.ULongSpanSet remains) {
        return remains.encloses((Span)PatchStep.spanOfRegister(r));
    }

    protected static void generateRegisterSleigh(List<String> result, Language language, AddressSpace space, SemisparseByteArray array) {
        byte[] data = new byte[8];
        ULongSpan.DefaultULongSpanSet remains = new ULongSpan.DefaultULongSpanSet();
        remains.addAll((Span.SpanSet)array.getInitialized(0L, -1L));
        while (!remains.isEmpty()) {
            ULongSpan bound = (ULongSpan)remains.bound();
            Address min = space.getAddress(((Long)bound.min()).longValue());
            Register register = Stream.of(language.getRegisters(min)).filter(r -> r.getAddress().equals((Object)min)).filter(r -> r.getNumBytes() <= data.length).filter(arg_0 -> PatchStep.lambda$generateRegisterSleigh$2((ULongSpan.MutableULongSpanSet)remains, arg_0)).sorted(Comparator.comparing(r -> -r.getNumBytes())).findFirst().orElse(null);
            if (register == null) {
                throw new IllegalArgumentException("Could not find a register for " + min);
            }
            int length = register.getNumBytes();
            array.getData(min.getOffset(), data, 0, length);
            BigInteger value = Utils.bytesToBigInteger((byte[])data, (int)length, (boolean)language.isBigEndian(), (boolean)false);
            result.add(String.format("%s=0x%s", register, value.toString(16)));
            remains.remove((Span)PatchStep.spanOfRegister(register));
        }
    }

    public static PatchStep parse(long threadKey, String stepSpec) {
        if (!stepSpec.startsWith("{") || !stepSpec.endsWith("}")) {
            throw new IllegalArgumentException("Cannot parse step: '" + stepSpec + "'");
        }
        return new PatchStep(threadKey, stepSpec.substring(1, stepSpec.length() - 1));
    }

    public PatchStep(long threadKey, String sleigh) {
        this.threadKey = threadKey;
        this.sleigh = Objects.requireNonNull(sleigh);
        this.hashCode = Objects.hash(threadKey, sleigh);
    }

    private void setSleigh(String sleigh) {
        this.sleigh = sleigh;
        this.hashCode = Objects.hash(this.threadKey, sleigh);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatchStep)) {
            return false;
        }
        PatchStep that = (PatchStep)obj;
        if (this.threadKey != that.threadKey) {
            return false;
        }
        return this.sleigh.equals(that.sleigh);
    }

    public String toString() {
        if (this.threadKey == -1L) {
            return "{" + this.sleigh + "}";
        }
        return String.format("t%d-{%s}", this.threadKey, this.sleigh);
    }

    @Override
    public Step.StepType getType() {
        return Step.StepType.PATCH;
    }

    @Override
    public boolean isNop() {
        return this.sleigh.length() == 0;
    }

    @Override
    public long getThreadKey() {
        return this.threadKey;
    }

    @Override
    public long getTickCount() {
        return 0L;
    }

    @Override
    public long getPatchCount() {
        return 1L;
    }

    @Override
    public boolean isCompatible(Step step) {
        return false;
    }

    @Override
    public void addTo(Step step) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Step subtract(Step step) {
        if (this.equals(step)) {
            return Step.nop();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Step clone() {
        return new PatchStep(this.threadKey, this.sleigh);
    }

    @Override
    public long rewind(long count) {
        return count - 1L;
    }

    @Override
    public CompareResult compareStep(Step step) {
        CompareResult result = this.compareStepType(step);
        if (result != CompareResult.EQUALS) {
            return result;
        }
        PatchStep that = (PatchStep)step;
        result = CompareResult.unrelated(Long.compare(this.threadKey, that.threadKey));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        result = CompareResult.unrelated(this.sleigh.compareTo(that.sleigh));
        if (result != CompareResult.EQUALS) {
            return result;
        }
        return CompareResult.EQUALS;
    }

    @Override
    public <T> void execute(PcodeThread<T> emuThread, Stepper stepper, TaskMonitor monitor) throws CancelledException {
        PcodeProgram prog = emuThread.getMachine().compileSleigh("schedule", this.sleigh + ";");
        emuThread.getExecutor().execute(prog, emuThread.getUseropLibrary());
    }

    @Override
    public long coalescePatches(Language language, List<Step> steps) {
        long threadKey = -1L;
        int toRemove = 0;
        Map<AddressSpace, SemisparseByteArray> patches = new TreeMap<AddressSpace, SemisparseByteArray>();
        for (int i = steps.size() - 1; i >= 0; --i) {
            PatchStep ps;
            Map<AddressSpace, SemisparseByteArray> subs;
            Step step = steps.get(i);
            long stk = step.getThreadKey();
            if (threadKey == -1L) {
                threadKey = stk;
            } else if (stk != -1L && stk != threadKey) break;
            if (!(step instanceof PatchStep) || (subs = (ps = (PatchStep)step).getPatches(language)) == null) break;
            this.mergePatches(subs, patches);
            patches = subs;
            ++toRemove;
        }
        List<String> sleighPatches = PatchStep.generateSleigh(language, patches);
        assert (sleighPatches.size() <= toRemove);
        for (String sleighPatch : sleighPatches) {
            PatchStep ps = (PatchStep)steps.get(steps.size() - toRemove);
            ps.setSleigh(sleighPatch);
            --toRemove;
        }
        return toRemove;
    }

    protected void mergePatches(Map<AddressSpace, SemisparseByteArray> into, Map<AddressSpace, SemisparseByteArray> from) {
        for (Map.Entry<AddressSpace, SemisparseByteArray> entry : from.entrySet()) {
            if (!into.containsKey(entry.getKey())) {
                into.put(entry.getKey(), entry.getValue());
                continue;
            }
            into.get(entry.getKey()).putAll(entry.getValue());
        }
    }

    protected Map<AddressSpace, SemisparseByteArray> getPatches(Language language) {
        PcodeProgram prog = SleighProgramCompiler.compileProgram((SleighLanguage)((SleighLanguage)language), (String)"schedule", (String)(this.sleigh + ";"), (PcodeUseropLibrary)PcodeUseropLibrary.nil());
        TreeMap<AddressSpace, SemisparseByteArray> result = new TreeMap<AddressSpace, SemisparseByteArray>();
        block4: for (PcodeOp op : prog.getCode()) {
            switch (op.getOpcode()) {
                case 1: {
                    if (this.getPatchCopyOp(language, result, op)) continue block4;
                    return null;
                }
                case 3: {
                    if (this.getPatchStoreOp(language, result, op)) continue block4;
                    return null;
                }
            }
            return null;
        }
        return result;
    }

    protected boolean getPatchCopyOp(Language language, Map<AddressSpace, SemisparseByteArray> result, PcodeOp op) {
        Varnode output = op.getOutput();
        if (!output.isAddress() && !output.isRegister()) {
            return false;
        }
        Varnode input = op.getInput(0);
        if (!input.isConstant()) {
            return false;
        }
        Address address = output.getAddress();
        SemisparseByteArray array = result.computeIfAbsent(address.getAddressSpace(), as -> new SemisparseByteArray());
        array.putData(address.getOffset(), Utils.longToBytes((long)input.getOffset(), (int)input.getSize(), (boolean)language.isBigEndian()));
        return true;
    }

    protected boolean getPatchStoreOp(Language language, Map<AddressSpace, SemisparseByteArray> result, PcodeOp op) {
        Varnode vnSpace = op.getInput(0);
        if (!vnSpace.isConstant()) {
            return false;
        }
        AddressSpace space = language.getAddressFactory().getAddressSpace((int)vnSpace.getOffset());
        Varnode vnOffset = op.getInput(1);
        if (!vnOffset.isConstant()) {
            return false;
        }
        Varnode vnValue = op.getInput(2);
        if (!vnValue.isConstant()) {
            return false;
        }
        SemisparseByteArray array = result.computeIfAbsent(space, as -> new SemisparseByteArray());
        array.putData(vnOffset.getOffset(), Utils.longToBytes((long)vnValue.getOffset(), (int)vnValue.getSize(), (boolean)language.isBigEndian()));
        return true;
    }

    private static /* synthetic */ boolean lambda$generateRegisterSleigh$2(ULongSpan.MutableULongSpanSet remains, Register r) {
        return PatchStep.isContained(r, (ULongSpan.ULongSpanSet)remains);
    }
}

