/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target;

import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public interface TraceObject
extends TraceUniqueObject {
    public static final String EXTRA_INTERFACES_ATTRIBUTE_NAME = "_extra_ifs";

    public Trace getTrace();

    public TraceObject getRoot();

    public TraceObjectKeyPath getCanonicalPath();

    public Lifespan.LifeSet getLife();

    public TraceObjectValPath insert(Lifespan var1, ConflictResolution var2);

    public void remove(Lifespan var1);

    public void removeTree(Lifespan var1);

    public TraceObjectValue getCanonicalParent(long var1);

    public Stream<? extends TraceObjectValue> getCanonicalParents(Lifespan var1);

    public boolean isRoot();

    public Stream<? extends TraceObjectValPath> getAllPaths(Lifespan var1);

    public Collection<Class<? extends TraceObjectInterface>> getInterfaces();

    public <I extends TraceObjectInterface> I queryInterface(Class<I> var1);

    public Collection<? extends TraceObjectValue> getParents();

    public Collection<? extends TraceObjectValue> getValues();

    public Collection<? extends TraceObjectValue> getValues(Lifespan var1, String var2);

    public Stream<? extends TraceObjectValue> getOrderedValues(Lifespan var1, String var2, boolean var3);

    public Collection<? extends TraceObjectValue> getElements();

    public Collection<? extends TraceObjectValue> getAttributes();

    public TraceObjectValue getValue(long var1, String var3);

    public TraceObjectValue getElement(long var1, String var3);

    public TraceObjectValue getElement(long var1, long var3);

    public TraceObjectValue getAttribute(long var1, String var3);

    public Stream<? extends TraceObjectValPath> getAncestorsRoot(Lifespan var1, PathPredicates var2);

    public Stream<? extends TraceObjectValPath> getAncestors(Lifespan var1, PathPredicates var2);

    public Stream<? extends TraceObjectValPath> getSuccessors(Lifespan var1, PathPredicates var2);

    public Stream<? extends TraceObjectValPath> getOrderedSuccessors(Lifespan var1, TraceObjectKeyPath var2, boolean var3);

    public Stream<? extends TraceObjectValPath> getCanonicalSuccessors(PathPredicates var1);

    public TraceObjectValue setValue(Lifespan var1, String var2, Object var3, ConflictResolution var4);

    public TraceObjectValue setValue(Lifespan var1, String var2, Object var3);

    public TraceObjectValue setAttribute(Lifespan var1, String var2, Object var3);

    public TraceObjectValue setElement(Lifespan var1, String var2, Object var3);

    public TraceObjectValue setElement(Lifespan var1, long var2, Object var4);

    public TargetObjectSchema getTargetSchema();

    public Stream<? extends TraceObjectValPath> queryAncestorsTargetInterface(Lifespan var1, Class<? extends TargetObject> var2);

    public <I extends TraceObjectInterface> Stream<I> queryAncestorsInterface(Lifespan var1, Class<I> var2);

    public Stream<? extends TraceObject> queryCanonicalAncestorsTargetInterface(Class<? extends TargetObject> var1);

    public <I extends TraceObjectInterface> Stream<I> queryCanonicalAncestorsInterface(Class<I> var1);

    public Stream<? extends TraceObjectValPath> querySuccessorsTargetInterface(Lifespan var1, Class<? extends TargetObject> var2, boolean var3);

    public <I extends TraceObjectInterface> Stream<I> querySuccessorsInterface(Lifespan var1, Class<I> var2, boolean var3);

    public void delete();

    @Override
    public boolean isDeleted();

    default public boolean isMethod(long snap) {
        if (this.getTargetSchema().getInterfaces().contains(TargetMethod.class)) {
            return true;
        }
        TraceObjectValue extras = this.getAttribute(snap, EXTRA_INTERFACES_ATTRIBUTE_NAME);
        if (extras == null) {
            return false;
        }
        Object val = extras.getValue();
        if (!(val instanceof String)) {
            return false;
        }
        String valStr = (String)val;
        return valStr.contains("Method");
    }

    default public TraceObject querySuitableTargetInterface(Class<? extends TargetObject> targetIf) {
        List path = this.getRoot().getTargetSchema().searchForSuitable(targetIf, this.getCanonicalPath().getKeyList());
        if (path == null) {
            return null;
        }
        return this.getTrace().getObjectManager().getObjectByCanonicalPath(TraceObjectKeyPath.of(path));
    }

    default public TraceObject queryRegisterContainer(int frameLevel) {
        PathPredicates regsMatcher = this.getRoot().getTargetSchema().searchForRegisterContainer(frameLevel, this.getCanonicalPath().getKeyList());
        for (PathPattern regsPattern : regsMatcher.getPatterns()) {
            TraceObject regsObj = this.getTrace().getObjectManager().getObjectByCanonicalPath(TraceObjectKeyPath.of(regsPattern.getSingletonPath()));
            if (regsObj == null) continue;
            return regsObj;
        }
        return null;
    }

    default public TargetExecutionStateful.TargetExecutionState getExecutionState(long snap) {
        TraceObject stateful = this.querySuitableTargetInterface(TargetExecutionStateful.class);
        if (stateful == null) {
            return null;
        }
        TraceObjectValue stateVal = stateful.getAttribute(snap, "_state");
        if (stateVal == null) {
            return TargetExecutionStateful.TargetExecutionState.INACTIVE;
        }
        return TargetExecutionStateful.TargetExecutionState.valueOf((String)((String)stateVal.getValue()));
    }

    public static enum ConflictResolution {
        TRUNCATE,
        DENY;

    }
}

