/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.IterableUtils;

interface InternalTraceObjectValue
extends TraceObjectValue {
    public DBTraceObjectManager getManager();

    public long getKey();

    @Override
    public DBTraceObject getChild();

    public DBTraceObject getChildOrNull();

    public void doSetLifespan(Lifespan var1);

    default public void doSetLifespanAndEmit(Lifespan lifespan) {
        Lifespan oldLifespan = this.getLifespan();
        this.doSetLifespan(lifespan);
        this.getParent().emitEvents(new TraceChangeRecord<InternalTraceObjectValue, Lifespan>(Trace.TraceObjectChangeType.VALUE_LIFESPAN_CHANGED, null, this, oldLifespan, lifespan));
    }

    @Override
    default public void setLifespan(Lifespan lifespan) {
        this.setLifespan(lifespan, TraceObject.ConflictResolution.TRUNCATE);
    }

    @Override
    default public void setLifespan(Lifespan lifespan, TraceObject.ConflictResolution resolution) {
        try (LockHold hold = this.getTrace().lockWrite();){
            if (this.getParent() == null) {
                throw new IllegalArgumentException("Cannot set lifespan of root value");
            }
            if (resolution == TraceObject.ConflictResolution.DENY) {
                this.getParent().doCheckConflicts(lifespan, this.getEntryKey(), this.getValue());
            }
            new ValueLifespanSetter(lifespan, this.getValue(), this){

                protected Iterable<InternalTraceObjectValue> getIntersecting(Long lower, Long upper) {
                    Collection<? extends InternalTraceObjectValue> col = Collections.unmodifiableCollection(InternalTraceObjectValue.this.getParent().doGetValues(lower, upper, InternalTraceObjectValue.this.getEntryKey()));
                    return IterableUtils.filteredIterable(col, v -> v != this.keep);
                }

                @Override
                protected InternalTraceObjectValue create(Lifespan range, Object value) {
                    return InternalTraceObjectValue.this.getParent().doCreateValue(range, InternalTraceObjectValue.this.getEntryKey(), value);
                }
            }.set(lifespan, this.getValue());
            if (this.isObject()) {
                DBTraceObject child = this.getChild();
                child.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(Trace.TraceObjectChangeType.LIFE_CHANGED, null, child));
            }
        }
    }

    public void doDelete();

    default public void doDeleteAndEmit() {
        DBTraceObject parent = this.getParent();
        this.doDelete();
        parent.emitEvents(new TraceChangeRecord<InternalTraceObjectValue, Void>(Trace.TraceObjectChangeType.VALUE_DELETED, null, this));
    }

    @Override
    public DBTraceObject getParent();

    default public InternalTraceObjectValue doTruncateOrDeleteAndEmitLifeChange(Lifespan span) {
        if (!this.isCanonical()) {
            return this.doTruncateOrDelete(span);
        }
        DBTraceObject child = this.getChildOrNull();
        InternalTraceObjectValue result = this.doTruncateOrDelete(span);
        child.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(Trace.TraceObjectChangeType.LIFE_CHANGED, null, child));
        return result;
    }

    default public InternalTraceObjectValue doTruncateOrDelete(Lifespan span) {
        List removed = this.getLifespan().subtract(span);
        if (removed.isEmpty()) {
            this.doDeleteAndEmit();
            return null;
        }
        this.doSetLifespanAndEmit((Lifespan)removed.get(0));
        if (removed.size() == 2) {
            return this.getParent().doCreateValue((Lifespan)removed.get(1), this.getEntryKey(), this.getValue());
        }
        return this;
    }

    public static abstract class ValueLifespanSetter
    extends DBTraceUtils.LifespanMapSetter<InternalTraceObjectValue, Object> {
        protected final Lifespan range;
        protected final Object value;
        protected InternalTraceObjectValue keep = null;
        protected Collection<InternalTraceObjectValue> kept = new ArrayList<InternalTraceObjectValue>(2);

        public ValueLifespanSetter(Lifespan range, Object value) {
            this.range = range;
            this.value = value;
        }

        public ValueLifespanSetter(Lifespan range, Object value, InternalTraceObjectValue keep) {
            this(range, value);
            this.keep = keep;
        }

        protected Lifespan getRange(InternalTraceObjectValue entry) {
            return entry.getLifespan();
        }

        protected Object getValue(InternalTraceObjectValue entry) {
            return entry.getValue();
        }

        protected void remove(InternalTraceObjectValue entry) {
            if (Objects.equals(entry.getValue(), this.value)) {
                if (this.keep == null) {
                    this.keep = entry;
                } else {
                    entry.doDeleteAndEmit();
                }
            } else {
                InternalTraceObjectValue created = entry.doTruncateOrDelete(this.range);
                if (!entry.isDeleted()) {
                    this.kept.add(entry);
                }
                if (created != null) {
                    this.kept.add(created);
                }
            }
        }

        protected InternalTraceObjectValue put(Lifespan range, Object value) {
            if (value == null) {
                return null;
            }
            if (this.keep != null && Objects.equals(this.value, value)) {
                this.keep.doSetLifespanAndEmit(range);
                return this.keep;
            }
            for (InternalTraceObjectValue k : this.kept) {
                if (!Objects.equals(value, k.getValue()) || !Objects.equals(range, k.getLifespan())) continue;
                this.kept.remove(k);
                return k;
            }
            return this.create(range, value);
        }

        protected abstract InternalTraceObjectValue create(Lifespan var1, Object var2);
    }
}

