/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import db.DBRecord;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.stack.DBTraceStack;
import ghidra.trace.database.stack.DBTraceStackManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=1)
public class DBTraceStackFrame
extends DBAnnotatedObject
implements TraceStackFrame,
DBTraceOverlaySpaceAdapter.DecodesAddresses {
    public static final String TABLE_NAME = "StackFrames";
    static final String STACK_COLUMN_NAME = "Stack";
    static final String LEVEL_COLUMN_NAME = "Level";
    static final String PC_COLUMN_NAME = "PC";
    static final String COMMENT_COLUMN_NAME = "Comment";
    @DBAnnotatedColumn(value="Stack")
    static DBObjectColumn STACK_COLUMN;
    @DBAnnotatedColumn(value="Level")
    static DBObjectColumn LEVEL_COLUMN;
    @DBAnnotatedColumn(value="PC")
    static DBObjectColumn PC_COLUMN;
    @DBAnnotatedColumn(value="Comment")
    static DBObjectColumn COMMENT_COLUMN;
    @DBAnnotatedField(column="Stack")
    private long stackKey;
    @DBAnnotatedField(column="Level")
    private int level;
    @DBAnnotatedField(column="PC", indexed=true, codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class, sparse=true)
    private Address pc;
    @DBAnnotatedField(column="Comment")
    private String comment;
    private final DBTraceStackManager manager;
    private DBTraceStack stack;

    public DBTraceStackFrame(DBTraceStackManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    @Override
    public DBTraceOverlaySpaceAdapter getOverlaySpaceAdapter() {
        return this.manager.overlayAdapter;
    }

    protected void fresh(boolean created) throws IOException {
        if (!created) {
            this.stack = this.manager.getStackByKey(this.stackKey);
        }
    }

    public void set(DBTraceStack stack) {
        this.stack = stack;
        this.stackKey = stack.getKey();
        this.update(STACK_COLUMN);
    }

    @Override
    public DBTraceStack getStack() {
        return this.stack;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public Address getProgramCounter(long snap) {
        return this.pc;
    }

    @Override
    public void setProgramCounter(Lifespan span, Address pc) {
        this.manager.trace.assertValidAddress(pc);
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (Objects.equals(this.pc, pc)) {
                return;
            }
            this.pc = pc;
            this.update(PC_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord<DBTraceStack, Long>(Trace.TraceStackChangeType.CHANGED, null, this.stack, 0L, this.stack.getSnap()));
    }

    @Override
    public String getComment(long snap) {
        return this.comment;
    }

    @Override
    public void setComment(long snap, String comment) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.comment = comment;
            this.update(COMMENT_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord<DBTraceStack, Long>(Trace.TraceStackChangeType.CHANGED, null, this.stack, 0L, this.stack.getSnap()));
    }

    @Internal
    protected void setLevel(int level) {
        this.level = level;
        this.update(LEVEL_COLUMN);
    }
}

