/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class InjectPayloadSegment
extends InjectPayloadSleigh {
    private AddressSpace space;
    private boolean supportsFarPointer;
    private AddressSpace constResolveSpace;
    private long constResolveOffset;
    private int constResolveSize;

    public InjectPayloadSegment(String source) {
        super(source);
        this.type = 4;
        this.space = null;
        this.supportsFarPointer = false;
        this.constResolveSpace = null;
        this.constResolveOffset = 0L;
        this.constResolveSize = 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        String subName;
        encoder.openElement(ElementId.ELEM_SEGMENTOP);
        int pos = this.name.indexOf(95);
        String string = subName = pos > 0 ? this.name.substring(0, pos) : this.name;
        if (!subName.equals("segment")) {
            encoder.writeString(AttributeId.ATTRIB_USEROP, subName);
        }
        encoder.writeSpace(AttributeId.ATTRIB_SPACE, this.space);
        if (this.supportsFarPointer) {
            encoder.writeBool(AttributeId.ATTRIB_FARPOINTER, this.supportsFarPointer);
        }
        super.encode(encoder);
        if (this.constResolveSpace != null) {
            encoder.openElement(ElementId.ELEM_CONSTRESOLVE);
            encoder.openElement(ElementId.ELEM_VARNODE);
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, this.constResolveSpace);
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_OFFSET, this.constResolveOffset);
            encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, this.constResolveSize);
            encoder.closeElement(ElementId.ELEM_VARNODE);
            encoder.closeElement(ElementId.ELEM_CONSTRESOLVE);
        }
        encoder.closeElement(ElementId.ELEM_SEGMENTOP);
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage language) throws XmlParseException {
        XmlElement el = parser.start(new String[0]);
        this.name = el.getAttribute("userop");
        if (this.name == null) {
            this.name = "segment";
        }
        this.name = this.name + "_pcode";
        String spaceString = el.getAttribute("space");
        this.space = language.getAddressFactory().getAddressSpace(spaceString);
        if (this.space == null) {
            throw new XmlParseException("Unknown address space: " + spaceString);
        }
        this.supportsFarPointer = SpecXmlUtils.decodeBoolean((String)el.getAttribute("farpointer"));
        if (parser.peek().isStart()) {
            if (parser.peek().getName().equals("pcode")) {
                super.restoreXml(parser, language);
            } else {
                throw new XmlParseException("Missing <pcode> child for <segmentop> tag");
            }
        }
        if (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[]{"constresolve"});
            XmlElement subsubel = parser.start(new String[0]);
            AddressXML addrSize = AddressXML.restoreXml(subsubel, language);
            addrSize.getFirstAddress();
            this.constResolveSpace = addrSize.getAddressSpace();
            this.constResolveOffset = addrSize.getOffset();
            this.constResolveSize = (int)addrSize.getSize();
            parser.end(subsubel);
            parser.end(subel);
        }
        parser.end(el);
    }

    @Override
    public boolean isEquivalent(InjectPayload obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InjectPayloadSegment op2 = (InjectPayloadSegment)obj;
        if (this.constResolveOffset != op2.constResolveOffset) {
            return false;
        }
        if (this.constResolveSize != op2.constResolveSize) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.constResolveSpace, (Object)op2.constResolveSpace)) {
            return false;
        }
        if (!this.space.equals(op2.space)) {
            return false;
        }
        if (this.supportsFarPointer != op2.supportsFarPointer) {
            return false;
        }
        return super.isEquivalent(obj);
    }
}

