/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.util.Conv;
import ghidra.util.Msg;

public abstract class CountedDynamicDataType
extends DynamicDataType {
    private String description;
    private DataType header;
    private DataType baseStruct;
    private long counterOffset;
    private int counterSize;
    private long mask;

    public CountedDynamicDataType(String name, String description, DataType header, DataType baseStruct, long counterOffset, int counterSize, long mask) {
        super(name, baseStruct.getDataTypeManager());
        this.description = description;
        this.header = header;
        this.baseStruct = baseStruct;
        this.counterOffset = counterOffset;
        this.counterSize = counterSize;
        this.mask = mask == 0L ? -1L : mask;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        return this;
    }

    @Override
    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        Memory memory = buf.getMemory();
        Address start = buf.getAddress();
        int n = (int)this.getCount(memory, start.add(this.counterOffset));
        DataTypeComponent[] comps = new DataTypeComponent[n + 1];
        DataTypeInstance dti = DataTypeInstance.getDataTypeInstance(this.header, buf, false);
        if (dti == null) {
            Msg.error((Object)this, (Object)("ERROR: problem with data at " + buf.getAddress()));
            return null;
        }
        int countSize = dti.getLength();
        comps[0] = new ReadOnlyDataTypeComponent(dti.getDataType(), this, countSize, 0, 0, this.header.getName() + "_" + buf.getAddress(), "");
        int offset = countSize;
        MemoryBufferImpl newBuf = new MemoryBufferImpl(memory, buf.getAddress());
        try {
            newBuf.advance(countSize);
            for (int i = 1; i <= n; ++i) {
                dti = DataTypeInstance.getDataTypeInstance(this.baseStruct, buf, false);
                if (dti == null) {
                    Msg.error((Object)this, (Object)("ERROR: problem with data at " + buf.getAddress()));
                    return null;
                }
                int len = dti.getLength();
                comps[i] = new ReadOnlyDataTypeComponent(dti.getDataType(), this, len, i, offset, this.baseStruct.getName() + "_" + newBuf.getAddress(), "");
                offset += len;
                newBuf.advance(len);
            }
        }
        catch (AddressOverflowException e) {
            Msg.error((Object)this, (Object)("ERROR: problem with data at " + buf.getAddress()));
            return null;
        }
        return comps;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    private long getCount(Memory memory, Address loc) {
        long test = 0L;
        try {
            switch (this.counterSize) {
                case 1: {
                    test = Conv.byteToLong((byte)memory.getByte(loc));
                    break;
                }
                case 2: {
                    test = Conv.shortToLong((short)memory.getShort(loc));
                    break;
                }
                case 4: {
                    test = Conv.intToLong((int)memory.getInt(loc));
                    break;
                }
                case 8: {
                    test = memory.getLong(loc);
                    break;
                }
                default: {
                    return 0L;
                }
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)((Object)e));
        }
        return test & this.mask;
    }
}

