/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import db.Field;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.database.data.FunctionDefinitionDBAdapter;
import ghidra.program.database.data.FunctionParameterAdapter;
import ghidra.program.database.data.ParameterDefinitionDB;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

class FunctionDefinitionDB
extends DataTypeDB
implements FunctionDefinition {
    private FunctionDefinitionDBAdapter funDefAdapter;
    private FunctionParameterAdapter paramAdapter;
    private ArrayList<ParameterDefinitionDB> parameters;

    FunctionDefinitionDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, FunctionDefinitionDBAdapter adapter, FunctionParameterAdapter paramAdapter, DBRecord record) {
        super(dataMgr, cache, record);
        this.funDefAdapter = adapter;
        this.paramAdapter = paramAdapter;
        this.loadParameters();
    }

    @Override
    protected String doGetName() {
        return this.record.getString(0);
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(2);
    }

    @Override
    protected Settings doGetDefaultSettings() {
        return SettingsImpl.NO_SETTINGS;
    }

    private void loadParameters() {
        this.parameters = new ArrayList();
        try {
            Field[] ids;
            for (Field id : ids = this.paramAdapter.getParameterIdsInFunctionDef(this.key)) {
                DBRecord rec = this.paramAdapter.getRecord(id.getLongValue());
                this.parameters.add(new ParameterDefinitionDB(this.dataMgr, this.paramAdapter, this, rec));
            }
            Collections.sort(this.parameters);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    @Override
    protected boolean refresh() {
        try {
            DBRecord rec = this.funDefAdapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                this.loadParameters();
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return false;
    }

    @Override
    public String getPrototypeString() {
        return this.getPrototypeString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrototypeString(boolean includeCallingConvention) {
        this.lock.acquire();
        try {
            String callingConvention;
            DataType returnType;
            this.checkIsValid();
            StringBuffer buf = new StringBuffer();
            if (includeCallingConvention && this.hasNoReturn()) {
                buf.append("noreturn");
                buf.append(" ");
            }
            buf.append((returnType = this.getReturnType()) != null ? returnType.getDisplayName() : "void");
            buf.append(" ");
            if (includeCallingConvention && !"unknown".equals(callingConvention = this.getCallingConventionName())) {
                buf.append(callingConvention);
                buf.append(" ");
            }
            buf.append(this.getName());
            buf.append("(");
            boolean hasVarArgs = this.hasVarArgs();
            int n = this.parameters.size();
            for (int i = 0; i < n; ++i) {
                ParameterDefinition param = this.parameters.get(i);
                buf.append(param.getDataType().getDisplayName());
                buf.append(" ");
                buf.append(param.getName());
                if (i >= n - 1 && !hasVarArgs) continue;
                buf.append(", ");
            }
            if (hasVarArgs) {
                buf.append("...");
            } else if (this.parameters.size() == 0) {
                buf.append("void");
            }
            buf.append(")");
            String string = buf.toString();
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public ParameterDefinition[] getArguments() {
        this.lock.acquire();
        try {
            ParameterDefinition[] vars = new ParameterDefinition[this.parameters.size()];
            ParameterDefinition[] parameterDefinitionArray = this.parameters.toArray(vars);
            return parameterDefinitionArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType getReturnType() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long dtId = this.record.getLongValue(3);
            DataType dt = this.dataMgr.getDataType(dtId);
            if (dt == null) {
                dt = DataType.DEFAULT;
            }
            DataType dataType = dt;
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof FunctionDefinition)) {
            throw new IllegalArgumentException();
        }
        this.doReplaceWith((FunctionDefinition)dataType);
    }

    private void doReplaceWith(FunctionDefinition functionDefinition) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.setArguments(functionDefinition.getArguments());
            try {
                this.setReturnType(functionDefinition.getReturnType());
            }
            catch (IllegalArgumentException e) {
                this.setReturnType(DEFAULT);
            }
            this.setVarArgs(functionDefinition.hasVarArgs());
            this.setNoReturn(functionDefinition.hasNoReturn());
            try {
                this.setCallingConvention(functionDefinition.getCallingConventionName(), false);
            }
            catch (InvalidInputException e) {
                // empty catch block
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getComment() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            String string = this.record.getString(1);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return new FunctionDefinitionDataType(this.getCategoryPath(), this.getName(), this, dtm);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new FunctionDefinitionDataType(this.getCategoryPath(), this.getName(), this, this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getPrototypeString();
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getAlignedLength() {
        return -1;
    }

    @Override
    public String getDescription() {
        return "Function Signature Data Type";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getPrototypeString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArguments(ParameterDefinition[] args) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            for (ParameterDefinitionDB param : this.parameters) {
                param.getDataType().removeParent(this);
                this.paramAdapter.removeRecord(param.getKey());
            }
            this.parameters.clear();
            for (int i = 0; i < args.length; ++i) {
                DataType type = ParameterDefinitionImpl.validateDataType(args[i].getDataType(), this.dataMgr, false);
                DataType resolvedDt = this.resolve(type);
                this.paramAdapter.createRecord(this.dataMgr.getID(resolvedDt), this.key, i, args[i].getName(), args[i].getComment(), args[i].getLength());
                resolvedDt.addParent(this);
            }
            this.loadParameters();
            this.funDefAdapter.updateRecord(this.record, true);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setReturnType(DataType type) {
        type = ParameterDefinitionImpl.validateDataType(type, this.dataMgr, true);
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.getReturnType().removeParent(this);
            if (type == null) {
                type = DataType.DEFAULT;
            }
            DataType resolvedDt = this.resolve(type);
            this.record.setLongValue(3, this.dataMgr.getID(resolvedDt));
            this.funDefAdapter.updateRecord(this.record, true);
            resolvedDt.addParent(this);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setComment(String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setString(1, comment);
            this.funDefAdapter.updateRecord(this.record, true);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeDeleted(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int n = this.parameters.size();
            for (int i = 0; i < n; ++i) {
                ParameterDefinitionDB param = this.parameters.get(i);
                if (param.getDataType() != dt) continue;
                param.setDataType(DataType.DEFAULT);
            }
            if (dt == this.getReturnType()) {
                this.setReturnType(DataType.DEFAULT);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isEquivalent(DataType dataType) {
        if (dataType == this) {
            return true;
        }
        if (!(dataType instanceof FunctionDefinition)) {
            return false;
        }
        this.validate(this.lock);
        if (this.resolving) {
            if (dataType.getUniversalID().equals((Object)this.getUniversalID())) {
                return true;
            }
            return DataTypeUtilities.equalsIgnoreConflict(this.getPathName(), dataType.getPathName());
        }
        Boolean isEquivalent = this.dataMgr.getCachedEquivalence(this, dataType);
        if (isEquivalent != null) {
            return isEquivalent;
        }
        try {
            isEquivalent = this.isEquivalentSignature((FunctionSignature)((Object)dataType));
        }
        finally {
            this.dataMgr.putCachedEquivalence(this, dataType, isEquivalent);
        }
        return isEquivalent;
    }

    @Override
    public boolean isEquivalentSignature(FunctionSignature signature) {
        ParameterDefinition[] thisArgs;
        ParameterDefinition[] args;
        if (signature == this) {
            return true;
        }
        String comment = signature.getComment();
        String myComment = this.getComment();
        if (DataTypeUtilities.equalsIgnoreConflict(signature.getName(), this.getName()) && (comment == null && myComment == null || comment != null && comment.equals(myComment)) && DataTypeUtilities.isSameOrEquivalentDataType(this.getReturnType(), signature.getReturnType()) && this.getCallingConventionName().equals(signature.getCallingConventionName()) && this.hasVarArgs() == signature.hasVarArgs() && this.hasNoReturn() == signature.hasNoReturn() && (args = signature.getArguments()).length == (thisArgs = this.getArguments()).length) {
            for (int i = 0; i < args.length; ++i) {
                if (thisArgs[i].isEquivalent(args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(2, categoryID);
        this.funDefAdapter.updateRecord(this.record, false);
    }

    @Override
    protected void doSetNameRecord(String name) throws IOException {
        this.record.setString(0, name);
        this.funDefAdapter.updateRecord(this.record, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        this.lock.acquire();
        try {
            DataType retType;
            this.checkDeleted();
            if (newDt == this) {
                newDt = DataType.DEFAULT;
            }
            if (oldDt == (retType = this.getReturnType())) {
                try {
                    this.setReturnType(newDt);
                }
                catch (IllegalArgumentException e) {
                    this.dataTypeDeleted(oldDt);
                    this.lock.release();
                    return;
                }
            }
            int n = this.parameters.size();
            for (int i = 0; i < n; ++i) {
                ParameterDefinitionDB param = this.parameters.get(i);
                if (param.getDataType() != oldDt) continue;
                try {
                    param.setDataType(newDt);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.dataTypeDeleted(oldDt);
                    this.lock.release();
                    return;
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceArgument(int ordinal, String name, DataType dt, String comment, SourceType source) {
        if (dt.getLength() <= 0) {
            throw new IllegalArgumentException("Fixed length data type expected");
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal >= this.parameters.size()) {
                for (int i = this.parameters.size(); i < ordinal; ++i) {
                    this.paramAdapter.createRecord(this.dataMgr.getResolvedID(DataType.DEFAULT), this.key, i, "param_" + (i + 1), null, 1);
                }
            } else {
                ParameterDefinitionDB param = this.parameters.get(ordinal);
                param.getDataType().removeParent(this);
                this.paramAdapter.removeRecord(param.getKey());
            }
            DataType rdt = this.resolve(dt);
            rdt.addParent(this);
            this.paramAdapter.createRecord(this.dataMgr.getID(rdt), this.key, ordinal, name, comment, dt.getLength());
            this.loadParameters();
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean hasVarArgs() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                boolean bl = false;
                return bl;
            }
            byte flags = this.record.getByteValue(4);
            boolean bl = (flags & 1) != 0;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasNoReturn() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                boolean bl = false;
                return bl;
            }
            byte flags = this.record.getByteValue(4);
            boolean bl = (flags & 2) != 0;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVarArgs(boolean hasVarArgs) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            byte flags = this.record.getByteValue(4);
            flags = hasVarArgs ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
            this.record.setByteValue(4, flags);
            try {
                this.funDefAdapter.updateRecord(this.record, true);
                this.dataMgr.dataTypeChanged(this, false);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoReturn(boolean hasNoReturn) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            byte flags = this.record.getByteValue(4);
            flags = hasNoReturn ? (byte)(flags | 2) : (byte)(flags & 0xFFFFFFFD);
            this.record.setByteValue(4, flags);
            try {
                this.funDefAdapter.updateRecord(this.record, true);
                this.dataMgr.dataTypeChanged(this, false);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setGenericCallingConvention(GenericCallingConvention genericCallingConvention) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.setCallingConvention(genericCallingConvention.name(), false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void setCallingConvention(String conventionName) throws InvalidInputException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.setCallingConvention(conventionName, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void setCallingConvention(String conventionName, boolean restrictive) throws InvalidInputException, IOException {
        byte id = this.dataMgr.getCallingConventionID(conventionName, restrictive);
        this.record.setByteValue(5, id);
        this.funDefAdapter.updateRecord(this.record, true);
        this.dataMgr.dataTypeChanged(this, false);
    }

    @Override
    public PrototypeModel getCallingConvention() {
        ProgramArchitecture arch = this.dataMgr.getProgramArchitecture();
        if (arch == null) {
            return null;
        }
        String callingConvention = this.getCallingConventionName();
        CompilerSpec compilerSpec = arch.getCompilerSpec();
        return compilerSpec.getCallingConvention(callingConvention);
    }

    @Override
    public String getCallingConventionName() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.record == null) {
                String string = "unknown";
                return string;
            }
            byte id = this.record.getByteValue(5);
            if (this.funDefAdapter.usesGenericCallingConventionId()) {
                String string = FunctionDefinitionDBAdapter.getGenericCallingConventionName(id);
                return string;
            }
            String string = this.dataMgr.getCallingConventionName(id);
            return string;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public long getLastChangeTime() {
        return this.record.getLongValue(9);
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return this.record.getLongValue(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTime(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(9, lastChangeTime);
            this.funDefAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(8, lastChangeTime);
            this.funDefAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public UniversalID getUniversalID() {
        return new UniversalID(this.record.getLongValue(7));
    }

    @Override
    protected void setUniversalID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(7, id.getValue());
            this.funDefAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return new UniversalID(this.record.getLongValue(6));
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.record.setLongValue(6, id.getValue());
            this.funDefAdapter.updateRecord(this.record, false);
            this.dataMgr.dataTypeChanged(this, false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String toString() {
        return this.getPrototypeString(true);
    }
}

