/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.util.NumericUtilities;
import ghidra.util.UniversalID;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import utility.application.ApplicationLayout;

public class DataTypeIDConverter
implements GhidraLaunchable {
    private LongLongHashtable idMap;
    private int convertedCount = 0;
    private int builtInsCount = 0;
    private int nullIDsCount = 0;
    private int nonDataTypeDBCount = 0;
    private int notInMapCount = 0;

    public void launch(GhidraApplicationLayout layout, String[] args) {
        if (args.length != 3) {
            System.out.println("DataTypeIDConverter <Input DataTypeArchive filepath> <ID map filepath> <Output DataTypeArchive filepath>");
            System.exit(1);
        }
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)new ApplicationConfiguration());
        System.out.println(" ");
        String inputArchivePath = args[0];
        String idMapFilePath = args[1];
        String outputArchivePath = args[2];
        File inFile = new File(inputArchivePath);
        File idMapFile = new File(idMapFilePath);
        File outFile = new File(outputArchivePath);
        if (outFile.exists()) {
            System.out.println("Output DataTypeArchive file \"" + outFile.getAbsolutePath() + "\" cannot already exist.");
            System.exit(1);
        }
        DataTypeIDConverter dataTypeIDConverter = new DataTypeIDConverter();
        dataTypeIDConverter.swap(inFile, idMapFile, outFile);
        System.out.println("DataTypeIDConverter:");
        System.out.println("  converted = " + dataTypeIDConverter.convertedCount);
        System.out.println("  nonDataTypeDB = " + dataTypeIDConverter.nonDataTypeDBCount);
        System.out.println("  builtIn = " + dataTypeIDConverter.builtInsCount);
        System.out.println("  nullIDs = " + dataTypeIDConverter.nullIDsCount);
        System.out.println("  notInMap = " + dataTypeIDConverter.notInMapCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swap(File inFile, File idMapFile, File outFile) {
        try {
            this.loadMap(idMapFile);
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try (FileDataTypeManager oldFileArchive = null;){
            oldFileArchive = FileDataTypeManager.openFileArchive(inFile, false);
            if (oldFileArchive.getWarning() != StandAloneDataTypeManager.ArchiveWarning.NONE) {
                System.out.println("Archive ID Conversion aborted");
                return;
            }
            UniversalID oldFileUID = oldFileArchive.getUniversalID();
            long newID = this.idMap.get(oldFileUID.getValue());
            UniversalID newFileID = new UniversalID(newID);
            this.transformDataTypes(oldFileArchive);
            oldFileArchive.saveAs(outFile, newFileID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMap(File idMapFile) throws InvalidInputException, IOException {
        this.idMap = new LongLongHashtable();
        FileReader reader = new FileReader(idMapFile);
        try (BufferedReader bufferedReader = null;){
            String line;
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] tokens = line.split(" ");
                if (tokens.length != 2) {
                    throw new InvalidInputException("Invalid line: " + line);
                }
                String oldIDString = tokens[0];
                String newIDString = tokens[1];
                long oldID = NumericUtilities.parseHexLong((String)oldIDString);
                long newID = NumericUtilities.parseHexLong((String)newIDString);
                if (this.idMap.contains(oldID)) {
                    System.out.println("Duplicate oldID ID encountered: " + oldIDString);
                }
                this.idMap.put(oldID, newID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformDataTypes(FileDataTypeManager oldFileArchive) {
        boolean commit = false;
        int transactionID = oldFileArchive.startTransaction("Transforming Data Type Archive");
        try {
            Iterator<DataType> allDataTypes = oldFileArchive.getAllDataTypes();
            while (allDataTypes.hasNext()) {
                DataType nextDt = allDataTypes.next();
                if (!(nextDt instanceof DataTypeDB)) {
                    if (nextDt instanceof BuiltInDataType) {
                        ++this.builtInsCount;
                        continue;
                    }
                    System.out.println("Skipping " + nextDt.getPathName() + "   class=" + nextDt.getClass());
                    ++this.nonDataTypeDBCount;
                    continue;
                }
                DataTypeDB dataType = (DataTypeDB)nextDt;
                UniversalID oldID = dataType.getUniversalID();
                if (oldID == null) {
                    ++this.nullIDsCount;
                    continue;
                }
                try {
                    System.out.println("Old id = " + Long.toHexString(oldID.getValue()));
                    long id = this.idMap.get(oldID.getValue());
                    UniversalID newID = new UniversalID(id);
                    dataType.setUniversalID(newID);
                    dataType.setLastChangeTime(System.currentTimeMillis());
                    ++this.convertedCount;
                }
                catch (NoValueException e) {
                    ++this.notInMapCount;
                }
            }
            commit = true;
        }
        finally {
            oldFileArchive.endTransaction(transactionID, commit);
        }
    }
}

