/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class ValueMapSymbol
extends ValueSymbol {
    private VectorSTL<Long> valuetable = new VectorSTL();
    private boolean tableisfilled;

    public ValueMapSymbol(Location location) {
        super(location);
    }

    public ValueMapSymbol(Location location, String nm, PatternValue pv, VectorSTL<Long> vt) {
        super(location, nm, pv);
        this.valuetable = new VectorSTL(vt);
        this.checkTableFill();
    }

    @Override
    public symbol_type getType() {
        return symbol_type.valuemap_symbol;
    }

    private void checkTableFill() {
        long min = this.patval.minValue();
        long max = this.patval.maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.valuetable.size();
        for (int i = 0; i < this.valuetable.size(); ++i) {
            if ((Long)this.valuetable.get(i) != 195935983L) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<valuemap_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.append(">\n");
        this.patval.saveXml(s);
        for (int i = 0; i < this.valuetable.size(); ++i) {
            s.append("<valuetab val=\"").append(Long.toString((Long)this.valuetable.get(i))).append("\"/>\n");
        }
        s.append("</valuemap_sym>\n");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<valuemap_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.append("/>\n");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        List list = el.getChildren();
        Iterator iter = list.iterator();
        Element element = (Element)iter.next();
        this.patval = (PatternValue)PatternExpression.restoreExpression(element, trans);
        this.patval.layClaim();
        while (iter.hasNext()) {
            Element child = (Element)iter.next();
            long value = XmlUtils.decodeUnknownLong(child.getAttributeValue("val"));
            this.valuetable.push_back((Object)value);
        }
        this.checkTableFill();
    }
}

