/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.ContextField;
import ghidra.pcodeCPort.slghsymbol.ValueSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class ContextSymbol
extends ValueSymbol {
    private VarnodeSymbol vn;
    private int low;
    private int high;
    private boolean flow;

    public ContextSymbol(Location location) {
        super(location);
    }

    public VarnodeSymbol getVarnode() {
        return this.vn;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public boolean isFlow() {
        return this.flow;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.context_symbol;
    }

    public ContextSymbol(Location location, String nm, ContextField pate, VarnodeSymbol v, int l, int h, boolean flow) {
        super(location, nm, pate);
        this.vn = v;
        this.low = l;
        this.high = h;
        this.flow = flow;
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<context_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.append(" varnode=\"0x");
        s.append(Long.toHexString(this.vn.getId()));
        s.append("\"");
        s.append(" low=\"");
        s.print(this.low);
        s.append("\"");
        s.append(" high=\"");
        s.print(this.high);
        s.append("\" flow=\"");
        s.print(this.flow);
        s.println("\">");
        this.patval.saveXml(s);
        s.println("</context_sym>");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<context_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        super.restoreXml(el, trans);
        int id = XmlUtils.decodeUnknownInt(el.getAttributeValue("varnode"));
        this.vn = (VarnodeSymbol)trans.findSymbol(id);
        this.low = XmlUtils.decodeUnknownInt(el.getAttributeValue("low"));
        this.high = XmlUtils.decodeUnknownInt(el.getAttributeValue("high"));
    }
}

