/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.pattern;

import ghidra.app.plugin.processors.sleigh.pattern.CombinePattern;
import ghidra.app.plugin.processors.sleigh.pattern.ContextPattern;
import ghidra.app.plugin.processors.sleigh.pattern.InstructionPattern;
import ghidra.app.plugin.processors.sleigh.pattern.Pattern;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public abstract class DisjointPattern
extends Pattern {
    public abstract PatternBlock getBlock(boolean var1);

    public PatternBlock getInstructionBlock() {
        return this.getBlock(false);
    }

    public PatternBlock getContextBlock() {
        return this.getBlock(true);
    }

    public byte[] getWholeInstructionBytes() {
        return this.getInstructionBlock().getWholeBytes();
    }

    @Override
    public int numDisjoint() {
        return 0;
    }

    @Override
    public DisjointPattern getDisjoint(int i) {
        return null;
    }

    public int getMask(int startbit, int size, boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getMask(startbit, size);
        }
        return 0;
    }

    public int getValue(int startbit, int size, boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getValue(startbit, size);
        }
        return 0;
    }

    public int getLength(boolean context) {
        PatternBlock block = this.getBlock(context);
        if (block != null) {
            return block.getLength();
        }
        return 0;
    }

    public boolean specializes(DisjointPattern op2) {
        PatternBlock a = this.getBlock(false);
        PatternBlock b = op2.getBlock(false);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.specializes(b)) {
                return false;
            }
        }
        a = this.getBlock(true);
        b = op2.getBlock(true);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.specializes(b)) {
                return false;
            }
        }
        return true;
    }

    public boolean identical(DisjointPattern op2) {
        PatternBlock a = this.getBlock(false);
        PatternBlock b = op2.getBlock(false);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.identical(b)) {
                return false;
            }
        }
        a = this.getBlock(true);
        b = op2.getBlock(true);
        if (b != null) {
            if (a == null) {
                return false;
            }
            if (!a.identical(b)) {
                return false;
            }
        }
        return true;
    }

    public static DisjointPattern restoreDisjoint(XmlPullParser parser) {
        XmlElement el = parser.peek();
        DisjointPattern res = el.getName().equals("instruct_pat") ? new InstructionPattern() : (el.getName().equals("context_pat") ? new ContextPattern() : new CombinePattern());
        ((Pattern)res).restoreXml(parser);
        return res;
    }
}

