/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import javax.swing.tree.TreePath;

public class GTreeExpandPathsTask
extends GTreeTask {
    private final List<TreePath> paths;

    public GTreeExpandPathsTask(GTree gTree, List<TreePath> paths) {
        super(gTree);
        this.paths = paths;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage("Expanding Paths");
        monitor.initialize((long)this.paths.size());
        for (TreePath path : this.paths) {
            this.ensurePathLoaded(path, monitor);
            this.expandPath(path, monitor);
            monitor.incrementProgress(1L);
        }
    }

    private void ensurePathLoaded(TreePath path, TaskMonitor monitor) {
        GTreeNode parent = this.tree.getViewRoot();
        if (parent == null) {
            return;
        }
        Object[] nodeList = path.getPath();
        if (nodeList.length < 2) {
            return;
        }
        List<GTreeNode> allChildren = parent.getChildren();
        for (int i = 1; i < nodeList.length; ++i) {
            if (monitor.isCancelled()) {
                return;
            }
            GTreeNode node = this.findNode(allChildren, (GTreeNode)nodeList[i]);
            if (node == null) {
                return;
            }
            allChildren = node.getChildren();
            parent = node;
        }
    }

    private GTreeNode findNode(List<GTreeNode> children, GTreeNode node) {
        for (GTreeNode childNode : children) {
            if (!childNode.equals(node)) continue;
            return childNode;
        }
        return null;
    }

    private void expandPath(TreePath treePath, TaskMonitor monitor) {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            TreePath validatedPath = treePath;
            GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
            if (node.isLeaf()) {
                Object[] path = treePath.getPath();
                if (path.length <= 1) {
                    return;
                }
                Object[] newPath = new Object[path.length - 1];
                System.arraycopy(path, 0, newPath, 0, path.length - 1);
                validatedPath = new TreePath(newPath);
            }
            this.jTree.expandPath(validatedPath);
        });
    }
}

