/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.StatusBarSpacer;
import docking.util.AnimationUtils;
import docking.widgets.EmptyBorderButton;
import docking.widgets.label.GDLabel;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import generic.util.WindowUtilities;
import ghidra.util.ColorUtils;
import ghidra.util.DateUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.MiddleLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.animation.timing.Animator;

public class StatusBar
extends JPanel {
    private static final Border STATUS_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(1, 2, 1, 2));
    private static final Border STATUS_ITEM_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0), STATUS_BORDER);
    private static final int STATUS_BAR_GAP = 3;
    private static final int MESSAGE_QUEUE_MAX_SIZE = 10;
    private Animator animator;
    private JPanel homeButtonPanel;
    private JPanel statusAreaPanel;
    private JLabel statusLabel;
    private int minHeight;
    private LinkedList<String> messageQueue = new LinkedList();
    private Timer messageFadeTimer = new FadeTimer();
    private Timer flashTimer = new FlashTimer();
    private Timer animationDelayTimer = new AnimationDelayTimer();

    StatusBar() {
        super(new BorderLayout());
        int borderPadding = 3;
        this.setBorder(BorderFactory.createEmptyBorder(borderPadding, 0, 0, 0));
        this.homeButtonPanel = new JPanel(new BorderLayout());
        this.add((Component)this.homeButtonPanel, "West");
        this.statusAreaPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        JPanel eastPanel = this.createEastPanel(this.statusAreaPanel);
        this.add((Component)eastPanel, "East");
        this.statusLabel = new GDLabel(" ");
        this.statusLabel.setOpaque(true);
        this.statusLabel.setName("Tool Status");
        this.statusLabel.setAlignmentX(0.0f);
        JPanel statusMessagePanel = new JPanel(new BorderLayout());
        statusMessagePanel.setBorder(STATUS_BORDER);
        statusMessagePanel.add((Component)this.statusLabel, "Center");
        this.add((Component)statusMessagePanel, "Center");
        Dimension size = this.statusLabel.getPreferredSize();
        int topAndBottomPadding = 6;
        this.minHeight = size.height + borderPadding + topAndBottomPadding;
    }

    private JPanel createEastPanel(JPanel statusPanel) {
        JPanel eastPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        eastPanel.add(statusPanel);
        eastPanel.add(new StatusBarSpacer());
        return eastPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, this.minHeight);
    }

    void setHomeButton(Icon icon, Runnable callback) {
        int count = this.homeButtonPanel.getComponentCount();
        SystemUtilities.assertTrue((count == 0 ? 1 : 0) != 0, (String)"Can only set the home button once");
        EmptyBorderButton button = new EmptyBorderButton(icon);
        button.addActionListener(e -> callback.run());
        button.setToolTipText("Press to show the primary application window");
        this.homeButtonPanel.add(button);
    }

    void addStatusItem(JComponent c, boolean addBorder, boolean rightSide) {
        StatusPanel p = new StatusPanel(c, addBorder);
        p.setName(c.getName());
        this.minHeight = Math.max(this.minHeight, ((JComponent)p).getPreferredSize().height + 3);
        if (rightSide) {
            this.statusAreaPanel.add(p);
        } else {
            this.statusAreaPanel.add((Component)p, 0);
        }
    }

    public void removeStatusItem(JComponent c) {
        this.statusAreaPanel.remove(c.getParent());
    }

    public String getStatusText() {
        return this.statusLabel.getText();
    }

    @Deprecated
    public void setStatusText(String text, boolean isActiveWindow) {
        this.setStatusText(text);
    }

    public void setStatusText(String text) {
        Swing.runLater(() -> this.doSetStatusText(text));
    }

    private void doSetStatusText(String text) {
        if (text == null) {
            return;
        }
        this.addMessageToQueue(text);
        String updatedText = this.fixupMultilineText(text);
        this.statusLabel.setText(updatedText);
        this.statusLabel.setToolTipText(this.getToolTipText());
        this.statusLabel.setForeground((Color)GThemeDefaults.Colors.FOREGROUND);
        if (StringUtils.isBlank((CharSequence)updatedText)) {
            return;
        }
        Window window = WindowUtilities.windowForComponent((Component)this.statusLabel);
        if (!window.isActive()) {
            return;
        }
        this.transitionMessage();
        this.flashTimer.restart();
        this.messageFadeTimer.restart();
    }

    private void transitionMessage() {
        if (this.animator != null && this.animator.isRunning()) {
            return;
        }
        if (this.animationDelayTimer.isRunning()) {
            this.animationDelayTimer.restart();
            return;
        }
        Window activeWindow = WindowUtilities.windowForComponent((Component)this.statusLabel);
        if (activeWindow == null) {
            return;
        }
        this.animator = AnimationUtils.transitionUserFocusToComponent(activeWindow, this.statusLabel);
        this.animationDelayTimer.restart();
    }

    private String fixupMultilineText(String text) {
        String[] lines = text.split("\n");
        if (lines.length == 1) {
            return text;
        }
        return lines[0] + " [more]";
    }

    public void clearStatusMessages() {
        this.statusLabel.setText("");
        this.messageQueue.clear();
        this.repaint();
    }

    private void addMessageToQueue(String message) {
        if (message != null && message.trim().length() != 0) {
            if (message.endsWith("\n")) {
                message = message.substring(0, message.length() - 1);
            }
            this.messageQueue.add(0, message + " [" + DateUtils.formatCurrentTime() + "]");
            if (this.messageQueue.size() > 10) {
                this.messageQueue.removeLast();
            }
        }
    }

    @Override
    public String getToolTipText() {
        if (this.messageQueue.size() > 0) {
            StringBuffer buffer = new StringBuffer("<HTML>");
            Iterator iter = this.messageQueue.iterator();
            int i = 0;
            while (iter.hasNext()) {
                if (i > 0) {
                    buffer.append("<BR>");
                }
                String message = (String)iter.next();
                message = HTMLUtilities.lineWrapWithHTMLLineBreaks((String)message);
                buffer.append(message);
                ++i;
            }
            return buffer.toString();
        }
        return super.getToolTipText();
    }

    private class FadeTimer
    extends Timer
    implements ActionListener {
        private Map<Color, Color> fadeColorMap;

        private FadeTimer() {
            super(5000, null);
            this.fadeColorMap = new HashMap<Color, Color>();
            this.addActionListener(this);
        }

        private void initFadeColors() {
            int value = 0;
            int delta = 16;
            if (Gui.isDarkTheme()) {
                value = 128;
                delta = -16;
            }
            Color start = ColorUtils.getColor((int)value, (int)value, (int)value);
            this.fadeColorMap.put(StatusBar.this.statusLabel.getForeground(), start);
            for (int i = 0; i < 8; ++i) {
                Color from = ColorUtils.getColor((int)value, (int)value, (int)value);
                Color to = ColorUtils.getColor((int)(value += delta), (int)value, (int)value);
                this.fadeColorMap.put(from, to);
            }
        }

        @Override
        public void restart() {
            this.initFadeColors();
            super.restart();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Color nextFadeColor = this.fadeColorMap.get(StatusBar.this.statusLabel.getForeground());
            if (nextFadeColor != null) {
                StatusBar.this.statusLabel.setForeground(nextFadeColor);
            } else {
                this.stop();
            }
        }
    }

    private class FlashTimer
    extends Timer
    implements ActionListener {
        private static final int MAX_FLASH_COUNT = 6;
        private Color defaultFGColor;
        int flashCount;

        private FlashTimer() {
            super(500, null);
            this.flashCount = 0;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.flashCount < 6) {
                this.contrastStatusLabelColors();
                ++this.flashCount;
            } else {
                this.stop();
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.revertLabelColors();
            this.flashCount = 0;
        }

        private Color createContrastingColor(Color color) {
            if (this.defaultFGColor == null) {
                this.defaultFGColor = StatusBar.this.statusLabel.getForeground();
            }
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            return ColorUtils.getColor((int)(255 - red), (int)(255 - green), (int)(255 - blue));
        }

        private void contrastStatusLabelColors() {
            StatusBar.this.statusLabel.setForeground(this.createContrastingColor(StatusBar.this.statusLabel.getForeground()));
        }

        private void revertLabelColors() {
            StatusBar.this.statusLabel.setForeground(this.defaultFGColor);
        }
    }

    private class AnimationDelayTimer
    extends Timer
    implements ActionListener {
        public AnimationDelayTimer() {
            super(5000, null);
            this.addActionListener(this);
            this.setRepeats(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    static class StatusPanel
    extends JPanel {
        Dimension prefSize;

        StatusPanel(Component c, boolean addBorder) {
            super((LayoutManager)new MiddleLayout());
            if (addBorder) {
                this.setBorder(STATUS_ITEM_BORDER);
            }
            this.add(c, "Center");
            this.prefSize = super.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.prefSize;
        }
    }
}

