/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ActionToGuiMapper;
import docking.CloseIcon;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockableComponent;
import docking.DockableHeader;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.DropDownMenuIcon;
import docking.GenericHeader;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingType;
import docking.action.ToolBarData;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.MenuManager;
import docking.menu.ToolBarItemManager;
import docking.menu.ToolBarManager;
import generic.theme.GColor;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class DockableToolBarManager {
    private static final Color BUTTON_COLOR = new GColor("color.fg.button");
    private static final Icon CLOSE_ICON = new CloseIcon(false, BUTTON_COLOR);
    private Icon MENU_ICON = new DropDownMenuIcon(BUTTON_COLOR);
    private GenericHeader dockableHeader;
    private ToolBarManager toolBarManager;
    private MenuGroupMap menuGroupMap;
    private MenuManager menuManager;
    private ToolBarItemManager menuButtonManager;
    private ToolBarItemManager closeButtonManager;
    private SwingUpdateManager headerUpdater = new SwingUpdateManager(() -> this.dockableHeader.update());
    private DockableComponent dockableComponent;

    DockableToolBarManager(GenericHeader header) {
        this.dockableHeader = header;
        this.menuButtonManager = new ToolBarItemManager(new ToolBarMenuAction(), null);
        this.initialize(null, null, Collections.emptyIterator());
    }

    DockableToolBarManager(DockableComponent dockableComponent, DockableHeader header) {
        this.dockableComponent = dockableComponent;
        this.dockableHeader = header;
        ComponentPlaceholder placeholder = dockableComponent.getComponentWindowingPlaceholder();
        DockingWindowManager winMgr = dockableComponent.getDockingWindowManager();
        ActionToGuiMapper actionManager = winMgr.getActionToGuiMapper();
        this.menuGroupMap = actionManager.getMenuGroupMap();
        MenuHandler menuHandler = actionManager.getMenuHandler();
        Iterator<DockingActionIf> iter = placeholder.getActions();
        this.initialize(winMgr, menuHandler, iter);
        ComponentProvider provider = placeholder.getProvider();
        String owner = provider.getOwner();
        ToolBarCloseAction closeAction = new ToolBarCloseAction(owner);
        this.closeButtonManager = new ToolBarItemManager(closeAction, winMgr);
        ToolBarMenuAction dropDownAction = new ToolBarMenuAction(owner);
        this.menuButtonManager = new ToolBarItemManager(dropDownAction, winMgr);
        Tool tool = winMgr.getTool();
        tool.addLocalAction(provider, closeAction);
        tool.addLocalAction(provider, dropDownAction);
    }

    private void initialize(DockingWindowManager winMgr, MenuHandler menuHandler, Iterator<DockingActionIf> actions) {
        this.toolBarManager = new ToolBarManager(winMgr);
        this.menuManager = new MenuManager(null, '\u0000', null, false, menuHandler, this.menuGroupMap);
        while (actions.hasNext()) {
            DockingActionIf action = actions.next();
            this.addAction(action);
        }
        this.updateToolBar();
    }

    JComponent getToolBar() {
        return this.toolBarManager.getToolBar();
    }

    JComponent getMenuCloseToolBar() {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        if (this.closeButtonManager == null) {
            return panel;
        }
        if (!this.toolBarManager.isEmpty()) {
            panel.add(DockingUtils.createToolbarSeparator());
        }
        if (!this.menuManager.isEmpty()) {
            panel.add(this.menuButtonManager.getButton());
        }
        panel.add(this.closeButtonManager.getButton());
        return panel;
    }

    void addAction(DockingActionIf action) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("Actions must be added from Swing thread");
        }
        if (action.getMenuBarData() != null) {
            this.menuManager.addAction(action);
        }
        if (action.getToolBarData() != null) {
            this.toolBarManager.addAction(action);
        }
        this.updateToolBar();
    }

    synchronized DockingActionIf getAction(String name) {
        DockingActionIf action = this.menuManager.getAction(name);
        if (action != null) {
            return action;
        }
        return this.toolBarManager.getAction(name);
    }

    void removeAction(DockingActionIf action) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("Actions must be removed from Swing thread");
        }
        this.menuManager.removeAction(action);
        this.toolBarManager.removeAction(action);
        this.updateToolBar();
    }

    private void updateToolBar() {
        this.headerUpdater.update();
    }

    void dispose() {
        if (this.dockableComponent != null) {
            DockingWindowManager dwm = this.dockableComponent.getDockingWindowManager();
            Tool tool = dwm.getTool();
            ComponentProvider provider = this.dockableComponent.getComponentProvider();
            tool.removeLocalAction(provider, this.closeButtonManager.getAction());
            tool.removeLocalAction(provider, this.menuButtonManager.getAction());
        }
        this.headerUpdater.dispose();
        this.menuManager.dispose();
        this.toolBarManager.dispose();
    }

    private class ToolBarMenuAction
    extends DockingAction {
        private JButton myButton;

        ToolBarMenuAction() {
            super("Local Menu", "DockingWindows");
            this.setDescription("Menu");
            this.setToolBarData(new ToolBarData(DockableToolBarManager.this.MENU_ICON, null));
            this.markHelpUnnecessary();
        }

        ToolBarMenuAction(String owner) {
            super("Local Menu", owner, KeyBindingType.SHARED);
            this.setDescription("Menu");
            this.setToolBarData(new ToolBarData(DockableToolBarManager.this.MENU_ICON, null));
            this.markHelpUnnecessary();
        }

        @Override
        protected JButton doCreateButton() {
            this.myButton = super.doCreateButton();
            return this.myButton;
        }

        @Override
        public void actionPerformed(ActionContext context) {
            Dimension d = this.myButton.getSize();
            JPopupMenu popupMenu = DockableToolBarManager.this.menuManager.getPopupMenu();
            popupMenu.addPopupMenuListener(DockableToolBarManager.this.menuManager.getMenuHandler());
            popupMenu.show(this.myButton, 0, d.height);
        }

        @Override
        public boolean isEnabledForContext(ActionContext context) {
            if (this.myButton == null) {
                return false;
            }
            ComponentProvider provider = context.getComponentProvider();
            return provider == DockableToolBarManager.this.dockableComponent.getComponentProvider();
        }
    }

    private class ToolBarCloseAction
    extends DockingAction {
        ToolBarCloseAction(String owner) {
            super("Close Window", owner, KeyBindingType.SHARED);
            this.setDescription("Close Window");
            this.setToolBarData(new ToolBarData(CLOSE_ICON, null));
            this.markHelpUnnecessary();
        }

        @Override
        public void actionPerformed(ActionContext context) {
            ComponentPlaceholder placeholder = DockableToolBarManager.this.dockableComponent.getComponentWindowingPlaceholder();
            if (placeholder != null) {
                placeholder.close();
            }
        }

        @Override
        public boolean isEnabledForContext(ActionContext context) {
            ComponentProvider provider = context.getComponentProvider();
            return provider == DockableToolBarManager.this.dockableComponent.getComponentProvider();
        }
    }
}

