/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.Range;
import db.util.ErrorHandler;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreKeySet;
import ghidra.util.database.DirectedIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;

public class DBCachedObjectStoreKeySubSet
extends DBCachedObjectStoreKeySet {
    protected final Range<Long> keyRange;

    public DBCachedObjectStoreKeySubSet(DBCachedObjectStore<?> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction, Range<Long> keyRange) {
        super(store, errHandler, lock, direction);
        this.keyRange = keyRange;
    }

    @Override
    public Long first() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.first(this.direction, this.keyRange));
    }

    @Override
    public Long last() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.last(this.direction, this.keyRange));
    }

    @Override
    public int size() {
        return this.store.getKeyCount(this.keyRange);
    }

    @Override
    public boolean isEmpty() {
        return !this.store.getKeysExist(this.keyRange);
    }

    @Override
    public boolean contains(Object o) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.contains(o, this.keyRange));
    }

    @Override
    public Object[] toArray() {
        return this.store.keys.toArray(this.direction, this.keyRange);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.store.keys.toArray(this.direction, this.keyRange, a, this.store.getKeyCount(this.keyRange));
    }

    @Override
    public boolean remove(Object o) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.keys.remove(o, this.keyRange));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.containsAll(c, this.keyRange));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.store.keys.retain(c, this.keyRange);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.keys.removeAll(c, this.keyRange));
    }

    @Override
    public void clear() {
        this.store.deleteKeys(this.keyRange);
    }

    @Override
    public Long lower(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.lower(this.direction, e, this.keyRange));
    }

    @Override
    public Long floor(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.floor(this.direction, e, this.keyRange));
    }

    @Override
    public Long ceiling(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.ceiling(this.direction, e, this.keyRange));
    }

    @Override
    public Long higher(Long e) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.higher(this.direction, e, this.keyRange));
    }

    @Override
    public Iterator<Long> iterator() {
        return this.store.keys.iterator(this.direction, this.keyRange);
    }

    @Override
    public DBCachedObjectStoreKeySubSet descendingSet() {
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction), this.keyRange);
    }

    @Override
    public Iterator<Long> descendingIterator() {
        return this.store.keys.iterator(DirectedIterator.Direction.reverse(this.direction), this.keyRange);
    }

    @Override
    public DBCachedObjectStoreKeySubSet subSet(Long fromElement, boolean fromInclusive, Long toElement, boolean toInclusive) {
        Range<Long> rng = DBCachedObjectStore.toRange(fromElement, fromInclusive, toElement, toInclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, (Range<Long>)this.keyRange.intersection(rng));
    }

    @Override
    public DBCachedObjectStoreKeySubSet headSet(Long toElement, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeHead(toElement, inclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, (Range<Long>)this.keyRange.intersection(rng));
    }

    @Override
    public DBCachedObjectStoreKeySubSet tailSet(Long fromElement, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeTail(fromElement, inclusive, this.direction);
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, (Range<Long>)this.keyRange.intersection(rng));
    }
}

