/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.Varnode;

public interface PcodeExecutorStatePiece<A, T> {
    default public void checkRange(AddressSpace space, long offset, int size) {
        try {
            new AddressRangeImpl(space.getAddress(offset), (long)size);
        }
        catch (AddressOutOfBoundsException | AddressOverflowException e) {
            throw new IllegalArgumentException("Given offset and length exceeds address space");
        }
    }

    public Language getLanguage();

    public PcodeArithmetic<A> getAddressArithmetic();

    public PcodeArithmetic<T> getArithmetic();

    default public void setVar(Register reg, T val) {
        Address address = reg.getAddress();
        this.setVar(address.getAddressSpace(), address.getOffset(), reg.getMinimumByteSize(), true, val);
    }

    default public void setVar(Varnode var, T val) {
        Address address = var.getAddress();
        this.setVar(address.getAddressSpace(), address.getOffset(), var.getSize(), true, val);
    }

    public void setVar(AddressSpace var1, A var2, int var3, boolean var4, T var5);

    default public void setVar(AddressSpace space, long offset, int size, boolean quantize, T val) {
        this.checkRange(space, offset, size);
        A aOffset = this.getAddressArithmetic().fromConst(offset, space.getPointerSize());
        this.setVar(space, aOffset, size, quantize, val);
    }

    default public void setVar(Address address, int size, boolean quantize, T val) {
        this.setVar(address.getAddressSpace(), address.getOffset(), size, quantize, val);
    }

    default public T getVar(Register reg, Reason reason) {
        Address address = reg.getAddress();
        return this.getVar(address.getAddressSpace(), address.getOffset(), reg.getMinimumByteSize(), true, reason);
    }

    default public T getVar(Varnode var, Reason reason) {
        Address address = var.getAddress();
        return this.getVar(address.getAddressSpace(), address.getOffset(), var.getSize(), true, reason);
    }

    public T getVar(AddressSpace var1, A var2, int var3, boolean var4, Reason var5);

    default public T getVar(AddressSpace space, long offset, int size, boolean quantize, Reason reason) {
        this.checkRange(space, offset, size);
        A aOffset = this.getAddressArithmetic().fromConst(offset, space.getPointerSize());
        return this.getVar(space, aOffset, size, quantize, reason);
    }

    default public T getVar(Address address, int size, boolean quantize, Reason reason) {
        return this.getVar(address.getAddressSpace(), address.getOffset(), size, quantize, reason);
    }

    public MemBuffer getConcreteBuffer(Address var1, PcodeArithmetic.Purpose var2);

    default public long quantizeOffset(AddressSpace space, long offset) {
        return space.truncateAddressableWordOffset(offset) * (long)space.getAddressableUnitSize();
    }

    public void clear();

    public static enum Reason {
        EXECUTE,
        INSPECT;

    }
}

