/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;

public class DefaultPcodeExecutorState<T>
implements PcodeExecutorState<T> {
    protected final PcodeExecutorStatePiece<T, T> piece;
    protected final PcodeArithmetic<T> arithmetic;

    public DefaultPcodeExecutorState(PcodeExecutorStatePiece<T, T> piece, PcodeArithmetic<T> arithmetic) {
        this.piece = piece;
        this.arithmetic = arithmetic;
    }

    public DefaultPcodeExecutorState(PcodeExecutorStatePiece<T, T> piece) {
        this(piece, piece.getArithmetic());
    }

    @Override
    public Language getLanguage() {
        return this.piece.getLanguage();
    }

    @Override
    public T getVar(AddressSpace space, T offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return this.piece.getVar(space, offset, size, quantize, reason);
    }

    @Override
    public void setVar(AddressSpace space, T offset, int size, boolean quantize, T val) {
        this.piece.setVar(space, offset, size, quantize, val);
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return this.piece.getConcreteBuffer(address, purpose);
    }

    @Override
    public void clear() {
        this.piece.clear();
    }
}

