/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.pcode.emu.InstructionDecoder;
import ghidra.pcode.emulate.InstructionDecodeException;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;

public class SleighInstructionDecoder
implements InstructionDecoder {
    private static final String DEFAULT_ERROR = "Unknown disassembly error";
    protected final PcodeExecutorState<?> state;
    protected final AddressFactory addrFactory;
    protected final Disassembler disassembler;
    protected String lastMsg = "Unknown disassembly error";
    protected InstructionBlock block;
    protected int lengthWithDelays;
    private Instruction instruction;

    public SleighInstructionDecoder(Language language, PcodeExecutorState<?> state) {
        this.state = state;
        this.addrFactory = language.getAddressFactory();
        DisassemblerMessageListener listener = msg -> {
            Msg.warn((Object)this, (Object)msg);
            this.lastMsg = msg;
        };
        this.disassembler = Disassembler.getDisassembler((Language)language, (AddressFactory)this.addrFactory, (TaskMonitor)TaskMonitor.DUMMY, (DisassemblerMessageListener)listener);
    }

    @Override
    public Instruction decodeInstruction(Address address, RegisterValue context) {
        this.lastMsg = DEFAULT_ERROR;
        this.block = this.disassembler.pseudoDisassembleBlock(this.state.getConcreteBuffer(address, PcodeArithmetic.Purpose.DECODE), context, 1);
        Instruction instruction = this.instruction = this.block == null ? null : this.block.getInstructionAt(address);
        if (this.instruction == null) {
            throw new InstructionDecodeException(this.lastMsg, address);
        }
        this.lengthWithDelays = this.computeLength();
        return this.instruction;
    }

    protected int computeLength() {
        int length = this.instruction.getLength();
        int slots = this.instruction.getDelaySlotDepth();
        Instruction ins = this.instruction;
        for (int i = 0; i < slots; ++i) {
            try {
                Address next = ins.getAddress().addNoWrap((long)ins.getLength());
                Instruction ni = this.block.getInstructionAt(next);
                if (ni == null) {
                    throw new InstructionDecodeException("Failed to parse delay slot instruction", next);
                }
                ins = ni;
                length += ins.getLength();
                continue;
            }
            catch (AddressOverflowException e) {
                throw new InstructionDecodeException("Delay slot would exceed address space", ins.getAddress());
            }
        }
        return length;
    }

    @Override
    public int getLastLengthWithDelays() {
        return this.lengthWithDelays;
    }

    @Override
    public Instruction getLastInstruction() {
        return this.instruction;
    }
}

