/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.ExpanderArrowExpansionListener;
import docking.widgets.ExpanderArrowExpansionVetoException;
import ghidra.util.datastruct.ListenerSet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;

public class ExpanderArrowPanel
extends JPanel {
    protected static final Polygon ARROW = new Polygon(new int[]{5, -5, -5}, new int[]{0, -5, 5}, 3);
    protected static final Dimension SIZE = new Dimension(16, 16);
    protected static final int ANIM_MILLIS = 80;
    protected static final int FRAME_MILLIS = 30;
    private final ListenerSet<ExpanderArrowExpansionListener> listeners = new ListenerSet<ExpanderArrowExpansionListener>(ExpanderArrowExpansionListener.class);
    private boolean expanded = false;
    private double animTheta;
    private boolean animActive = false;
    private long animTimeEnd;
    private double animThetaEnd;
    private double animThetaOverTimeRate;
    private final MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            ExpanderArrowPanel.this.toggle();
        }
    };

    public ExpanderArrowPanel() {
        this.addMouseListener(this.mouseListener);
    }

    public void addExpansionListener(ExpanderArrowExpansionListener listener) {
        this.listeners.add(listener);
    }

    public void removeExpansionListener(ExpanderArrowExpansionListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void animateTheta(double destTheta) {
        this.animTimeEnd = System.currentTimeMillis() + 80L;
        this.animThetaEnd = destTheta;
        this.animThetaOverTimeRate = (destTheta - this.animTheta) / 80.0;
        this.animActive = true;
        this.scheduleNextFrame();
    }

    public void toggle() {
        this.setExpanded(!this.expanded);
    }

    protected boolean fireChanging(boolean newExpanded) {
        try {
            ((ExpanderArrowExpansionListener)this.listeners.fire).changing(newExpanded);
        }
        catch (ExpanderArrowExpansionVetoException e) {
            return false;
        }
        return true;
    }

    protected void fireChanged() {
        ((ExpanderArrowExpansionListener)this.listeners.fire).changed(this.expanded);
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        if (!this.fireChanging(expanded)) {
            return;
        }
        double destTheta = expanded ? 1.5707963267948966 : 0.0;
        this.animateTheta(destTheta);
        this.expanded = expanded;
        this.fireChanged();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate((double)ExpanderArrowPanel.SIZE.width / 2.0, (double)ExpanderArrowPanel.SIZE.height / 2.0);
        g2.rotate(this.animTheta);
        g2.fillPolygon(ARROW);
        if (!this.animActive) {
            return;
        }
        long time = System.currentTimeMillis();
        double timeDiff = Math.max(0L, this.animTimeEnd - time);
        if (timeDiff != 0.0) {
            double thetaDiff = timeDiff * this.animThetaOverTimeRate;
            this.animTheta = this.animThetaEnd - thetaDiff;
            this.scheduleNextFrame();
            return;
        }
        this.animActive = false;
        if (this.animTheta != this.animThetaEnd) {
            this.animTheta = this.animThetaEnd;
            this.scheduleNextFrame();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return SIZE;
    }

    protected void scheduleNextFrame() {
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
        });
    }
}

