/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.methods;

import agent.frida.model.iface1.FridaModelTargetMethod;
import agent.frida.model.iface2.FridaModelTargetObject;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ModuleIntercept", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetModuleInterceptorImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetMethod {
    protected final TargetMethod.TargetParameterMap paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());

    public FridaModelTargetModuleInterceptorImpl(FridaModelTargetObject parent) {
        super(parent.getModel(), (TargetObject)parent, "intercept", "ModuleIntercept");
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", this.paramDescs), "Initialized");
    }

    protected Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription address = TargetMethod.ParameterDescription.create(String.class, (String)"Address", (boolean)true, (Object)"", (String)"Address", (String)"function address");
        TargetMethod.ParameterDescription onEnter = TargetMethod.ParameterDescription.create(String.class, (String)"OnEnter", (boolean)true, (Object)"", (String)"onEnter file", (String)"JS file with onEnter implemenation");
        TargetMethod.ParameterDescription onLeave = TargetMethod.ParameterDescription.create(String.class, (String)"OnLeave", (boolean)true, (Object)"", (String)"onLeave file", (String)"JS file with onLeave implemenation");
        TargetMethod.ParameterDescription name = TargetMethod.ParameterDescription.create(String.class, (String)"Name", (boolean)false, (Object)"intercept", (String)"name", (String)"name for future unload");
        TargetMethod.ParameterDescription script = TargetMethod.ParameterDescription.create(String.class, (String)"Script", (boolean)false, (Object)"", (String)"script", (String)"script to execute on result");
        map.put("Address", address);
        map.put("OnEnter", onEnter);
        map.put("OnLeave", onLeave);
        map.put("Name", name);
        map.put("Script", script);
        return map;
    }

    public CompletableFuture<Object> invoke(Map<String, ?> arguments) {
        Object address = (String)arguments.get("Address");
        if (!((String)address).startsWith("0x")) {
            address = "0x" + (String)address;
        }
        this.getManager().interceptFunction((String)address, arguments);
        return CompletableFuture.completedFuture(null);
    }
}

