/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaImport;
import agent.frida.model.iface2.FridaModelTargetImportContainer;
import agent.frida.model.impl.FridaModelTargetImportImpl;
import agent.frida.model.impl.FridaModelTargetModuleImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ImportContainer", elements={@TargetElementType(type=FridaModelTargetImportImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetImportContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetImportContainer {
    protected final FridaModelTargetModuleImpl module;

    public FridaModelTargetImportContainerImpl(FridaModelTargetModuleImpl module) {
        super(module.getModel(), (TargetObject)module, "Imports", "ImportContainer");
        this.module = module;
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listModuleImports(this.module.getModule()).thenAccept(byName -> {
            List symbols;
            FridaModelTargetImportContainerImpl fridaModelTargetImportContainerImpl = this;
            synchronized (fridaModelTargetImportContainerImpl) {
                symbols = byName.values().stream().map(this::getTargetImport).collect(Collectors.toList());
            }
            this.setElements(symbols, Map.of(), "Refreshed");
        });
    }

    @Override
    public synchronized FridaModelTargetImportImpl getTargetImport(FridaImport symbol) {
        TargetObject targetObject = this.getMapObject(symbol);
        if (targetObject != null) {
            FridaModelTargetImportImpl targetImport = (FridaModelTargetImportImpl)targetObject;
            targetImport.setModelObject(symbol);
            return targetImport;
        }
        return new FridaModelTargetImportImpl(this, symbol);
    }
}

