/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.manager.FridaError;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.evt.AbstractFridaCompletedCommandEvent;
import agent.frida.manager.evt.FridaCommandErrorEvent;
import agent.frida.manager.evt.FridaRunningEvent;
import agent.frida.manager.evt.FridaStateChangedEvent;
import agent.frida.manager.impl.FridaManagerImpl;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.util.Msg;

public class FridaContinueCommand
extends AbstractFridaCommand<Void> {
    private FridaProcess process;

    public FridaContinueCommand(FridaManagerImpl manager, FridaProcess process) {
        super(manager);
        this.process = process;
    }

    public FridaContinueCommand(FridaManagerImpl manager) {
        super(manager);
        this.process = null;
    }

    @Override
    public boolean handle(FridaEvent<?> evt, FridaPendingCommand<?> pending) {
        if (evt instanceof AbstractFridaCompletedCommandEvent && pending.getCommand().equals(this)) {
            pending.claim(evt);
            boolean b = evt instanceof FridaCommandErrorEvent || !pending.findAllOf(FridaRunningEvent.class).isEmpty();
            return b;
        }
        if (evt instanceof FridaRunningEvent) {
            pending.claim(evt);
            boolean b = !pending.findAllOf(AbstractFridaCompletedCommandEvent.class).isEmpty();
            return b;
        }
        return false;
    }

    @Override
    public Void complete(FridaPendingCommand<?> pending) {
        return null;
    }

    @Override
    public void invoke() {
        FridaError res;
        FridaError fridaError = res = this.process == null ? this.manager.getCurrentSession().resume() : this.process.resume();
        if (!res.success()) {
            Msg.error((Object)this, (Object)res.getDescription());
        }
        TargetExecutionStateful.TargetExecutionState state = TargetExecutionStateful.TargetExecutionState.RUNNING;
        this.manager.getClient().processEvent(new FridaStateChangedEvent(this.process, state));
    }
}

