/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatable;

import docking.widgets.table.GTable;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.ProjectDataTableModel;
import ghidra.framework.main.datatree.DataTreeDragNDropHandler;
import ghidra.framework.model.DomainFile;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ProjectDataTableDnDHandler
implements DragSourceListener,
DragGestureListener {
    private static final DataFlavor DOMAIN_FILE_LIST_FLAVOR = DataTreeDragNDropHandler.localDomainFileFlavor;
    static final DataFlavor[] ROW_DATA_FLAVORS = new DataFlavor[]{DOMAIN_FILE_LIST_FLAVOR};
    public static List<DomainFileInfo> selectedData;
    private GTable table;
    private ProjectDataTableModel model;

    ProjectDataTableDnDHandler(GTable table, ProjectDataTableModel model) {
        this.table = table;
        this.model = model;
        this.performMultiSelectionMouseFix();
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)table, 3, this);
    }

    /*
     * WARNING - void declaration
     */
    private void performMultiSelectionMouseFix() {
        void var6_13;
        void var6_11;
        MouseListener[] oldMouseListeners = this.table.getMouseListeners();
        MouseMotionListener[] oldMouseMotionListeners = this.table.getMouseMotionListeners();
        for (MouseListener mouseListener : oldMouseListeners) {
            this.table.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : oldMouseMotionListeners) {
            this.table.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        DnDMouseListener newListener = new DnDMouseListener();
        this.table.addMouseListener((MouseListener)newListener);
        this.table.addMouseMotionListener((MouseMotionListener)newListener);
        EventListener[] eventListenerArray = oldMouseListeners;
        int n = eventListenerArray.length;
        boolean bl = false;
        while (var6_11 < n) {
            MouseListener mouseListener = eventListenerArray[var6_11];
            this.table.addMouseListener(mouseListener);
            ++var6_11;
        }
        eventListenerArray = oldMouseMotionListeners;
        n = eventListenerArray.length;
        boolean bl2 = false;
        while (var6_13 < n) {
            EventListener eventListener = eventListenerArray[var6_13];
            this.table.addMouseMotionListener((MouseMotionListener)eventListener);
            ++var6_13;
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.table.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        this.setCursor(0, dse.getDragSourceContext());
    }

    private void setCursor(int action, DragSourceContext dragSourceContext) {
        Cursor cursor = DragSource.DefaultCopyNoDrop;
        switch (action) {
            case 1: {
                cursor = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                cursor = DragSource.DefaultMoveDrop;
                break;
            }
            case 0x40000000: {
                cursor = DragSource.DefaultLinkDrop;
            }
        }
        dragSourceContext.setCursor(cursor);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.setCursor(dsde.getDropAction(), dsde.getDragSourceContext());
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragEvent) {
        InputEvent ie = dragEvent.getTriggerEvent();
        int modifiers = ie.getModifiersEx();
        if ((modifiers & 0x800) != 0 || (modifiers & 0x1000) != 0) {
            return;
        }
        selectedData = this.createSelectionList(this.table);
        DomainFileTransferable transferable = new DomainFileTransferable(selectedData);
        Image image = this.getDragImage(selectedData);
        try {
            dragEvent.startDrag(DragSource.DefaultMoveDrop, image, new Point(0, 0), transferable, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    private Image getDragImage(List<DomainFileInfo> files) {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            return null;
        }
        Container parent = this.table.getParent();
        Dimension size = parent.getSize();
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setClip(0, 0, size.width, size.height);
        this.paintRecords(files, graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        Color treeBackground = this.table.getBackground();
        Color transparentTreeBackground = new Color(treeBackground.getRed(), treeBackground.getGreen(), treeBackground.getBlue(), 200);
        GradientPaint mask = new GradientPaint(0.0f, 0.0f, transparentTreeBackground, 0.0f, size.height >> 1, new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, size.width, size.height);
        return bufferedImage;
    }

    private void paintRecords(List<DomainFileInfo> records, Graphics g) {
        CellRendererPane rendererPane = new CellRendererPane();
        this.paintCells(records, rendererPane, g);
    }

    private void paintCells(List<DomainFileInfo> domainFileInfos, CellRendererPane rendererPane, Graphics g) {
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        Rectangle clip = g.getClipBounds();
        int yOffset = clip.y;
        int rowCount = domainFileInfos.size();
        int columnCount = this.table.getColumnCount();
        int modelRow = this.model.getRowIndex(domainFileInfos.get(0));
        Rectangle cellRect = this.table.getCellRect(modelRow, 0, false);
        int startYOffset = cellRect.y;
        for (int row = 0; row < rowCount; ++row) {
            if (clip.y + clip.height < yOffset - startYOffset) {
                return;
            }
            modelRow = this.model.getRowIndex(domainFileInfos.get(row));
            cellRect = this.table.getCellRect(modelRow, 0, false);
            cellRect.y -= startYOffset;
            yOffset += cellRect.height;
            for (int column = 0; column < columnCount; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                this.paintCell(rendererPane, g, cellRect, modelRow, column);
                cellRect.x += columnWidth;
            }
        }
    }

    private void paintCell(CellRendererPane rendererPane, Graphics g, Rectangle cellRect, int row, int column) {
        TableCellRenderer tableRenderer = this.table.getCellRenderer(row, column);
        Component component = this.table.prepareRenderer(tableRenderer, row, column);
        rendererPane.paintComponent(g, component, (Container)this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private List<DomainFileInfo> createSelectionList(GTable tableToSelect) {
        ArrayList<DomainFileInfo> list = new ArrayList<DomainFileInfo>();
        int[] rows = this.table.getSelectedRows();
        if (rows == null) {
            return list;
        }
        for (int row : rows) {
            list.add((DomainFileInfo)this.model.getRowObject(row));
        }
        return list;
    }

    private class DnDMouseListener
    extends MouseAdapter {
        private boolean consuming = false;
        private boolean didDrag = false;

        private DnDMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.consuming = this.maybeConsumeEvent(e);
            this.didDrag = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.consuming) {
                return;
            }
            this.maybeConsumeEvent(e);
            this.consuming = false;
            if (!this.didDrag) {
                ProjectDataTableDnDHandler.this.table.clearSelection();
                int row = ProjectDataTableDnDHandler.this.table.rowAtPoint(e.getPoint());
                ProjectDataTableDnDHandler.this.table.selectRow(row);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            e.consume();
            this.didDrag = true;
        }

        private boolean maybeConsumeEvent(MouseEvent e) {
            if (!this.isBasicLeftClick(e)) {
                return false;
            }
            int row = ProjectDataTableDnDHandler.this.table.rowAtPoint(e.getPoint());
            if (ProjectDataTableDnDHandler.this.table.isRowSelected(row)) {
                e.consume();
                return true;
            }
            return false;
        }

        private boolean isBasicLeftClick(MouseEvent e) {
            if (e.getButton() != 1) {
                return false;
            }
            if (e.getClickCount() > 1) {
                return false;
            }
            return !e.isControlDown() && !e.isAltDown() && !e.isShiftDown() && !e.isMetaDown();
        }
    }

    class DomainFileTransferable
    implements Transferable {
        private List<DomainFileInfo> list;

        DomainFileTransferable(List<DomainFileInfo> list) {
            this.list = list;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (DOMAIN_FILE_LIST_FLAVOR.equals(flavor)) {
                return this.getDomainFileList();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        private Object getDomainFileList() {
            ArrayList<DomainFile> domainFileList = new ArrayList<DomainFile>();
            for (DomainFileInfo domainFileInfo : this.list) {
                domainFileList.add(domainFileInfo.getDomainFile());
            }
            return domainFileList;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return ROW_DATA_FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DOMAIN_FILE_LIST_FLAVOR.equals(flavor);
        }
    }
}

