/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.ConsoleErrorDisplay;
import ghidra.util.DefaultErrorLogger;
import ghidra.util.ErrorDisplay;
import ghidra.util.ErrorLogger;
import ghidra.util.SystemUtilities;
import java.awt.Component;

public class Msg {
    private static ErrorLogger errorLogger = new DefaultErrorLogger();
    private static ErrorDisplay errorDisplay = new ConsoleErrorDisplay();

    private Msg() {
    }

    public static void setErrorLogger(ErrorLogger errLogger) {
        errorLogger = errLogger;
    }

    public static void setErrorDisplay(ErrorDisplay errDisplay) {
        errorDisplay = errDisplay;
    }

    public static void out(Object message) {
        System.err.println(message);
    }

    public static void trace(Object originator, Object message) {
        errorLogger.trace(originator, message);
    }

    public static void trace(Object originator, Object message, Throwable throwable) {
        errorLogger.trace(originator, message, throwable);
    }

    public static void debug(Object originator, Object message) {
        errorLogger.debug(originator, message);
    }

    public static void debug(Object originator, Object message, Throwable throwable) {
        errorLogger.debug(originator, message, throwable);
    }

    public static void info(Object originator, Object message) {
        errorLogger.info(originator, message);
    }

    public static void info(Object originator, Object message, Throwable throwable) {
        errorLogger.info(originator, message, throwable);
    }

    public static void showInfo(Object originator, Component parent, String title, Object message) {
        if (SystemUtilities.isInHeadlessMode()) {
            Msg.info(originator, message);
        } else {
            errorDisplay.displayInfoMessage(errorLogger, originator, parent, title, message);
        }
    }

    public static void warn(Object originator, Object message) {
        errorLogger.warn(originator, message);
    }

    public static void warn(Object originator, Object message, Throwable throwable) {
        errorLogger.warn(originator, message, throwable);
    }

    public static void showWarn(Object originator, Component parent, String title, Object message) {
        if (SystemUtilities.isInHeadlessMode()) {
            Msg.warn(originator, message);
        } else {
            errorDisplay.displayWarningMessage(errorLogger, originator, parent, title, message, null);
        }
    }

    public static void error(Object originator, Object message) {
        errorLogger.error(originator, message);
    }

    public static void error(Object originator, Object message, Throwable throwable) {
        errorLogger.error(originator, message, throwable);
    }

    public static void showError(Object originator, Component parent, String title, Object message) {
        if (SystemUtilities.isInHeadlessMode()) {
            Msg.error(originator, message);
        } else {
            errorDisplay.displayErrorMessage(errorLogger, originator, parent, title, message, null);
        }
    }

    public static void showError(Object originator, Component parent, String title, Object message, Throwable throwable) {
        if (SystemUtilities.isInHeadlessMode()) {
            Msg.error(originator, message, throwable);
        } else {
            errorDisplay.displayErrorMessage(errorLogger, originator, parent, title, message, throwable);
        }
    }
}

