/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.ssh;

import agent.gdb.pty.PtyChild;
import agent.gdb.pty.ssh.SshPtyEndpoint;
import agent.gdb.pty.ssh.SshPtySession;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import ghidra.dbg.util.ShellUtils;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.help.UnsupportedOperationException;

public class SshPtyChild
extends SshPtyEndpoint
implements PtyChild {
    private final ChannelExec channel;
    private String name;

    public SshPtyChild(ChannelExec channel, OutputStream outputStream, InputStream inputStream) {
        super(outputStream, inputStream);
        this.channel = channel;
    }

    @Override
    public SshPtySession session(String[] args, Map<String, String> env) throws IOException {
        String envStr = env == null ? "" : env.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" ")) + " ";
        String cmdStr = ShellUtils.generateLine(Arrays.asList(args));
        this.channel.setCommand(envStr + cmdStr);
        try {
            this.channel.connect();
        }
        catch (JSchException e2) {
            throw new IOException("SSH error", e2);
        }
        return new SshPtySession((Channel)this.channel);
    }

    private String getTtyNameAndStartNullSession() throws IOException {
        this.channel.setCommand("sh -c 'tty && ctrlc() { echo; } && trap ctrlc INT && while true; do sleep 2147483647; done'");
        try {
            this.channel.connect();
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
        byte[] buf = new byte[1024];
        for (int i = 0; i < 1024; ++i) {
            int chr = this.inputStream.read();
            if (chr == 10 || chr == -1) {
                return new String(buf, 0, i + 1, "UTF-8").trim();
            }
            buf[i] = (byte)chr;
        }
        throw new IOException("Expected pty name. Got " + new String(buf, 0, 1024, "UTF-8"));
    }

    @Override
    public String nullSession() throws IOException {
        if (this.name == null) {
            this.name = this.getTtyNameAndStartNullSession();
            if ("".equals(this.name)) {
                throw new IOException("Could not determine child remote tty name");
            }
        }
        Msg.debug((Object)this, (Object)("Remote SSH pty: " + this.name));
        return this.name;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("The child is not local");
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("The child is not local");
    }
}

